C
C
      SUBROUTINE CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +                   NRTOP,
     +                   FNAME, TITLE)
C
C ACTION : Check that a data file is formatted correctly
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/9/96
C          28/05/2002 added FNAME to argument list and TITLE2, VIEWER, etc
C          06/06/2002 added call to GETIOS     
C          21/02/2007 added INTENTS
C          02/08/2010 added .xls and .obj to forbidden extensions
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOUNT, IOS, NCBOT, NCMID,
     +                                    NCTOP, NRBOT, NRMID, NRTOP 
      CHARACTER (LEN = *), INTENT (IN) :: FNAME, TITLE
C
C Locals
C      
      INTEGER    ICOLOR, ISEND, NUMDEC, NUMTXT, NUMOPT
      PARAMETER (ICOLOR = 9, ISEND = 1, NUMTXT = 14, NUMOPT = 3)
      INTEGER    NUMBLD(NUMTXT), NUMPOS(NUMOPT)
      INTEGER    I, LEN200
      CHARACTER  ARROWC*4, ARROWR*4
      CHARACTER  DETAIL(7)*22, WORD1*8, TYPE3*3, TYPE4*4, SYMBOL(6)*8
      CHARACTER  OPTION(NUMOPT)*40, TEXT(NUMTXT)*100
      CHARACTER  BLANK*1, BLANK4*4, DOTS*3, PATH*1, PATTERN*1
      PARAMETER (BLANK = ' ', BLANK4 = '    ', DOTS = '...')
      LOGICAL    REPEET, THERE
      EXTERNAL   PUTBEL, TRIML1, TITLE2, VIEWER, SHOW_FILE_FORMATS,
     +           LEN200, LCASE1, PUTFAT, GETIOS
      DATA       DETAIL / 'Minimum no. columns = ',
     +                    'No. columns in file = ',
     +                    'Maximum no. columns = ',
     +                    'Minimum no. of rows = ',
     +                    'No. of rows in file = ',
     +                    'Maximum no. of rows = ',
     +                    'The number required = '/
      DATA       OPTION / 'View', 'Formats', 'Cancel' /
      DATA       NUMPOS / NUMOPT*1 /
C
C Ring the bell then record IOS and initialise TEXT and NUMBLD
C
      CALL PUTBEL
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (.NOT.THERE) THEN
         CALL PUTFAT ('File specified is missing')
         RETURN
      ENDIF
      WRITE (WORD1,'(I8)') IOS
      CALL TRIML1 (WORD1)
      WRITE (TEXT,100) WORD1
      DO I = 1, NUMTXT
         NUMBLD(I) = 0
      ENDDO
C
C Check the file extension
C
      I = LEN200(FNAME)
      IF (I.GT.3) THEN
         TYPE3 = FNAME(I - 2:I)
         CALL LCASE1 (TYPE3)
         IF (TYPE3.EQ.'.ps') TEXT(14) = 'This is a .ps file'
      ENDIF
      IF (I.GT.4) THEN
         TYPE4 = FNAME(I - 3:I)
         CALL LCASE1 (TYPE4)
         IF (TYPE4.EQ.'.eps' .OR. TYPE4.EQ.'.pdf' .OR.
     +       TYPE4.EQ.'.exe' .OR. TYPE4.EQ.'.dll' .OR.
     +       TYPE4.EQ.'.bat' .OR. TYPE4.EQ.'.cfg' .OR.
     +       TYPE4.EQ.'.bmp' .OR. TYPE4.EQ.'.jpg' .OR.
     +       TYPE4.EQ.'.png' .OR. TYPE4.EQ.'.pcx' .OR.
     +       TYPE4.EQ.'.xls' .OR. TYPE4.EQ.'.obj') THEN
            TEXT(14) = 'This is a '//type4//' file'
         ENDIF
      ENDIF
      IF (ICOUNT.EQ.1) THEN
C
C Error on the first line
C
         TEXT(4) =
     +'This file has an error in the title ... Check line 1'
      ELSEIF (ICOUNT.EQ.2) THEN
C
C Error on the second line or maybe a Postscript file
C
         IF (TITLE(1:2).EQ.'%!') THEN
            TEXT(4) =
     +'This file is a PostScript file (title = %!...) ... Check line 1'
         ELSE
            TEXT(4) =
     +'This file has an error in row/column dimensions... Check line 2'
            IF (IOS.EQ.0) THEN
C
C Something is wrong with the two integers read off line 2
C
               WRITE (SYMBOL(1),'(I8)') NCBOT
               WRITE (SYMBOL(2),'(I8)') NCMID
               WRITE (SYMBOL(3),'(I8)') NCTOP
               WRITE (SYMBOL(4),'(I8)') NRBOT
               WRITE (SYMBOL(5),'(I8)') NRMID
               WRITE (SYMBOL(6),'(I8)') NRTOP
               IF (NCMID.LT.NCBOT .OR. NCMID.GT.NCTOP) THEN
                  ARROWC = '****'
                  NUMBLD(7) = 1
               ELSE
                  ARROWC = BLANK4
               ENDIF
               IF (NRMID.LT.NRBOT .OR. NRMID.GT.NRTOP) THEN
                  ARROWR = '****'
                  NUMBLD(10) = 1
               ELSE
                  ARROWR = BLANK4
               ENDIF
C
C Write all the dimensions onto SYMBOL
C
               DO I = 1, 6
                  CALL TRIML1 (SYMBOL(I))
                  IF (I.EQ.2) THEN
                     TEXT(7) = ARROWC//DETAIL(I)//SYMBOL(I)
                  ELSEIF (I.EQ.5) THEN
                     TEXT(10) = ARROWR//DETAIL(I)//SYMBOL(I)
                  ELSE
                     TEXT(I + 5) = BLANK4//DETAIL(I)//SYMBOL(I)
                  ENDIF
               ENDDO
C
C Suppress 6, 7, 8 if column dimensions are OK
C
               IF (NCMID.GE.NCBOT .AND. NCMID.LE.NCTOP) THEN
                  TEXT(6) = DOTS
                  TEXT(7) = DOTS
                  TEXT(8) = DOTS
               ENDIF
C
C Suppress 9, 10, 11 if row dimensions are OK
C
               IF (NRMID.GE.NRBOT .AND. NRMID.LE.NRTOP) THEN
                  TEXT(9) = DOTS
                  TEXT(10) = DOTS
                  TEXT(11) = DOTS
               ENDIF
C
C Change 6, 8 if fixed column dimension violated
C
               IF (NCBOT.EQ.NCTOP .AND. NCMID.NE.NCBOT) THEN
                  TEXT(6) = DOTS
                  TEXT(8) = BLANK4//DETAIL(7)//SYMBOL(1)
                  NUMBLD(8) = 1
               ENDIF
C
C Change 9, 11 if fixed row dimension violated
C
               IF (NRBOT.EQ.NRTOP .AND. NRMID.NE.NRBOT) THEN
                  TEXT(9) = DOTS
                  TEXT(11) = BLANK4//DETAIL(7)//SYMBOL(4)
                  NUMBLD(11) = 1
               ENDIF
            ELSE
C
C The two integers have not been read successfully off line 2
C
               TEXT(6) =
     +'Line 2 does not contain the two integers required for dimensions'
               TEXT(8) =
     +'It may be a binary or text file but it is not a Simfit data file'
            ENDIF
         ENDIF
      ELSE
C
C There is an error reading a data element off line ICOUNT
C
         WRITE (WORD1,'(I8)') ICOUNT
         CALL TRIML1 (WORD1)
         TEXT(4) =
     +'An error has occurred reading data ... Check line number '//WORD1
      ENDIF
C
C Describe the error
C
      NUMBLD(1) = 1
      IF (IOS.EQ.0) THEN
         TEXT(12) = DOTS
         TEXT(13) = DOTS
      ELSE
         NUMBLD(12) = 1
         NUMBLD(13) = 1
         CALL GETIOS (IOS, TEXT(13))
      ENDIF
      NUMDEC = 1
      REPEET = .TRUE.
      DO WHILE (REPEET)
         CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMTXT, NUMOPT, NUMPOS,
     +                TEXT,
     +                OPTION)
         IF (NUMDEC.EQ.1) THEN
            PATH = BLANK
            PATTERN = BLANK
            CALL VIEWER (ISEND,
     +                   FNAME, PATH, PATTERN)
            NUMDEC = 2
         ELSEIF (NUMDEC.EQ.2) THEN
            CALL SHOW_FILE_FORMATS
            NUMDEC = 1
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
  100 FORMAT (
     + 'FATAL: file format error'
     +/'You should view the file and check the formatting'
     +/
     +/
     +/
     +/
     +/
     +/
     +/
     +/
     +/
     +/'I-O/execution-error/status-specifier (IOSTAT) =',1X,A
     +/'...'
     +/'...')
      END
C
C
