C
C
      SUBROUTINE CHKMEN (NSTART, NTEXT, NUMDEC, NUMOPT, NUMPOS,
     +                   SRNAME, TEXT, 
     +                   ABORT)
C
C ACTION: Check menu arguments for consistency
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 5/2/97
C         28/01/2007 derived from X_CHKMEN
C
C This subroutine checks all arguments passed to the Simfit menu routines
C to make sure the arguments are consistent. It should only be activated
C during program development and, if it reacts during normal use, then there
C is an error in the calling program which must be identified and put right.
C 
C NSTART: (input/unchanged) starting line for menu items in TEXT
C  NTEXT: (input/unchanged) total number of text lines
C NUMDEC: (input/unchanged) starting decision number
C NUMOPT: (input/unchanged) total number of menu items, i.e. options
C NUMPOS: (input/unchanged) position of hot key in menu item
C SRNAME: (input/unchanged) the calling subroutine
C   TEXT: (input/unchanged) text array i.e.header/options/trailer
C  ABORT: (output) error indicator  
C
      IMPLICIT NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NSTART, NTEXT, NUMDEC,
     +                                     NUMOPT, NUMPOS(NUMOPT) 
      CHARACTER (LEN = *), INTENT (IN)  :: SRNAME, TEXT(NTEXT)  
      LOGICAL,             INTENT (OUT) :: ABORT 
C
C Locals
C      
      EXTERNAL X_CHKMEN 
      CALL X_CHKMEN (NSTART, NTEXT, NUMDEC, NUMOPT, NUMPOS,
     +               SRNAME, TEXT, 
     +               ABORT)      
      END
C
C
