c
c
      subroutine copycp (isend, 
     +                   file1, file2,  
     +                   abort)
c
c action: copy curve or plot file (file1) to (file2) as text lines 
c author: w.g.bardsley, university of manchester, u.k. 28/04/2024
c
c isend = 1: file1 selected by user from file store, file2 provided
c isend = 2: file1 provided and file2 two provided
c
 
c
c arguments
c    
      integer,             intent (in)    :: isend
      character (len = *), intent (inout) :: file1, file2
      logical,             intent (out)   :: abort 
c
c locals
c      
      integer nin, nout, nrmax
      parameter (nin = 3, nout = 4, nrmax = 5000)
      integer ios, ncol, nrow
      double precision s(nrmax), x(nrmax), y(nrmax)
      character (len = 256) line, title
      character (len = 6  ) reading, writing
      logical op, there
      external datfil, isitmf, putadv
      close (unit = nin)
      close (unit = nout) 
      abort = .false.
c
c isend = 1: read in an existing curve fitting or plot file then check
c      
      if (isend.eq.1) then
         call datfil (nin, nrmax, nrow,
     +                s, x, y,
     +                file1, title,
     +                abort)
         close (unit = nin)
         close (unit = nout)
         if (abort) then 
            call putadv ('FILE1 input is not correctly formatted')
            return
         endif 
      endif
c
c isend = 1 or 2: always check that file1 is a curve fitting or plot file
c        
      if (isend.eq.1 .or. isend.eq.2) then
         close (unit = nin)
         close (unit = nout) 
         inquire (file = file1, exist = there, opened = op, 
     +   read = reading, iostat = ios)  
         if (ios.ne.0) then 
            call putadv ('FILE1 supplied to copycp cannot be opened')
            return
         elseif (.not.there) then
            call putadv ('FILE1 supplied to copycp does not exist') 
            return
         elseif (op) then
            call putadv ('FILE1 input to copycp is already connected')
            return
         elseif (reading.eq.'NO') then  
            call putadv ('FILE1 input to copyfl cannot be read')
            return
         endif             
         call isitmf (ncol, nrow,
     +                file1)
         if (nrow .gt. nrmax .or. nrow.lt.1 .or.
     +       ncol.lt.2 .or. ncol.gt.3) then
            if (nrow.gt.nrmax) call putadv ('Number of rows > 5000')
            if (nrow.lt.1) call putadv ('Number of rows < 1')  
            if (ncol.lt.2 .or. ncol.gt.3) call putadv 
     +('FILE1 must have either two or three columns')  
            close (unit = nin)
            close (unit = nout) 
            abort = .true.
            return
         endif   
      endif 
      close (unit = nin)
      close (unit = nout)
c
c isend = 1 or 2: check file2
c
      inquire (file = file2, exist = there, opened = op, 
     +write = writing, iostat = ios)  
      if (ios.ne.0) then 
         call putadv ('FILE2 input to copycp cannot be opened')
         return
      elseif (.not.there) then
         call putadv ('FILE2 input to copycp does not exist') 
         return
      elseif (op) then
         call putadv ('FILE2 input to copycp is already connected')
         return
      elseif (reading.eq.'NO') then  
         call putadv ('FILE2 input to copycp cannot be written to')
         return
      endif             
c
c isend = 1 or 2: copy file1 to file2
c      
      open (unit = nin, file = file1, iostat = ios) 
      open (unit = nout, file = file2, iostat = ios)
      do while (ios.eq.0)
         read (nin, '(a)', iostat = ios) line
         if (ios.eq.0) write (nout, '(a)', iostat = ios) trim(line)
      enddo     
      abort = .false.
      close (unit = nin)
      close (unit = nout)  
      end
c
c      