C
C
      SUBROUTINE COPYFG (MODE,
     +                   FILE1, FILE2, TEXT,
     +                   ABORT, CURVE, FIXCOL, FIXROW, LABEL, ORDER,
     +                   WEIGHT)
C
C ACTION : Copy, edit, etc depending on MODE ... really for graphics files
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/9/98
C          06/10/1998 added error indicators
C          11/10/1998 Derived from COPYFL by adding TEXT and CURVE, FIXCOL,
C                     FIXROW, LABEL, ORDER, WEIGHT to argument list to control
C                     W_EDITOR
C          14/08/1999 replaced w_editor by editor
C          26/02/2007 edited and added INTENTS 
C          19/04/2008 increased output format to E15.7
C
C          MODE = 1: Copy FILE1 to named file  FILE2
C          MODE = 2: Copy FILE1 to temporary   FILE2
C          MODE = 3: Copy FILE1 to named file  FILE2 ... after editing
C          MODE = 4: Copy FILE1 to temporary   FILE2 ... after editing
C          MODE = 5: Copy FILE1 to temporary   FILE2 ... after editing
C                    Then FILE1 overwritten by FILE2 ... edit/replace
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: MODE
      CHARACTER (LEN = *), INTENT (IN)    :: FILE1, TEXT
      CHARACTER (LEN = *), INTENT (INOUT) :: FILE2
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: CURVE, FIXCOL, FIXROW,
     +                                       LABEL, ORDER, WEIGHT
C
C Locals
C      
      INTEGER    I, IFAIL, IOS, J, NCOLS, NOUT1, NOUT2, NROWS
      INTEGER    IERROR, JERROR, KERROR, LERROR
      INTEGER    NCMAX, NRMAX
      PARAMETER (NCMAX = 16, NRMAX = 10000)
      INTEGER    ISEND, ITYPE
      PARAMETER (ISEND = 2, ITYPE = 1)
      DOUBLE PRECISION X(NRMAX, NCMAX)
      CHARACTER  LINE*100, TITLE*80
      EXTERNAL   GETTMP, EDITOR, GETNOU, PUTFAT
C
C Initialise ABORT and error indicators then check
C
      ABORT = .TRUE.
      IERROR = 1
      JERROR = 0
      KERROR = 0
      LERROR = 0
      NOUT1 = 12
      NOUT2 = 12
      IOS = 0
      IF (MODE.LT.1 .OR. MODE.GT.5) THEN
         CALL PUTFAT ('MODE out of range in call to COPYFG')
         RETURN
      ELSEIF (MODE.EQ.2 .OR. MODE.EQ.4 .OR. MODE.EQ.5) THEN
C
C Invent a temporary filename
C
         CALL GETTMP (IFAIL, 
     +                FILE2)
         IF (IFAIL.NE.0) GOTO 40
      ENDIF
C
C Open units NOUT1 and NOUT2
C
      CALL GETNOU (NOUT1)
      IERROR = 2
      IF (NOUT1.LT.1 .OR. NOUT1.GT.100) GOTO 40
      CLOSE (UNIT = NOUT1)
      OPEN (UNIT = NOUT1, FILE = FILE1, IOSTAT = IOS)
      IERROR = 3
      IF (IOS.NE.0) GOTO 40
      CALL GETNOU (NOUT2)
      IERROR = 4
      IF (NOUT2.LT.1 .OR. NOUT2.GT.100) GOTO 40
      CLOSE (UNIT = NOUT2)
      OPEN (UNIT = NOUT2, FILE = FILE2, IOSTAT = IOS)
      IERROR = 5
      IF (IOS.NE.0) GOTO 40
C
C Read the title and header
C
      IERROR = 6
      READ (NOUT1,'(A)',END=40,ERR=40,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 40
      IERROR = 7
      WRITE (NOUT2,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 40
      IERROR = 8
      READ (NOUT1,*,END=40,ERR=40,IOSTAT=IOS) NROWS, NCOLS
      IF (IOS.NE.0) GOTO 40
      IERROR = 9
      IF (NCOLS.LT.1 .OR. NCOLS.GT.NCMAX .OR.
     +    NROWS.LT.1 .OR. NROWS.GT.NRMAX) GOTO 40
C
C Read data from FILE1 for copying/editing
C
      IERROR = 10
      DO I = 1, NROWS
         JERROR = JERROR + 1
         READ (NOUT1,*,END=40,ERR=40,IOSTAT=IOS) (X(I,J), J = 1, NCOLS)
         IF (IOS.NE.0) GOTO 40
      ENDDO
C
C Edit if required by MODE > 2
C
      IF (MODE.GT.2) THEN
         CALL EDITOR (ISEND, ITYPE, NCOLS, NRMAX, NROWS,
     +                X,
     +                TEXT,
     +                CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
      ENDIF
C
C Write new NROWS and NCOLS to FILE2
C
      WRITE (NOUT2,'(2I6)',IOSTAT=IOS) NROWS, NCOLS
      IERROR = 11
      IF (IOS.NE.0) GOTO 40
C
C Write original/edited data to FILE2
C
      IERROR = 12
      DO I = 1, NROWS
         KERROR = KERROR + 1
         WRITE (NOUT2,'(1P,50E15.7)',IOSTAT=IOS) (X(I,J), J = 1, NCOLS)
         IF (IOS.NE.0) GOTO 40
      ENDDO
C
C Add the rest of FILE1 to FILE2 ... the trailer
C
      IOS = 0
      IERROR = 13
      DO WHILE (IOS.EQ.0)
         READ (NOUT1,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         WRITE (NOUT2,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
      ENDDO
   20 CONTINUE
C
C Overwrite FILE1 by FILE2 if MODE = 5
C
      IF (MODE.EQ.5) THEN
          IERROR = 14
          REWIND (NOUT1)
          REWIND (NOUT2)
          IOS = 0
          DO WHILE (IOS.EQ.0)
             LERROR = LERROR + 1
             READ (NOUT2,'(A)',IOSTAT=IOS) TITLE
             IF (IOS.EQ.0) WRITE (NOUT1,'(A)',IOSTAT=IOS) TITLE
          ENDDO
      ENDIF
      CLOSE (UNIT = NOUT1)
      CLOSE (UNIT = NOUT2)
      ABORT = .FALSE.
      RETURN
C
C Here only if a crash has occurred
C
   40 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NOUT1)
      CLOSE (UNIT = NOUT2)
      WRITE (LINE,100) IERROR, JERROR, KERROR, LERROR, NOUT1, NOUT2, IOS
      CALL PUTFAT (LINE)
      CALL PUTFAT ('File absent, read-only or not formatted correctly')
  100 FORMAT ('COPYFG error code =',7I6)
      END
C
C
