C
C
      SUBROUTINE COPYFL (MODE,
     +                   FILE1, FILE2,
     +                   ABORT)
C
C ACTION : Copy, edit, etc. a SIMFIT data file depending on MODE
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/9/98
C          06/10/1998 added error indicators
C          14/08/1999 replaced w_editor by editor
C          03/02/2005 increased dimensions
C          22/06/2006 introduced allocatable array, TITLE*1024, I2FILE, 
C                     and output format 1P,50E13.5  
C          20/09/2006 corrected error defining FILE2 as OUT 
C          19/04/2008 increased output format to E15.7 
C
C Note: FILE2 is output in strict simfit format irrespective of the format 
C       for FILE1 (also MODE = 5 overwrites FILE1) but the line width in
C       FILE1 is restricted to 1024 characters
C
C       MODE: (input/unchanged) as follows:
C             MODE = 1: Copy FILE1 to named file  FILE2
C             MODE = 2: Copy FILE1 to temporary   FILE2
C             MODE = 3: Copy FILE1 to named file  FILE2 ... after editing
C             MODE = 4: Copy FILE1 to temporary   FILE2 ... after editing
C             MODE = 5: Copy FILE1 to temporary   FILE2 ... after editing
C                       Then FILE1 overwritten by FILE2 ... edit/replace
C       FILE1: (input/unchanged unless MODE = 5 when overwritten) input file
C       FILE2: (input/output) input, input/output, or output depending on MODE
C       ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: MODE
      CHARACTER (LEN = *), INTENT (IN)    :: FILE1
      CHARACTER (LEN = *), INTENT (INOUT) :: FILE2
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Local allocatable array
C
      DOUBLE PRECISION, ALLOCATABLE :: X(:,:)
C
C Locals
C
      INTEGER    I, IFAIL, IOS, J, NCOLS, NOUT1, NOUT2, NROWS
      INTEGER    IERR, IERROR, JERROR, KERROR, LERROR
      INTEGER    ISEND, ITYPE
      PARAMETER (ISEND = 2, ITYPE = 1)
      CHARACTER  LINE*100, TEXT*1, TITLE*1024
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .FALSE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   GETTMP, EDITOR, GETNOU, PUTFAT, I2FILE
C
C Initialise ABORT and error indicators then check
C
      ABORT = .TRUE.
      IERR = 0
      IERROR = 1
      JERROR = 0
      KERROR = 0
      LERROR = 0
      NOUT1 = 12
      NOUT2 = 12
      IOS = 0
      IF (MODE.LT.1 .OR. MODE.GT.5) THEN
         CALL PUTFAT ('MODE out of range in call to COPYFL')
         RETURN
      ELSEIF (MODE.EQ.2 .OR. MODE.EQ.4 .OR. MODE.EQ.5) THEN
C
C Invent a temporary filename
C
         CALL GETTMP (IFAIL, FILE2)
         IF (IFAIL.NE.0) GOTO 40
      ENDIF
C
C Open units NOUT1 and NOUT2
C
      CALL GETNOU (NOUT1)
      IERROR = 2
      IF (NOUT1.LT.1 .OR. NOUT1.GT.100) GOTO 40
      CLOSE (UNIT = NOUT1)
      OPEN (UNIT = NOUT1, FILE = FILE1, IOSTAT = IOS)
      IERROR = 3
      IF (IOS.NE.0) GOTO 40
      CALL GETNOU (NOUT2)
      IERROR = 4
      IF (NOUT2.LT.1 .OR. NOUT2.GT.100) GOTO 40
      CLOSE (UNIT = NOUT2)
      OPEN (UNIT = NOUT2, FILE = FILE2, IOSTAT = IOS)
      IERROR = 5
      IF (IOS.NE.0) GOTO 40
C
C Read the title and header
C
      IERROR = 6
      READ (NOUT1,'(A)',END=40,ERR=40,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 40
      IERROR = 7
      WRITE (NOUT2,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 40
      IERROR = 8
      READ (NOUT1,*,END=40,ERR=40,IOSTAT=IOS) NROWS, NCOLS
      IF (IOS.NE.0) GOTO 40
      IERROR = 9
      IF (NCOLS.LT.1 .OR. NROWS.LT.1) GOTO 40
      IERR = 0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) GOTO 40
      ALLOCATE(X(NROWS,NCOLS), STAT = IERR)
      IF (IERR.NE.0) GOTO 40
C
C Read data from FILE1 for copying/editing
C
      IERROR = 10
      DO I = 1, NROWS
         JERROR = JERROR + 1
         READ (NOUT1,*,END=40,ERR=40,IOSTAT=IOS) (X(I,J), J = 1, NCOLS)
         IF (IOS.NE.0) GOTO 40
      ENDDO
C
C Edit if required by MODE > 2
C
      IF (MODE.GT.2) THEN
         CALL EDITOR (ISEND, ITYPE, NCOLS, NROWS, NROWS,
     +                X,
     +                TEXT,
     +                CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
      ENDIF
C
C Write new NROWS and NCOLS to FILE2
C                                                     
      CALL I2FILE (NOUT2, NROWS, NCOLS)
C
C Write original/edited data to FILE2
C
      IERROR = 12
      DO I = 1, NROWS
         KERROR = KERROR + 1
         WRITE (NOUT2,'(1P,50E15.7)',IOSTAT=IOS) (X(I,J), J =1, NCOLS)
         IF (IOS.NE.0) GOTO 40
      ENDDO
C
C Add the rest of FILE1 to FILE2 ... the trailer
C
      IOS = 0
      IERROR = 13
      DO WHILE (IOS.EQ.0)
         READ (NOUT1,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         WRITE (NOUT2,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
      ENDDO
C
C LABEL 20: error-free exit
C =========
C      
   20 CONTINUE
C
C Overwrite FILE1 by FILE2 if MODE = 5
C
      IF (MODE.EQ.5) THEN
          IERROR = 14
          REWIND (NOUT1)
          REWIND (NOUT2)
          IOS = 0
          DO WHILE (IOS.EQ.0)
             LERROR = LERROR + 1
             READ (NOUT2,'(A)',IOSTAT=IOS) TITLE
             IF (IOS.EQ.0) WRITE (NOUT1,'(A)',IOSTAT=IOS) TITLE
          ENDDO
      ENDIF
      CLOSE (UNIT = NOUT1)
      CLOSE (UNIT = NOUT2)
      ABORT = .FALSE.
      DEALLOCATE(X, STAT = IERR)
      RETURN
C
C LABEL 40: Here only if a crash has occurred
C ========= 
C
   40 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NOUT1)
      CLOSE (UNIT = NOUT2)
      WRITE (LINE,100) IERROR, JERROR, KERROR, LERROR, NOUT1, NOUT2, IOS
      CALL PUTFAT (LINE)
      CALL PUTFAT ('File absent, read-only, or not formatted correctly')
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
  100 FORMAT ('COPYFL error code =',7I6)
      END
C
C
