c
c
      subroutine corcov (itype, ncol, nrmax, nout,
     +                   x,
     +                   title,
     +                   fileit)
c
c action: display a covariance or correlation matrix
c author: w.g.bardsley, university of manchester, u.k.
c         05/05/2016 increased output to 6 significant figures
c         12/12/2016 adjusted correlation coefficients to 5 decimal places
c         29/06/2021 added e_numbers and e_formats, etc.
c
c         itype: itype = 1, covariance matrix
c                itype = 2, correlation matrix
c                if itype is negative then only the corresponding lower triangle is shown
c          ncol: column dimension
c         nrmax: leading dimension
c          nout: pre-connected unit for results
c             x: matrix
c         title: data description
c        fileit: write output to results file
c   full_matrix: all matrix o/w lower triangle only
c
c Note: only the lower triangle is displayed with diagonal = 1 for correlation matrices
c         
      implicit none
c
c arguments
c      
      integer,             intent (in) :: itype, ncol, nrmax, nout
      double precision,    intent (in) :: x(nrmax,ncol)
      character (len = *), intent (in) :: title 
      logical,             intent (in) :: fileit   
c
c allocatable arrays
c  
      character (len = 9 ), allocatable :: cor(:,:)
      character (len = 13), allocatable :: cov(:,:)
c
c locals
c     
      integer    i, ierr, j, jtype, isend, n
      character (len = 9 ) blank9, one
      character (len = 13) blank13, showrj, temp
      parameter ( blank9 = '         ',
     +           blank13 = '             ',
     +               one = '  1      ')
      logical    abort
      logical    e_formats, e_numbers
      external   isitcv, putfat, matcov, matcor
      external   e_formats, showrj
      intrinsic  abs
c
c define jtype then check itype and dimensions
c      
      jtype = abs(itype)
      if (jtype.lt.1 .or. jtype.gt.2) then
         call putfat ('ITYPE out of range in call to CORCOV')
         return
      endif  
      if (ncol.lt.1 .or. ncol.gt.nrmax) then
         call putfat ('Dimensions inconsistent in call to CORCOV')
         return
      endif  
c
c check if it is the correct matrix type, isend = 3 cv, isend = 4 corr
c        
      isend = jtype + 2
      call isitcv (isend, ncol, nrmax, ncol,
     +             x,   
     +             abort)
      if (abort) return
      ierr = 0
      n = ncol     
      if (jtype.eq.1) then
c
c covariance matrix
c        
         if (allocated(cov)) deallocate (cov, stat = ierr)
         if (ierr.ne.0) return  
         allocate (cov(n,n), stat = ierr)
         if (ierr.ne.0) return  
         e_numbers = e_formats()  
         if (itype.lt.0) then  
            do i = 1, ncol
               do j = 1, i
                  if (e_numbers) then
                     write(cov(i,j),'(1p,e13.5)') x(i,j)
                  else
                     temp = showrj(x(i,j))
                     cov(i,j) = temp
                  endif   
               enddo    
               if (i.lt.ncol) then
                  do j = i + 1, ncol
                     cov(i,j) = blank13 
                  enddo   
               endif   
            enddo  
         else
            do j = 1, ncol
               do i = 1, ncol
                  if (e_numbers) then
                     write(cov(i,j),'(1p,e13.5)') x(i,j)
                  else
                     temp = showrj(x(i,j))
                     cov(i,j) = temp
                  endif      
               enddo    
            enddo  
         endif     
         call matcov (ncol, ncol, nout,
     +                cov, title,
     +                fileit)         
         deallocate(cov, stat = ierr)  
      else
c
c correlation matrix
c        
         if (allocated(cor)) deallocate (cor, stat = ierr)
         if (ierr.ne.0) return 
         allocate (cor(n,n), stat = ierr)
         if (ierr.ne.0) return 
         if (itype.lt.0) then  
            do i = 1, ncol
               do j = 1, i - 1
                  write(cor(i,j),'(f9.5)') x(i,j)
               enddo    
               cor(i,i) = one
               if (i.lt.ncol) then
                  do j = i + 1, ncol
                     cor(i,j) = blank9 
                  enddo   
               endif   
            enddo    
         else
            do j = 1, ncol
               do i = 1, ncol
                  if (i.eq.j) then
                     cor(i,i) = one
                  else   
                     write(cor(i,j),'(f9.5)') x(i,j)
                  endif   
               enddo    
            enddo    
         endif      
         call matcor (ncol, ncol, nout,
     +                cor, title,
     +                fileit)        

         deallocate (cor, stat = ierr)  
      endif 
      end
c
c         