C
C
      SUBROUTINE COXDAT (IC, ISI, LDZ, M, MXN, N, NCMAX, NIN, NRMAX, NS,
     +                   A, T, Z,
     +                   FNAME, TITLE,
     +                   ABORT, TPOS)
C
C ACTION: Read in a COX type data set and manipulate before calling G12ZAF
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 09/08/2002
C         16/11/2005 added TPOS to argument list
C         25/02/2007 added INTENTS 
C
C This subroutine accepts a Simfit matrix file formatted for survival analysis
C i.e. The input file format must be x1,x2,...,xm,y,t,s where
C x are covariates 1 to m
C y = 0 or 1 (corresponding to dead, censored)
C t > 0 (Time for death or censorship)
C s = 1,2,3,...,strata or (s = 0 for omit)
C Error exits with ABORT = .TRUE. will occur if the file is not formatted correctly
C e.g. t =< 0, y < 0, y > 1, s out of range, insufficient data, etc.
C If there is error exit ABORT = .TRUE. and TITLE = error message for use by
C the calling program
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: LDZ, MXN, NCMAX, NIN, NRMAX
      INTEGER,             INTENT (OUT) :: IC(NRMAX), ISI(NRMAX), M,
     +                                     N, NS
      DOUBLE PRECISION,    INTENT (OUT) :: A(NRMAX,NCMAX), T(NRMAX),
     +                                     Z(LDZ,NCMAX - 3)
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      CHARACTER (LEN = *), INTENT (OUT) :: TITLE 
      LOGICAL,             INTENT (IN)  :: TPOS
      LOGICAL,             INTENT (OUT) :: ABORT
      
C
C Locals
C
      INTEGER    I, IOS, J, K, L, NCM1, NCM2, NCOL, NROW
      INTEGER    NSTRAT
      PARAMETER (NSTRAT = 100)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  WORD22*22
      LOGICAL    THERE, STRATA(NSTRAT)
      INTRINSIC  NINT
C
C Set ABORT = .TRUE., set the default TITLE, then open the file and read the data
C
      ABORT = .TRUE.
      TITLE = 'ERROR 1 from COXDAT: File is missing'
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (.NOT.THERE) RETURN
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) THEN
         TITLE = 'ERROR 2 from COXDAT: Cannot open file'
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.0) THEN
         WRITE (WORD22,100) 1
         TITLE = 'ERROR 3 from COXDAT: Cannot read title'//WORD22
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      READ (NIN,*,IOSTAT=IOS) NROW, NCOL
      IF (IOS.NE.0) THEN
         WRITE (WORD22,100) 2
         TITLE =
     +  'ERROR 4 from COXDAT: Cannot read dimensions off file'//WORD22
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      IF (NROW.GT.LDZ .OR. NROW.LT.3 .OR. NCOL.LT.4 .OR.
     +    NCOL.GT.NCMAX) THEN
         WRITE (WORD22,100) 2
         TITLE = 'ERROR 5 from COXDAT: Dimensions wrong'//WORD22
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      DO I = 1, NROW
         READ (NIN,*,IOSTAT=IOS) (A(I,J), J = 1, NCOL)
         IF (IOS.NE.0) THEN
            WRITE (WORD22,100) I + 2
            TITLE =
     +     'ERROR 6 from COXDAT: Cannot read data off file'//WORD22
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF
      ENDDO
      CLOSE (UNIT = NIN)
C
C Examine the data in array A
C
      N = 0
      NCM1 = NCOL - 1
      NCM2 = NCOL - 2
      M = NCOL - 3
      DO I = 1, NROW
         J = NINT(A(I,NCOL))
         IF (J.GT.0) THEN
C
C Generate N, ISI, T, IC and Z
C
            N = N + 1
            ISI(N) = J
            T(N) = A(I,NCM1)
            IF (TPOS) THEN
C
C Check for T > 0 if required
C
               IF (T(N).LT.ZERO) THEN
                  WRITE (WORD22,100) I + 2
                  TITLE =
     +'ERROR 7 from COXDAT: negative time encountered'//WORD22
                  RETURN
               ENDIF
            ENDIF
            K = NINT(A(I,NCM2))
            IF (K.LT.0 .OR. K.GT.1) THEN
               WRITE (WORD22,100) I + 2
               TITLE = 'ERROR 8 from COXDAT: y value not 0 or 1'//WORD22
               RETURN
            ENDIF
            IC(N) = K
            DO L = 1, M
               Z(N,L) = A(I,L)
            ENDDO
         ENDIF
      ENDDO
      IF (N.LT.3) THEN
         TITLE = 'ERROR 9 from COXDAT: insufficient data'
         RETURN
      ELSEIF (N.GT.MXN) THEN
         TITLE = 'ERROR 10 from COXDAT: N > MXN'
         RETURN
      ENDIF
C
C Generate NS
C
      NS = 0
      DO I = 1, N
         IF (ISI(I).GT.NS) NS = ISI(I)
      ENDDO
      IF (NS.GT.NSTRAT) THEN
         TITLE = 'ERROR 11 from COXDAT: NS > NSTRAT, too many strata'
         RETURN
      ENDIF
      IF (NS.EQ.0) THEN
         TITLE = 'ERROR 12 from COXDAT: NS = 0, no strata'
         RETURN
      ENDIF
      DO I = 1, NS
         STRATA(I) = .FALSE.
      ENDDO
      DO I = 1, N
         STRATA(ISI(I)) = .TRUE.
      ENDDO
      DO I = 1, NS
         IF (.NOT.STRATA(I)) THEN
            TITLE = 'ERROR 13 from COXDAT: Strata level empty'
            RETURN
         ENDIF
      ENDDO
C
C Data set is OK so set ABORT = .FALSE.
C
      ABORT = .FALSE.
  100 FORMAT (': ... check line',I6)
      END
C
C
