c
c
      subroutine cpytrl (file1, file2,
     +                   abort)
c
c action: copy trailer from simfit data file file 1 to simfit data file file2
c author: w.g.bardsley, university of manchester, u.k., 10/07/08
c     
      implicit none
c
c arguments
c      
      character (len = *), intent (in)  :: file1, file2
      logical,             intent (out) :: abort 
c
c allocatable
c      
      double precision,     allocatable :: x(:)
c
c locals
c      
      integer   i, ierr, ios1, ios2, j, ncol1, ncol2, nout1, nout2,
     +          nmax, nrow1, nrow2
      character line*1024
      external  isitmf, getnou
      intrinsic max  
c
c initialise abort and check that file1 and file2 are simfit data files
c      
      abort = .true.
      call isitmf (ncol1, nrow1,
     +             file1)
      if (ncol1.le.0 .or. nrow1.le.0) return
        
      call isitmf (ncol2, nrow2,
     +             file2)
      if (ncol1.le.0 .or. nrow1.le.0) return  
c
c allocate space to read the rows
c        
      nmax = max(ncol1, ncol2)
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
      allocate (x(nmax), stat = ierr)
      if (ierr.ne.0) return
c
c open file1 and file2 and read down to the start of the data
c        
      call getnou (nout1)
      open (unit = nout1, file = file1, iostat = ios1) 
      if (ios1.eq.0) read (nout1,'(a)',iostat=ios1) line
      if (ios1.eq.0) read (nout1,*,iostat=ios1) nrow1, ncol1 
        
      call getnou (nout2)
      open (unit = nout2, file = file2, iostat = ios2) 
      if (ios2.eq.0) read (nout2,'(a)',iostat=ios2) line   
      if (ios2.eq.0) read (nout2,*,iostat=ios1) nrow2, ncol2 

      if (ios1.ne.0 .or. ios2.ne.0) then
         deallocate(x, stat = ierr)
         return
      endif
c
c read the data 
c
      do i = 1, nrow1
         if (ios1.eq.0) read (nout1,*,iostat=ios1) (x(j), j = 1, ncol1)
      enddo
      do i = 1, nrow2
         if (ios2.eq.0) read (nout2,*,iostat=ios1) (x(j), j = 1, ncol2)
      enddo         
      
      if (ios1.ne.0 .or. ios2.ne.0) then
         deallocate(x, stat = ierr)
         return
      endif
c
c copy trailer from file1 to file2
c
      do while (ios1.eq.0 .and. ios2.eq.0)
         read (nout1,'(a)',iostat=ios1) line
         if (ios1.eq.0) write (nout2,'(a)',iostat = ios2) line
      enddo  

c
c clean up and return abort = .false.
c
      close (unit = nout1)
      close (unit = nout2)
      deallocate(x, stat = ierr)
      abort = .false.
      end
c
c      