C
C
      SUBROUTINE DAT5IN (NIN, NMAX, NPTS, NVEC,
     +                   V1, V2, V3, V4, V5,
     +                   FNAME, TITLE,
     +                   ABORT, SUPPLY)
C
C ACTION : Read in NVEC vectors V1, V2, etc. from a file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/90
C          14/05/1992 GETNUM
C          03/10/1992 Removed CLOSE statements
C                     Derived from DATTIN by removing ISEND, FIXNPT, LABEL etc.
C          07/01/1993 Added ICOUNT
C          05/02/1993 Derived from DATFIL
C          21/02/1994 DBOS version
C          04/09/1996 Aded CHKFIL
C          17/05/1997 win32 version
C          02/11/1997 Allowed files with no s-values so setting all s = 1
C          28/11/2001 added VU2CHK
C          28/05/2002 added FNAME to call to CHKFIL and suppressed VU2CHK
C          15/02/2005 revised and added CHECKF  
C          25/02/2007 added INTENTS 
C          01/08/2008 added call to ISITSF
C          21/01/2010 added SUPPLY
C
C          NIN: (input/unchanged) unconnected unit for data input
C         NMAX: (input/unchanged) dimension
C         NPTS: (output) number of data points
C         NVEC: (input/unchanged) number of vectors
C         V1, V2, ..., V5 (output) data
C        FNAME: (output) file name
C        TITLE: (output) data title
C        ABORT: (output) error indicator
C       SUPPLY: (input) changes action
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NVEC 
      INTEGER,             INTENT (OUT)   :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)   :: V1(NMAX), V2(NMAX),
     +                                       V3(NMAX), V4(NMAX),
     +                                       V5(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: SUPPLY 
C
C Locals
C
      INTEGER    I, ICOUNT, IOS, J, NCOL, NROW
      INTEGER    N0, N1, N2, N3, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N5 = 5)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  LINE*100
      LOGICAL    XYONLY
      EXTERNAL   OFILES, CHKFIL, PUTADV, PUTFAT, CHECKF, ISITSF
C
C Initialise and check
C
      ABORT = .TRUE.
      NPTS = 0
      IF (NIN.LT.N1 .OR. NVEC.LT.N1 .OR. NVEC.GT.N5 .OR.
     +    NMAX.LT.N1) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         WRITE (FNAME,200)
         WRITE (TITLE,300)
         RETURN
      ENDIF      
      IF (.NOT.SUPPLY) THEN
C
C Data file has not been supplied so attempt to open a file
C        
         WRITE (FNAME,200)
         WRITE (TITLE,300)
C
C Attempt to open the data file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) THEN
            WRITE (FNAME,200)
            WRITE (TITLE,300)
            RETURN
         ENDIF
      ENDIF
C
C Check that the file is a data file
C      
      CALL ISITSF (NCOL, NROW,
     +             FNAME)
      IF (NCOL.GT.N0 .AND. NROW.GT.N0) THEN
         OPEN (UNIT = NIN, FILE = FNAME)
      ELSE
         ABORT = .TRUE.
         WRITE (FNAME,200)
         WRITE (TITLE,300)         
         RETURN
      ENDIF            
C
C File is present ... check title, header and data
C
      ABORT = .TRUE.
      NCBOT = NVEC
      NCTOP = NVEC
      NRBOT = N1
      NRTOP = NMAX
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.N0) GOTO 20
      NCMID = J
      NRMID = I
C
C Check if S values are being supplied
C
      IF (NVEC.GT.N2 .AND. NCMID.EQ.NVEC - N1) THEN
         XYONLY = .TRUE.
      ELSEIF (NCMID.EQ.NVEC) THEN
         XYONLY = .FALSE.
      ELSE
         GOTO 20
      ENDIF
      IF (NRMID.LT.N1 .OR. NRMID.GT.NMAX) GOTO 20
C
C Now give the user the option to view/accept/reject
C
      CLOSE (UNIT = NIN)
      IF (SUPPLY) THEN
         ABORT = .FALSE.
      ELSE   
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
      ENDIF
      IF (ABORT) THEN
C
C User does not want these data
C
         WRITE (FNAME,200)
         WRITE (TITLE,300)
         RETURN
      ELSE
C
C Re-connect the file and wind on
C
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      ENDIF
      NPTS = NRMID
      IF (XYONLY) THEN
C
C Read data but final column of s-values set = 1
C
         WRITE (LINE,400)
         CALL PUTADV (LINE)
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            IF (NVEC.EQ.3) THEN
               V3(I) = ONE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I)
            ELSEIF (NVEC.EQ.4) THEN
               V4(I) = ONE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I),
     +                                               V3(I)
            ELSE
               V5(I) = ONE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I),
     +                                               V3(I), V4(I)
            ENDIF
            IF (IOS.NE.N0) GOTO 20
         ENDDO
      ELSE
C
C Read data and final column of s-values
C
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            IF (NVEC.EQ.1) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I)
            ELSEIF (NVEC.EQ.2) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I)
            ELSEIF (NVEC.EQ.3) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I),
     +                                               V3(I)
            ELSEIF (NVEC.EQ.4) THEN
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I),
     +                                               V3(I), V4(I)
            ELSE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) V1(I), V2(I),
     +                                               V3(I), V4(I), V5(I)
            ENDIF
            IF (IOS.NE.N0) GOTO 20
         ENDDO
      ENDIF
C
C Success so return with file still connected for further reading
C
      ABORT = .FALSE.
      RETURN
C
C Label 20: Here if a crash has occurred reading the file
C ========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      WRITE (FNAME,200)
      WRITE (TITLE,300)            
C
C Format statements
C      
  100 FORMAT ('NIN, NVEC or NMAX out of range in call to DAT5IN')
  200 FORMAT ('No current file')
  300 FORMAT ('No current data')
  400 FORMAT ('Last column of s values missing ... s will be set = 1')
      END
C
C
