C
C
      SUBROUTINE DATBIG (IADDUP, INDEX1, IW, NEQN, NIN, NPTS, NTMAX,
     +                   NYMAX,
     +                   S, STEMP, W, X, XTEMP, Y, YTEMP,
     +                   FNAMES, TITLES,
     +                   ABORT, SUPPLY)
C
C ACTION : Read in a set of data files
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.,26/4/95
C          06/09/1996 added PSWARN, TITLES and DBOS_TXT2FN
C          14/10/1997 WIN32 version w95_txt2fn replaces dbos_txt2fn
C          02/11/1997 Added facility to set all s = 1
C          14/11/2005 replaced NXSORT by NXSORTG  
C          09/01/2007 added SIMDIR to library file section
C          19/01/2007 corrected calls to SIMDIR when L2 < 1
C          19/07/2007 replaced SIMDIR by DEMDIR
C          02/08/2008 added call to ISITSF
C          10/12/2009 added FNAMES and TITLES to argument list
C          21/01/2010 added SUPPLY to argument list
C
C IADDUP: (output) no. of distinct x-values in the data
C INDEX1: (output) no. of of distinct value for data set j at point i
C          This is the number of the x-value in the sorted distinct set
C     IW: (input/unchanged) dimension of W (should be > max. possible no. x-values)
C   NEQN: (input/unchanged) no. of equations
C    NIN: (input/unchanged) no. of unconnected data input unit
C   NPTS: (output) no. of data points in data set i
C  NTMAX: (input/unchanged) (1st.) dimension of S, STEMP, X, XTEMP, Y, YTEMP
C  NYMAX: (input/unchanged) (2nd.) dimension of S, X, Y
C  S,X,Y: (output) the data sets, and
C         STEMP,XTEMP,YTEMP: scratch arrays
c FNAMES: (output) names of data files 
c TITLES: (output) titles of data files 
C  ABORT: (output) error indicator 
C SUPPLY: (input) indicates if files are being supplied
C
C          NLIB = unit number for library file
C          LIBFIL = use a library file .TRUE./.FALSE.
C
C
      IMPLICIT   NONE          
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: IW, NEQN, NIN, NTMAX, NYMAX
      INTEGER,             INTENT (OUT)   :: IADDUP,
     +                                       INDEX1(NTMAX,NYMAX),
     +                                       NPTS(NYMAX)
      DOUBLE PRECISION,    INTENT (OUT)   :: S(NTMAX,NYMAX),
     +                                       STEMP(NTMAX),
     +                                       W(IW), X(NTMAX,NYMAX),
     +                                       XTEMP(NTMAX),
     +                                       Y(NTMAX,NYMAX),
     +                                       YTEMP(NTMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAMES(NEQN), TITLES(NEQN)
      LOGICAL,             INTENT (OUT)   :: ABORT
      LOGICAL,             INTENT (IN)    :: SUPPLY
C
C Locals
C       
      INTEGER    I, J, K, L, L1, L2, L3, LREF
      INTEGER    ICOUNT, IOS, ISEND, JCOUNT, LEN200, NLIB
      INTEGER    N2, N3
      PARAMETER (N2 = 2, N3 = 3)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      INTEGER    NUMDEC, NUMHDR, NUMOPT
      PARAMETER (NUMHDR = 8, NUMOPT = 2)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      DOUBLE PRECISION XREF
      DOUBLE PRECISION ONE, ZERO, EPSI
      PARAMETER (ONE = 1.0D+00, ZERO = 0.0D+00, EPSI = 1.0D-150)
      CHARACTER  FNAME*1024, LINE*100, LNAME*1024, TITLE*80
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*100, SIMFIT*1024,
     +           TEMP*1024 
      CHARACTER  BLANK*1, BSLASH*1, PCENT*1
      PARAMETER (BLANK = ' ', BSLASH = '\', PCENT = '%')
      LOGICAL    XYONLY
      LOGICAL    ISTOP, LIBFIL, THERE, YES
      EXTERNAL   TXT2FN
      EXTERNAL   DATFIL, DATCHK, CHECKF, NXSORTG, PUTADV, OFILES,
     +           PUTFAT, PUTIOS, YESNO2, PSWARN, TITLE2, LEN200, DEMDIR,
     +           TRIML1, ISITSF, GETNOU, DATSXY
      INTRINSIC  INDEX
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'Use library file',
     +                    'Individual files' /
C
C Part 1: filenames supplied or read in are analysed 
C =======
C     
      IF (SUPPLY) THEN
C
C A set of filenames have been supplied
C File names must be full paths to genuine simfit CURVE FITTING data files 
C        
         ABORT = .TRUE.
         IADDUP = 0
         DO I = 1, NEQN
            CALL ISITSF (J, K,
     +                   FNAMES(I))
            IF (K.GT.0) THEN
               IF (J.EQ.2 .OR. J.EQ.3) THEN
                  CLOSE (UNIT = NIN)
                  CALL DATSXY (NIN, NTMAX, NPTS(I),
     +                         STEMP, XTEMP, YTEMP,
     +                         FNAMES(I), TITLES(I),
     +                         ISTOP)
                  CLOSE (UNIT = NIN)
               ELSE
                  ISTOP = .TRUE.
                  NPTS(I) = 0
               ENDIF     
            ELSE
               ISTOP =.TRUE.
               NPTS(I) = 0   
            ENDIF
            IF (.NOT.ISTOP .AND. NPTS(I).GT.0) THEN
               DO J = 1, NPTS(I)
                  S(J,I) = STEMP(J)
                  X(J,I) = XTEMP(J)
                  Y(J,I) = YTEMP(J)
                  IADDUP = IADDUP + 1
                  W(IADDUP) = XTEMP(J)
               ENDDO
            ELSE
               NPTS(I) = 0
            ENDIF
         ENDDO 
         IF (IADDUP.EQ.0) RETURN 
      ELSE   
C
C Initialise  all counters and arrays ... ISTOP must be set to .FALSE.
C
         ABORT = .TRUE.
         ISTOP = .FALSE.
         IADDUP = 0
         ICOUNT = 0
         JCOUNT = 0
         IOS = 0
         NLIB = 1
         DO I = 1, NEQN
            NPTS(I) = 0
            FNAMES(I) = BLANK
            TITLES(I) = BLANK
         ENDDO
         DO J = 1, NYMAX
            DO I = 1, NTMAX
               INDEX1(I,J) = 0
               X(I,J) = ZERO
               Y(I,J) = ZERO
               S(I,J) = ZERO
            ENDDO  
         ENDDO  
         DO I = 1, NTMAX
            XTEMP(I) = ZERO
            YTEMP(I) = ZERO
            STEMP(I) = ZERO
         ENDDO 
         DO I = 1, IW
            W(I) = ZERO
         ENDDO    
C
C Read in and check all required data files
C
         IF (NEQN.EQ.1) THEN
            LIBFIL = .FALSE.
         ELSE
            WRITE (HEADER,100)
            NUMDEC = 1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
            IF (NUMDEC.EQ.1) THEN
               LIBFIL = .TRUE.
            ELSE
               LIBFIL = .FALSE.
            ENDIF
            IF (LIBFIL) THEN
C
C Access a library file
C
               ISEND = 3
               CALL GETNOU (NLIB)
               CALL OFILES (ISEND, NLIB,
     +                      LNAME,
     +                      ABORT)
               CLOSE (UNIT = NLIB)
               IF (ABORT) RETURN
               OPEN (UNIT = NLIB, FILE = LNAME)
               ICOUNT = ICOUNT + 1
               READ (NLIB,200,END=40,ERR=40,IOSTAT=IOS) TITLE
               IF (IOS.NE.0) GOTO 40
               CALL PSWARN (TITLE)
C
C Disconnect before checking then re-connect and wind on
C
               CLOSE (UNIT = NLIB)
               CALL CHECKF (LNAME, TITLE, 
     +                      ABORT)
               IF (ABORT) RETURN
               OPEN (UNIT = NLIB, FILE = LNAME)
               READ (NLIB,200,END=40,ERR=40,IOSTAT=IOS) TITLE
            ENDIF
         ENDIF          
         L1 = 1
         CALL DEMDIR (L2,
     +                SIMFIT) 
         DO I = 1, NEQN
            IF (LIBFIL) THEN
C
C Read successive library files
C
               ICOUNT = ICOUNT + 1
               READ (NLIB,200,END=40,ERR=40,IOSTAT=IOS) FNAME
               IF (IOS.NE.0) GOTO 40
               IF (FNAME.EQ.BLANK .OR. FNAME.EQ.PCENT) THEN
                  JCOUNT = JCOUNT + 1
                  YES = .FALSE.
               ELSE
                  CALL TXT2FN (FNAME,
     +                         ABORT)
                  IF (.NOT.ABORT) THEN
                     INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
                     IF (IOS.EQ.0 .AND. .NOT.THERE) THEN  
C
C Library file not found so look in Simfit folder 
C                  
                        IF (L2.GT.0 .AND. INDEX(FNAME,BSLASH).LE.0) THEN
                           TEMP = FNAME
                           CALL TRIML1 (TEMP)
                           L3 = LEN200 (TEMP)
                           FNAME = SIMFIT(L1:L2)//TEMP(L1:L3) 
                           INQUIRE (FILE = FNAME, EXIST = THERE,
     +                              IOSTAT = IOS)
                        ENDIF  
                     ENDIF 
                  ELSE
                     IOS = - 1
                     THERE = .FALSE.
                  ENDIF
                  IF (IOS.EQ.0 .AND. THERE) THEN
                     YES = .TRUE.
                  ELSE
                     WRITE (LINE,300) ICOUNT
                     CALL PUTFAT (LINE)
                     RETURN
                  ENDIF
               ENDIF
            ELSEIF (NEQN.GT.1) THEN
               WRITE (LINE,400) I
               YES = .TRUE.
               CALL YESNO2 (ICOLOR, IX, IY, 
     +                      LINE, 
     +                      YES)
            ELSE
               WRITE (LINE,500) 1
               CALL PUTADV (LINE)
               YES = .TRUE.
            ENDIF
            IF (YES) THEN
               CLOSE (UNIT = NIN)
               IF (LIBFIL) THEN
C
C Access a data file specified by the library file
C
                  CALL ISITSF (J, K,
     +                         FNAME)
                  IF (J.LE.0 .OR. K.LE.0) THEN  
                     CALL PUTFAT ('File referenced is not a data file')
                     GOTO 40
                  ENDIF   
                  ISEND = 4
                  CLOSE (UNIT = NIN)
                  CALL OFILES (ISEND, NIN, 
     +                         FNAME,
     +                         ABORT)
                  READ (NIN,200,END=40,ERR=40,IOSTAT=IOS) TITLE
                  IF (IOS.NE.0) GOTO 40
                  READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) NPTS(I), J
                  IF (IOS.NE.0) GOTO 40
                  IF (J.EQ.N2) THEN
                     XYONLY = .TRUE.
                  ELSEIF (J.EQ.N3) THEN
                     XYONLY = .FALSE.
                  ELSE
                     CALL PUTFAT ('File referenced is not a data file')
                     GOTO 40
                  ENDIF
                  IF (NPTS(I).LT.1) THEN
                     CALL PUTFAT ('File referenced is not a data file')
                     GOTO 40
                  ELSE
                     IF (XYONLY) THEN
                        DO J = 1, NPTS(I)
                           STEMP(J) = ONE
                           READ (NIN,*,END=40,ERR=40,IOSTAT=IOS)
     +                           XTEMP(J), YTEMP(J)
                           IF (IOS.NE.0) GOTO 40
                           IF (J.GT.1) THEN
                              IF (XTEMP(J).LT.XTEMP(J - 1)) THEN
                                 CALL PUTFAT (
     +                          'An X-value is not in increasing order')
                                 GOTO 40
                              ENDIF
                           ENDIF
                        ENDDO
                     ELSE
                        DO J = 1, NPTS(I)
                           READ (NIN,*,END=40,ERR=40,IOSTAT=IOS) 
     +                           XTEMP(J), YTEMP(J), STEMP(J)
                           IF (IOS.NE.0) GOTO 40
                           IF (STEMP(J).LE.EPSI) THEN
                              CALL PUTFAT (
     +                       'An S-value < 1.0e-150 ... Too small')
                              GOTO 40
                           ENDIF
                           IF (J.GT.1) THEN
                              IF (XTEMP(J).LT.XTEMP(J - 1)) THEN
                                 CALL PUTFAT (
     +                          'An X-value is not in increasing order')
                                 GOTO 40
                              ENDIF
                           ENDIF
                        ENDDO
                     ENDIF
                  ENDIF
            
               ELSE
C
C Access an individually specified file
C
                  CALL DATFIL (NIN, NTMAX, NPTS(I),
     +                         STEMP, XTEMP, YTEMP,
     +                         FNAME, TITLE,
     +                         ISTOP)
               ENDIF
               IF (.NOT.ISTOP .AND. NPTS(I).GT.0) THEN
                  CLOSE (UNIT = NIN)
                  IF (.NOT.ISTOP) THEN
                     IF (.NOT.LIBFIL)
     +               CALL DATCHK (NPTS(I),
     +                            STEMP, XTEMP, YTEMP,
     +                            ISTOP)
                     IF (.NOT.ISTOP) THEN
                        JCOUNT = JCOUNT + 1
                        FNAMES(JCOUNT) = FNAME
                        TITLES(JCOUNT) = TITLE
                        DO J = 1, NPTS(I)
                           S(J,I) = STEMP(J)
                           X(J,I) = XTEMP(J)
                           Y(J,I) = YTEMP(J)
                           IADDUP = IADDUP + 1
                           W(IADDUP) = XTEMP(J)
                        ENDDO
                     ELSE
                        NPTS(I) = 0
                     ENDIF
                  ELSE
                     NPTS(I) = 0
                  ENDIF
               ELSE
                 NPTS(I) = 0
               ENDIF
            ENDIF
         ENDDO
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NLIB)
         IF (IADDUP.EQ.0) THEN
            ABORT = .TRUE.
            RETURN
         ENDIF
      ENDIF
C
C Part 2: Sort the x values stored in W then count the distinct values
C =======
C
      CALL NXSORTG(IADDUP, W)
      J = IADDUP
      IADDUP = 1
      DO I = 2, J
         IF (W(I).GT.W(IADDUP)) THEN
            IADDUP = IADDUP + 1
            W(IADDUP) = W(I)
         ENDIF
      ENDDO
C
C Assign the indices
C
      DO I = 1, NEQN
         IF (NPTS(I).GT.0) THEN
            LREF = 1
            XREF = W(LREF)
            DO J = 1, NPTS(I)
               L = LREF
               DO K = L, IADDUP
                  IF (X(J,I).GT.XREF) THEN
                     LREF = LREF + 1
                     XREF = W(LREF)
                  ELSE
                     INDEX1(J,I) = LREF
                     GOTO 20
                  ENDIF
               ENDDO
   20          CONTINUE
            ENDDO
         ENDIF
      ENDDO
      ABORT = .FALSE.
      RETURN
   40 CONTINUE
C
C Crash
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NLIB)
      ABORT = .TRUE.
      IADDUP = 0
      IF (IOS.NE.0) CALL PUTIOS (IOS,
     +                           'DATBIG')
      WRITE (LINE,600) ICOUNT
      CALL PUTFAT (LINE)      
C
C Format statements
C      
  100 FORMAT (
     +/'At this point you can decide whether to supply file-names'
     +/'for the individual data files or whether to use a library'
     +/'file to reference all the files at the same time.'
     +/'A library file is an ASCII text file with a list of files'
     +/'in the order of successive functions. Note that a % means'
     +/'there is no data for fitting, as in the files deqsol.tf?'
     +/)
  200 FORMAT (A)
  300 FORMAT (
     +'File-missing/illegal-filename ... Check file at line no.',I3)
  400 FORMAT (
     +'Do you have data for fitting with component y(',I3,
     +') ?')
  500 FORMAT (
     +'Specify a file with data corresponding to component y(',I3,
     +')')
  600 FORMAT (
     +'Check the library file at line no.',I3)
      END
C
C
