
C
C
      SUBROUTINE DATCHK (N,
     +                   S, X, Y,
     +                   ABORT)
C
C ACTION : Check X, Y, S data set for consistency after DATTIN or DATFIL
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 3/5/91
C          21/02/1994 DBOS version 
C          24/11/1995 changed ERRMIN to 1.0E-20
C          05/08/1997 win32 version ERRMIN = 1.0E-150
C          27/09/2002 replaced patch1 by table1
C          25/02/2007 added INTENTS
C          23/04/2010 altered FABOVE and FBELOW to circumvent rounding errors
C          31/03/2012 changed S to INTENT (INOUT) due to calling TESTER
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N 
      DOUBLE PRECISION, INTENT (IN)    :: S(N)
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), Y(N)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C        
      INTEGER    I, NABOVE, NBELOW, NPRINT, NSMALL
      INTEGER    ICOLOR, NUMTXT
      INTEGER    N0, N1, N3, N4, N5, N6, N8
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N8 = 8)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION ERRMIN, FABOVE, FBELOW, YMIN
      PARAMETER (ERRMIN = 1.0D-150, FABOVE = 0.26D+00,
     +           FBELOW = 0.009D+00,
     +           YMIN = 1.0D-50)
      DOUBLE PRECISION BIG, QSMALL, SMALL
      PARAMETER (BIG = 1.0D+10, QSMALL = 1.0D-02, SMALL = 1.0D-10)
      DOUBLE PRECISION SMAX, SMIN
      PARAMETER (SMAX = ONE + 1.0D-7, SMIN = ONE - 1.0D-7)
      DOUBLE PRECISION TEMP, XMAX, YMAX
      CHARACTER  ARROW*4, BLANK*4, SYMBOL(5)*4
      PARAMETER (ARROW = '*** ', BLANK = ' ')
      CHARACTER  LINE1*100, LINE2(2)*100, LINE3(3)*100, LINE6(6)*100
      CHARACTER  TEXT(30)*100
      LOGICAL    IWARNU(8), TABLE, WEIGHT
      EXTERNAL   PUTFAT, TABLE1, PUTMES
      INTRINSIC  ABS
C
C Check
C 
      IF (N.LE.N0) RETURN
C
C Initialise counters, check that X is in order then calculate XMAX
C
      NABOVE = N0
      NBELOW = N0
      NPRINT = N0
      NSMALL = N0
      TEMP = X(1) - ONE
      XMAX = ABS(X(1))
      YMAX = ABS(Y(1))
      ABORT = .FALSE.
      TABLE = .FALSE.
      WEIGHT = .FALSE.
      I = N0
      DO WHILE (I.LT.N .AND. .NOT.WEIGHT)
         I = I + N1
         IF (S(I).GT.SMAX .OR. S(I).LT.SMIN) WEIGHT = .TRUE.
      ENDDO
      DO I = N1, N
         IF (X(I).LT.TEMP) THEN
            ABORT = .TRUE.
            WRITE (LINE1,100) I, I - N1
            CALL PUTFAT (LINE1)
            WRITE (TEXT,200)
            NUMTXT = N6
            CALL PUTMES (NUMTXT,
     +                   TEXT)
            RETURN
         ENDIF
         IF (S(I).LT.ERRMIN) THEN
            ABORT = .TRUE.
            WRITE (LINE1,300) I, ERRMIN
            CALL PUTFAT (LINE1)
            WRITE (TEXT,200)
            NUMTXT = N6
            CALL PUTMES (NUMTXT,
     +                   TEXT)
            RETURN
         ENDIF
         IF (ABS(X(I)).GT.XMAX) XMAX = ABS(X(I))
         IF (ABS(Y(I)).GT.YMAX) YMAX = ABS(Y(I))
         TEMP = X(I)
      ENDDO
C
C Now check S and Y for consistency if WEIGHT = .TRUE.
C
      IF (WEIGHT) THEN
         DO I = N1, N
            IF (ABS(Y(I)).LT.YMIN) THEN
               NSMALL = NSMALL + 1
            ELSE
               TEMP = S(I)/ABS(Y(I))
               IF (TEMP.GT.FABOVE) NABOVE = NABOVE + 1
               IF (TEMP.LT.FBELOW) NBELOW = NBELOW + 1
            ENDIF
         ENDDO
      ENDIF
C
C Check to see if WARNINGS are required
C
      DO I = N1, N8
         IWARNU(I) = .FALSE.
      ENDDO
      DO I = N1, N5
         SYMBOL(I) = BLANK
      ENDDO
      IF (NABOVE.GT.N0) THEN
         SYMBOL(1) = ARROW
         IWARNU(1) = .TRUE.
      ENDIF
      IF (NBELOW.GT.N0) THEN
         SYMBOL(2) = ARROW
         IWARNU(2) = .TRUE.
      ENDIF
      IF (NSMALL.GT.N0) THEN
         SYMBOL(3) = ARROW
         IWARNU(3) = .TRUE.
      ENDIF
      IF (XMAX.GT.BIG) THEN
         SYMBOL(4) = ARROW
         IWARNU(4) = .TRUE.
      ELSEIF (XMAX.LT.SMALL) THEN
         SYMBOL(4) = ARROW
         IWARNU(5) = .TRUE.
      ENDIF
      IF (YMAX.GT.BIG) THEN
         SYMBOL(5) = ARROW
         IWARNU(6) = .TRUE.
      ELSEIF (YMAX.LT.SMALL) THEN
         SYMBOL(5) = ARROW
         IWARNU(7) = .TRUE.
      ENDIF
      IF (.NOT.WEIGHT .AND. YMAX.LT.QSMALL) THEN
         SYMBOL(5) = ARROW
         IWARNU(8) = .TRUE.
      ENDIF
      DO I = N1, N8
         IF (I.NE.N3 .AND. IWARNU(I)) THEN
            TABLE = .TRUE.
         ENDIF
      ENDDO
      IF (TABLE) THEN
         IF (WEIGHT) THEN
            WRITE (TEXT,400) NABOVE, SYMBOL(1), NBELOW, SYMBOL(2),
     +             NSMALL, SYMBOL(3), XMAX, SYMBOL(4), YMAX, SYMBOL(5)
            NPRINT = N6
         ELSE
            WRITE (TEXT,500) XMAX, SYMBOL(4), YMAX, SYMBOL(5)
            NPRINT = N3
         ENDIF
         IF (IWARNU(1)) THEN
            WRITE (LINE2,600)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(2)) THEN
            WRITE (LINE2,700)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(3)) THEN
            WRITE (LINE2,800)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(4)) THEN
            WRITE (LINE2,900) 'X'
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(5)) THEN
            WRITE (LINE2,1000) 'X'
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(6)) THEN
            WRITE (LINE2,900) 'Y'
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(7)) THEN
            WRITE (LINE2,1000) 'Y'
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE2(2)
         ENDIF
         IF (IWARNU(8)) THEN
            WRITE (LINE3,1100)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE3(1)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE3(2)
            NPRINT = NPRINT + 1
            TEXT(NPRINT) = LINE3(3)
         ENDIF
         WRITE (LINE6,200)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(1)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(2)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(3)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(4)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(5)
         NPRINT = NPRINT + 1
         TEXT(NPRINT) = LINE6(6)
         NUMTXT = NPRINT
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = N1, NPRINT
            IF (I.EQ.N1 .OR. TEXT(I)(1:1).EQ.'*') THEN
               ICOLOR = N4
            ELSE
               ICOLOR = N0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ENDIF 
C
C Format statements
C      
  100 FORMAT ('x(',I5,') < x(',I5,')')
  200 FORMAT (
     + '*Advice*'
     +/'Use MAKFIL to prepare files'
     +/'Use EDITFL to edit files and check data for consistency,'
     +/'rearrange into order of increasing x, detect outliers or'
     +/'unrealistic standard errors or change units to re-scale'
     +/'data if necessary.')
  300 FORMAT ('s(',I5,') <',1P,E10.3)
  400 FORMAT ('Analysis of weighted regression data'
     +/'No. rel. errors (i.e. s/y values) > 25% =',I6,6X,A
     +/'No. rel. errors (i.e. s/y values) <  1% =',I6,6X,A
     +/'No. y-vals too small to calc. rel. err. =',I6,6X,A
     +/'Largest absolute x value                =',1P,E10.3,2X,A
     +/'Largest absolute y value                =',   E10.3,2X,A)
  500 FORMAT ('Analysis of unweighted regression data'
     +/'Largest absolute x =',1P,E10.3,2X,A,
     +/'Largest absolute y =',   E10.3,2X,A)
  600 FORMAT (
     + 'Large relative errors suggest bad experiment design'
     +/'or incorrect s values ... Check s values ?')
  700 FORMAT (
     + 'Small relative errors are too good to be true and'
     +/'suggest incorrect s values ... Check s values ?')
  800 FORMAT (
     + 'With small absolute y values use larger s values to'
     +/'avoid distortion from biased weighting')
  900 FORMAT (
     + A1,1X,'units such that largest absolute value > 10^(10) may'
     +/'cause numerical problems ... Change units ?')
 1000 FORMAT (
     + A1,1X,'units such that largest absolute value < 10^(-10) may'
     +/'cause numerical problems ... Change units ?')
 1100 FORMAT (
     + 'Unweighted regression with largest absolute y value'
     +/'< 10^(-2) leads to small SSQ start values and failure to'
     +/'converge ... Change y units ?')
      END
C
C
