C
C
      SUBROUTINE DATFIL (NIN, NMAX, NPTS,
     +                   S, X, Y,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION : Read in data points X, Y, S from a data file
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/90
C          14/05/1992 GETNUM
C          03/10/1992 Removed CLOSE statements
C                     Derived from DATTIN by removing ISEND, FIXNPT, LABEL etc.
C          07/01/1993 Added ICOUNT
C          21/02/1994 DBOS version
C          04/09/1996 Added CHKFIL
C          02/11/1997 Added facility to check all s and set all s = 1
C          20/03/1998 CLOSE NIN on entry
C          05/04/2000 CLOSE NIN on exit
C          08/05/2000 removed CLOSE NIN if success since it may be
C                     required to read the trailer
C          28/11/2001 added VU2CHK
C          28/05/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          16/02/2005 added call to CHECKF 
C          25/02/2007 added INTENTS 
C          04/08/2008 added call to ISITSF 
C
C          NIN: (input/unchanged) unconnected unit for file opening
C         NMAX: (input/unchanged) dimension
C         NPTS: (output) no. of data points
C         S, X, Y: (output)
C        FNAME: (output) file name
C        TITLE: (output) data title
C        ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: NIN, NMAX
      INTEGER,             INTENT (OUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT) :: S(NMAX), X(NMAX), Y(NMAX)
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME, TITLE
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    I, ICOUNT, IOS, J
      INTEGER    N0, N1, N2, N3
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      PARAMETER (NCBOT = 3, NCTOP = 3, NRBOT = 1)
      DOUBLE PRECISION ONE, SMIN
      PARAMETER (ONE = 1.0D+00, SMIN = 1.0D-150)
      CHARACTER  LINE*100
      LOGICAL    XYONLY
      EXTERNAL   OFILES, CHKFIL, PUTFAT, CHECKF, ISITSF
C
C Initialise and check
C
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      WRITE (FNAME,100)
      WRITE (TITLE,200)
      IF (NIN.LT.N1 .OR. NMAX.LT.N1) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C Attempt to open the file
C
      CALL OFILES (N3, NIN,
     +             FNAME,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) THEN
         RETURN
      ENDIF
      CALL ISITSF (NCMID, NRMID,
     +             FNAME)
      IF (NCMID.GT.N0 .AND. NRMID.GT.N0) THEN
         OPEN (UNIT = NIN, FILE = FNAME)
      ELSE
         ABORT = .TRUE.
         RETURN
      ENDIF             
C
C File is opened so check title, header and data
C
      ABORT = .TRUE.
      NCMID = - N1
      NRMID = - N1
      NRTOP = NMAX
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.0) GOTO 20
      NCMID = J
      NRMID = I
C
C Check if S is supplied
C
      IF (NCMID.EQ.N2) THEN
         XYONLY = .TRUE.
      ELSEIF (NCMID.EQ.N3) THEN
         XYONLY = .FALSE.
      ELSE
         GOTO 20
      ENDIF
      IF (NRMID.LT.N1 .OR. NRMID.GT.NMAX) GOTO 20
C
C Check is file is correct
C
      CLOSE (UNIT = NIN)
      CALL CHECKF (FNAME, TITLE,
     +             ABORT)
      IF (ABORT) THEN
         WRITE (FNAME,100)
         WRITE (TITLE,200)
         RETURN
      ELSE
         OPEN (UNIT = NIN, FILE = FNAME)
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      ENDIF
      NPTS = NRMID
C
C Read in the data points
C
      IF (XYONLY) THEN
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            S(I) = ONE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I)
            IF (IOS.NE.0) GOTO 20
         ENDDO
      ELSE
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I), S(I)
            IF (IOS.NE.0) GOTO 20
            IF (S(I).LT.SMIN) THEN
               WRITE (LINE,400) I
               CALL PUTFAT (LINE)
               CLOSE (UNIT = NIN)
               WRITE (FNAME,100)
               WRITE (TITLE,200)
               RETURN
            ENDIF
         ENDDO
      ENDIF
      ABORT = .FALSE.
      RETURN
C
C Label 20: Here if a crash has occurred reading the file
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      WRITE (FNAME,100)
      WRITE (TITLE,200) 
C
C Format statements
C      
  100 FORMAT ('No current file')
  200 FORMAT ('No current data')
  300 FORMAT ('NIN or NMAX out of range in call to DATFIL')
  400 FORMAT (
     +'S value too small for curve-fitting ... Check data point no.',I6)
      END
C
C
