C
C
      SUBROUTINE DATMUL (NEQN, NIN, NTOTAL,
     +                   FNAMES, TITLES,
     +                   ABORT)
C
C ACTION : Read in multiple curve fitting data files
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          21/01/2010 developed from DATBIG
C
C   NEQN: (input/unchanged) number of equations
C    NIN: (input/unchanged) an unconnected data input unit
C NTOTAL: (output) total number of points 
c FNAMES: (output) names of data files 
c TITLES: (output) titles of data files 
C  ABORT: (output) error indicator 
C
C          NLIB = unit number for library file
C          LIBFIL = use a library file .TRUE./.FALSE.
C          ICOUNT = line number in library file 
C
C
      IMPLICIT   NONE          
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NEQN, NIN
      INTEGER,             INTENT (OUT) :: NTOTAL
      CHARACTER (LEN = *), INTENT (OUT) :: FNAMES(NEQN), TITLES(NEQN)
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C       
      INTEGER    I, J, K, L1, L2, L3
      INTEGER    ICOUNT, IOS, ISEND, LEN200, NLIB, NPTS
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      INTEGER    NUMDEC, NUMHDR, NUMOPT
      PARAMETER (NUMHDR = 10, NUMOPT = 2)
      INTEGER    NUMBLD(NUMHDR), NUMPOS(NUMOPT)
      DOUBLE PRECISION STEMP, XTEMP, YTEMP 
      DOUBLE PRECISION XPREV
      DOUBLE PRECISION ZERO, EPSI
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-150)
      CHARACTER  FNAME*1024, LINE*100, LNAME*1024, TITLE*80
      CHARACTER  HEADER(NUMHDR)*100, OPTION(NUMOPT)*100, SIMFIT*1024,
     +           TEMP*1024 
      CHARACTER  BLANK*1, BSLASH*1, PCENT*1
      PARAMETER (BLANK = ' ', BSLASH = '\', PCENT = '%')
      LOGICAL    XYONLY
      LOGICAL    LIBFIL, THERE, YES
      EXTERNAL   TXT2FN
      EXTERNAL   CHECKF, PUTADV, OFILES,
     +           PUTFAT, YESNO2, PSWARN, TITLE2, LEN200, DEMDIR,
     +           TRIML1, ISITSF, GETNOU
      INTRINSIC  INDEX
      DATA       NUMBLD / NUMHDR*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'Use library file',
     +                    'Individual files' /
C
C Initialise
C     
      YTEMP = ZERO  !to silence NAGfor
      XTEMP = YTEMP !to silence NAGfor
      ABORT = .TRUE.
      NTOTAL = N0
      NLIB = N1
      DO I = N1, NEQN
         FNAMES(I) = 'No current data file'
         TITLES(I) = 'No current data title'
      ENDDO
      IF (NIN.GE.N1 .AND. NEQN.GE.N1) THEN  
C
C NIN and NEQN are OK so initialise counter  
C
         ICOUNT = N0
C
C Read in and check all required data files
C
         IF (NEQN.EQ.N1) THEN
C
C No library file if only 1 equation
C           
            LIBFIL = .FALSE.
         ELSE
C
C Provide option to use a library file
C           
            WRITE (HEADER,100)
            NUMDEC = N1
            NUMBLD(1) = 1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   HEADER, OPTION)
            IF (NUMDEC.EQ.N1) THEN
               LIBFIL = .TRUE.
            ELSE
               LIBFIL = .FALSE.
            ENDIF
            IF (LIBFIL) THEN
C
C Try to access a library file
C
               ISEND = N3
               CALL GETNOU (NLIB)
               CALL OFILES (ISEND, NLIB,
     +                      LNAME,
     +                      ABORT)
               CLOSE (UNIT = NLIB)
               IF (ABORT) THEN
                  NTOTAL = N0
                  RETURN
               ENDIF   
               OPEN (UNIT = NLIB, FILE = LNAME)
               ICOUNT = ICOUNT + N1
               READ (NLIB,200,END=20,ERR=20,IOSTAT=IOS) TITLE
               IF (IOS.NE.N0) GOTO 20
               CALL PSWARN (TITLE)
C
C Disconnect before checking then re-connect and wind on
C
               CLOSE (UNIT = NLIB)
               CALL CHECKF (LNAME, TITLE, 
     +                      ABORT)
               IF (ABORT) THEN
                  NTOTAL = N0
                  RETURN
               ENDIF   
               OPEN (UNIT = NLIB, FILE = LNAME)
               READ (NLIB,200,END=20,ERR=20,IOSTAT=IOS) TITLE
               IF (IOS.NE.N0) GOTO 20
            ENDIF
         ENDIF  
C
C Attempt to read in NEQN data files 
C                 
         L1 = N1
         CALL DEMDIR (L2,
     +                SIMFIT) 
         DO I = N1, NEQN
            IF (LIBFIL) THEN
C
C Read successive library files
C
               ICOUNT = ICOUNT + N1
               READ (NLIB,200,END=20,ERR=20,IOSTAT=IOS) FNAME
               IF (IOS.NE.0) GOTO 20
               IF (FNAME.EQ.BLANK .OR. FNAME.EQ.PCENT) THEN
                  YES = .FALSE.
               ELSE
                  CALL TXT2FN (FNAME,
     +                         ABORT)
                  IF (.NOT.ABORT) THEN
                     INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
                     IF (IOS.EQ.0 .AND. .NOT.THERE) THEN  
C
C Library file not found so look in Simfit folder 
C                  
                        IF (L2.GT.N0 .AND. 
     +                      INDEX(FNAME,BSLASH).LE.N0) THEN
                           TEMP = FNAME
                           CALL TRIML1 (TEMP)
                           L3 = LEN200 (TEMP)
                           FNAME = SIMFIT(L1:L2)//TEMP(L1:L3) 
                           INQUIRE (FILE = FNAME, EXIST = THERE,
     +                              IOSTAT = IOS)
                        ENDIF  
                     ENDIF 
                  ELSE
                     IOS = - N1
                     THERE = .FALSE.
                  ENDIF
                  IF (IOS.EQ.N0 .AND. THERE) THEN
                     YES = .TRUE.
                  ELSE
                     ABORT = .TRUE.
                     NTOTAL = N0
                     WRITE (LINE,300) ICOUNT
                     CALL PUTFAT (LINE)
                     RETURN
                  ENDIF
               ENDIF
            ELSEIF (NEQN.GT.N1) THEN
               WRITE (LINE,400) I
               YES = .TRUE.
               CALL YESNO2 (ICOLOR, IX, IY, 
     +                      LINE, 
     +                      YES)
               IF (.NOT.YES) NPTS = N0
            ELSE
               WRITE (LINE,500) N1
               CALL PUTADV (LINE)
               YES = .TRUE.
            ENDIF
            IF (YES) THEN
               CLOSE (UNIT = NIN)
               IF (LIBFIL) THEN
C
C Access a data file specified by the library file
C
                  CALL ISITSF (J, K,
     +                         FNAME)
                  IF (J.LE.0 .OR. K.LE.0) THEN  
                     CALL PUTFAT ('File referenced is not a data file')
                     GOTO 20
                  ENDIF   
                  ISEND = N4
                  CLOSE (UNIT = NIN)
                  CALL OFILES (ISEND, NIN, 
     +                         FNAME,
     +                         ABORT)
               ELSE
C
C Access an individually specified file
C
                  ISEND = N3
                  FNAME = 'No current data file'
                  CALL OFILES (ISEND, NIN,
     +                         FNAME,
     +                         ABORT)
                  CLOSE (UNIT = NIN)
                  IF (ABORT) GOTO 20
                  CALL ISITSF (J, K,
     +                         FNAME)                  
                  IF (J.LT.N2 .OR. J.GT.N3 .OR. K.LT.N1) THEN
                     NPTS = N0
                     GOTO 20
                  ELSE
                     OPEN (UNIT = NIN, FILE = FNAME)           
                  ENDIF
               ENDIF   
               READ (NIN,200,END=20,ERR=20,IOSTAT=IOS) TITLE
               IF (IOS.NE.0) GOTO 20
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NPTS, J
               IF (IOS.NE.0) GOTO 20
               IF (J.EQ.N2) THEN
                  XYONLY = .TRUE.
               ELSEIF (J.EQ.N3) THEN
                  XYONLY = .FALSE.
               ELSE
                  CALL PUTFAT ('This is not a curve fitting data file')
                  GOTO 20
               ENDIF
               IF (NPTS.LT.N1) THEN
                  CALL PUTFAT ('File referenced is not a data file')
                  GOTO 20
               ELSE
                  IF (XYONLY) THEN
                     DO J = N1, NPTS
                        READ (NIN,*,END=20,ERR=20,IOSTAT=IOS)
     +                        XTEMP, YTEMP
                        IF (IOS.NE.0) GOTO 20
                        IF (J.GT.N1) THEN
                           IF (XTEMP.LT.XPREV) THEN
                              CALL PUTFAT (
     +                       'An X-value is not in increasing order')
                              GOTO 20
                           ENDIF
                        ENDIF
                        XPREV = XTEMP 
                     ENDDO
                  ELSE
                     DO J = N1, NPTS
                        READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) 
     +                        XTEMP, YTEMP, STEMP
                        IF (IOS.NE.N0) GOTO 20
                        IF (STEMP.LE.EPSI) THEN
                           CALL PUTFAT (
     +                    'An S-value < 1.0e-150 ... Too small')
                           GOTO 20
                        ENDIF
                        IF (J.GT.N1) THEN
                           IF (XTEMP.LT.XPREV) THEN
                              CALL PUTFAT (
     +                       'An X-value is not in increasing order')
                              GOTO 20
                           ENDIF
                        ENDIF
                        XPREV = XTEMP
                     ENDDO
                  ENDIF
               ENDIF
            ELSE
               NPTS = N0
            ENDIF
            IF (NPTS.GT.N0) THEN
               FNAMES(I) = FNAME
               TITLES(I) = TITLE
               NTOTAL = NTOTAL + NPTS
            ELSE
               FNAMES(I) = PCENT
               TITLES(I) = PCENT   
            ENDIF   
         ENDDO
         CLOSE (UNIT = NIN)
         CLOSE (UNIT = NLIB)
         IF (NTOTAL.LE.N0) THEN
            NTOTAL = N0
            ABORT = .TRUE.
         ELSE
            ABORT = .FALSE.   
         ENDIF
      ENDIF
      RETURN
C
C LABEL 20: here if a crash
C ========
C      
   20 CONTINUE      
      ABORT = .TRUE.
      NTOTAL = N0
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NLIB)
      IF (LIBFIL) THEN
         WRITE (LINE,600) ICOUNT
      ELSE   
         WRITE (LINE,700) 
      ENDIF   
      CALL PUTFAT (LINE)
C
C Format statements
C      
  100 FORMAT (
     + 'Select the option required to open curve fitting files'
     +/
     +/'At this point you can decide whether to supply file-names'
     +/'for the individual data files, or whether to use a library'
     +/'file to reference all the files at the same time.'
     +/
     +/'A library file is an ASCII text file with a list of files'
     +/'in the order of successive functions. Note that a % means'
     +/'there are no data for fitting, as in the files deqsol.tf?'
     +/'.')
  200 FORMAT (A)
  300 FORMAT (
     +'File-missing/illegal-filename ... Check file at line no.',I3)
  400 FORMAT (
     +'Do you have data for fitting with component y(',I3,
     +') ?')
  500 FORMAT (
     +'Specify a file with data corresponding to component y(',I3,
     +')')
  600 FORMAT (
     +'Check the library file at line no.',I3)
  700 FORMAT (
     +'File is not correctly formatted for curve fitting')   
      END
C
C
