C
C
      SUBROUTINE DATSXY (NIN, NMAX, NPTS,
     +                   S, X, Y,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C ACTION : Read in data points X, Y, S from a data file
C          NIN = UNIT number for file opening
C          NMAX = maximum dimension for S, X, Y
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/90
C          14/05/1992 GETNUM
C          03/10/1992 Removed CLOSE statements
C                     Derived from DATTIN by removing ISEND, FIXNPT, LABEL etc.
C          07/01/1993 Added ICOUNT
C          21/02/1994 DBOS version
C          04/09/1996 Added CHKFIL
C          02/11/1997 Added facility to check all s and set all s = 1
C          20/03/1998 Copy of DATFIL but calls OFILES with ISEND = 4
C                     and close NIN on entry
C          28/11/2001 added VU2CHK
C          28/05/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          25/02/2005 added INTENTS (Note: FNAME is INTENT (INOUT) in OFILES) 
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)     :: NIN, NMAX
      INTEGER,             INTENT (OUT)    :: NPTS
      DOUBLE PRECISION,    INTENT (OUT)    :: S(NMAX), X(NMAX), Y(NMAX)
      CHARACTER (LEN = *), INTENT (INOUT)  :: FNAME
      CHARACTER (LEN = *), INTENT (OUT)    :: TITLE
      LOGICAL,             INTENT (OUT)    :: ABORT
C
C Locals
C      
      INTEGER    I, ICOUNT, IOS, J
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      PARAMETER (NCBOT = 3, NCTOP = 3, NRBOT = 1)
      DOUBLE PRECISION ONE, SMIN
      PARAMETER (ONE = 1.0D+00, SMIN = 1.0D-150)
      CHARACTER  LINE*100
      LOGICAL    THERE, XYONLY
      EXTERNAL   OFILES, CHKFIL, PUTFAT  
C
C Initilaise
C     
      ABORT = .TRUE.      
      NPTS = N0  
      TITLE = 'No data'
C
C Attempt to open the file
C
      CLOSE (UNIT = NIN)
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (.NOT.THERE) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN   
      ENDIF   
      CALL OFILES (N4, NIN,
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
C
C File is opened so check title, header and data
C
      NCMID = - N1
      NRMID = - N1
      NRTOP = NMAX
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.0) GOTO 20
      NCMID = J
      NRMID = I
C
C Check if S is supplied
C
      IF (NCMID.EQ.N2) THEN
         XYONLY = .TRUE.
      ELSEIF (NCMID.EQ.N3) THEN
         XYONLY = .FALSE.
      ELSE
         GOTO 20
      ENDIF
      IF (NRMID.LT.N1 .OR. NRMID.GT.NMAX) GOTO 20
      NPTS = NRMID
C
C Read in the data points
C
      IF (XYONLY) THEN
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            S(I) = ONE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I)
            IF (IOS.NE.0) GOTO 20
         ENDDO
      ELSE
         DO I = N1, NPTS
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I), S(I)
            IF (IOS.NE.0) GOTO 20
            IF (S(I).LT.SMIN) THEN
               WRITE (LINE,200) I
               CALL PUTFAT (LINE)
               RETURN
            ENDIF
         ENDDO
      ENDIF
      ABORT = .FALSE.
      RETURN
C
C Here if a crash has occurred reading the file
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
C
C Format statements
C     
  100 FORMAT ( 
     +'DATSXY error: named data file supplied does not exist')   
  200 FORMAT (
     +'DATSXY error: S too small ... Check data point no.',I6)
      END
C
C
