C
C
      SUBROUTINE DATTIN (ISEND, NIN, NMAX, NPTS,
     +                   S, X, Y,
     +                   FNAME, TITLE,
     +                   ABORT, FIXNPT, LABEL)
C
C ACTION : Input data points X, Y, S
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/90
C          14/05/1992 GETNUM
C          03/10/1992 removed CLOSE statements
C          18/01/1993 added NBIG, GET???, removed J, N3, ONETO9, STEMP, XTEMP,
C                     YTEMP and compressed
C          21/02/1994 Now has JSEND = ISEND and calls GETSXY
C          26/02/1994 DBOS version
C          10/11/1995 swapped TITLES for ANSWER and introduced TRIML1
C          04/09/1996 Added CHKFIL
C          05/08/1997 win32 version
C          02/11/1997 Allowed NCOL = 2 and set all S = 1
C          20/03/1998 CLOSE NIN on entry and also opens a temporary file
C                     if data is typed in
C          28/11/2001 added VU2CHK
C          28/05/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          15/02/2005 edited and added call to CHECKF
C          25/02/2007 added INTENTS
C          11/05/2010 introduced NKLCFG to switch on/off the TYPE-IN-DATA option 
C          30/03/2012 used SIM256 to define temporary files curfit_*.tmp
C          04/04/2015 replaced PUTADV by INFOFL
C          01/09/2015 added call to SWITCH
C
C          ISEND: (input/unchanged) as follows
C                 ISEND = 1: User inputs TITLE etc.
C                 ISEND = 2: TITLE etc. from file prepared by MAKFIL
C                 OTHERWISE: User chooses input mode
C           NIN: (input/unchanged) unconnected UNIT number for file opening
C          NMAX: (input/unchanged) Maximum dimension for S, X, Y
C          NPTS: (output)
C       S, X, Y: (output) 
C         FNAME: (output)
C         TITLE: (output)
C         ABORT: (output) error indicator
C        FIXNPT: (input/unchanged) as follows
C                FIXNPT = .TRUE. then NPTS is fixed
C         LABEL: (input/unchanged) as follows
C                LABEL = .TRUE. then input TITLE from terminal
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: ISEND, NIN, NMAX
      INTEGER,             INTENT (OUT) :: NPTS
      DOUBLE PRECISION,    INTENT (OUT) :: S(NMAX), X(NMAX), Y(NMAX)
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME, TITLE
      LOGICAL,             INTENT (IN)  :: FIXNPT, LABEL
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C
      INTEGER    NBIG
      PARAMETER (NBIG = 50)
      INTEGER    I, ICOUNT, IOS, J, JSEND, KSEND, N, NPTSAV
      INTEGER    KVAL10, NKLCFG
      INTEGER    ICOLOR, NUMHDR
      PARAMETER (ICOLOR = 3, NUMHDR = 15)
      INTEGER    NUMDEC, NUMOPT
      PARAMETER (NUMOPT = 3)
      INTEGER    NUMPOS(NUMOPT)
      INTEGER    NUMBLD(NUMHDR)
      INTEGER    N0, N1, N2, N3, N22, N34
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N22 = 22, N34 = 34)
      INTEGER    NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      PARAMETER (NCBOT = 3, NCTOP = 3)
      INTEGER    LSEND
      PARAMETER (LSEND = 2)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 1024) SIM256
      CHARACTER (LEN = 100 ) LINE, OPTION(NUMOPT), TEXT(NUMHDR)
      CHARACTER (LEN = 15  ) WORD15
      CHARACTER (LEN = 8   ) NUM1, NUM2
      LOGICAL    ORDER, WEIGHT
      PARAMETER (ORDER = .TRUE., WEIGHT = .FALSE.)
      LOGICAL    XYONLY
      LOGICAL    EXIST, READ_ONLY
      EXTERNAL   GETIM1, GETSXY, GETSTR, OFILES, PUTFAT, TITLE2,
     +           TRIML1, CHKFIL, GETTMP, CHECKF, FITVAL, INFOFL,
     +           ATTRIB, SIM256, SWITCH
      EXTERNAL   NKLCFG
      INTRINSIC  MIN
      DATA       NUMBLD / 1*1, 2*2, 8*0, 2*1, 2*0 /
      DATA       NUMPOS / NUMOPT*1 /
      DATA       OPTION / 'File/Clipboard',
     +                    'Type-in data',
     +                    'Suppress' /
C
C Initialise
C
      ABORT = .TRUE.
      JSEND = ISEND
      CLOSE (UNIT = NIN)
      WRITE (FNAME,100)
      WRITE (TITLE,200)
      IF (NIN.LT.N1 .OR. NMAX.LT.N1) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
      IF (FIXNPT) THEN
         IF (NPTS.LT.N1 .OR. NPTS.GT.NMAX) THEN
            WRITE (LINE,400)
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         NRBOT = NPTS
         NRTOP = NPTS
         NPTSAV = NPTS
      ELSE
         NRBOT = N1
         NRTOP = NMAX
         NPTSAV = - N1
      ENDIF
C
C Give the user an option if ISEND not 1 or 2
C
      IF (JSEND.LT.N1 .OR. JSEND.GT.N2) THEN
         KVAL10 = NKLCFG(N22)
         IF (KVAL10.EQ.N1) THEN
            WRITE (NUM1,'(I8)') NMAX
            WRITE (NUM2,'(I8)') MIN(NBIG,NMAX)
            CALL TRIML1 (NUM1)
            CALL TRIML1 (NUM2)
            WRITE (TEXT,500) NUM1, NUM2
            NUMDEC = N1
            CALL TITLE2 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT, NUMPOS,
     +                   TEXT,
     +                   OPTION)
         ELSE
            NUMDEC = N1
         ENDIF   
         IF (NUMDEC.EQ.N1) THEN
            JSEND = N2
         ELSEIF (NUMDEC.EQ.N2) THEN
            JSEND = N1
         ELSE
            JSEND = N2
            CALL SWITCH (N34)   
         ENDIF
      ENDIF
      IF (JSEND.EQ.N1) THEN
C
C Type in the data if JSEND = 1
C
         IF (LABEL) THEN
            WRITE (LINE,600)
            CALL GETSTR (LINE, TITLE)
         ENDIF
         IF (.NOT.FIXNPT) THEN
            WRITE (LINE,700)
            CALL GETIM1 (N1, NPTS, MIN(NBIG, NMAX),
     +                   LINE)
         ENDIF
         WRITE (LINE,800)
         CALL GETSXY (NPTS,
     +                S, X, Y,
     +                LINE,
     +                ORDER, WEIGHT)
C
C Write the data typed in into a temporary file
C
         KSEND = N1
         CALL FITVAL (KSEND, N,
     +                ABORT)
         IF (.NOT.ABORT) THEN
            KSEND = N2
            CALL FITVAL (KSEND, N,
     +                   ABORT)
         ENDIF
         IF (ABORT) THEN
            CALL GETTMP (I, FNAME)
         ELSE
            IF (N.LT.10) THEN
               WRITE (WORD15,900) N
            ELSEIF (N.LT.100) THEN
               WRITE (WORD15,1000) N
            ELSE
               WRITE (WORD15,1100) N
            ENDIF
            FNAME = SIM256(WORD15)
            CALL ATTRIB (FNAME,
     +                   EXIST, READ_ONLY)
            IF (EXIST .AND. READ_ONLY) THEN
               WRITE (LINE,1200) FNAME(1:14)
               CALL PUTFAT (LINE)
               CALL GETTMP (I, FNAME)
            ENDIF
         ENDIF
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME)
         WRITE (NIN,'(A)') TITLE
         WRITE (NIN,'(2I6)') NPTS, N3
         DO I = N1, NPTS
            WRITE (NIN,'(1P,3E13.5)') X(I), Y(I), S(I)
         ENDDO
         WRITE (NIN,'(I3)') N1
         WRITE (NIN,1300)
         CLOSE (UNIT = NIN)
         CALL INFOFL (LSEND,
     +                FNAME)        
         ABORT = .FALSE.
         RETURN
      ELSE
C
C Attempt to open the file
C
         CLOSE (UNIT = NIN)
         CALL OFILES (N3, NIN,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            CLOSE (UNIT = NIN)
            WRITE (FNAME,100)
            WRITE (TITLE,200)
            RETURN
         ENDIF
C
C File is now opened so check title, header and data
C
         ABORT = .TRUE.
         NRMID = - N1
         ICOUNT = N1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.N0) GOTO 20
         ICOUNT = N2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.N0) GOTO 20
         NCMID = J
         NRMID = I
C
C Check if there are 2 or 3 columns
C
         IF (NCMID.EQ.N2) THEN
            XYONLY = .TRUE.
         ELSEIF (NCMID.EQ.N3) THEN
            XYONLY = .FALSE.
         ELSE
            GOTO 20
         ENDIF
         IF (NRMID.LT.N1 .OR. NRMID.GT.NMAX) GOTO 20
         IF (FIXNPT .AND. NRMID.NE.NPTSAV) GOTO 20
C
C Offer user view/accept/reject
C
         CLOSE (UNIT = NIN)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            WRITE (FNAME,100)
            WRITE (TITLE,200)
            RETURN
         ELSE
            OPEN (UNIT = NIN, FILE = FNAME)
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         ENDIF
C
C Read in the data
C
         NPTS = NRMID
         IF (XYONLY) THEN
            DO I = N1, NPTS
               ICOUNT = ICOUNT + 1
               S(I) = ONE
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I)
               IF (IOS.NE.N0) GOTO 20
            ENDDO
         ELSE
            DO I = N1, NPTS
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) X(I), Y(I), S(I)
               IF (IOS.NE.N0) GOTO 20
            ENDDO
         ENDIF
         ABORT = .FALSE.
         RETURN
      ENDIF
C
C Label 20: Here if a crash has occurred reading the file
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      WRITE (FNAME,100)
      WRITE (TITLE,200)   
C
C Format statements
C      
  100 FORMAT ('No current file')
  200 FORMAT ('No current data')
  300 FORMAT ('NIN or NMAX out of range in call to DATTIN')
  400 FORMAT ('Illegal value for NPTS in call to DATTIN')
  500 FORMAT (
     + 'This program needs a single table of numbers (x,y) or (x,y,s)'
     +/
     +/'To switch [Type-in data] on or off use [Configure]',
     +', [Advanced], [Speedup].'
     +/
     +/'1)`Curve fit files can be prepared/edited by Makfil/Editfl.'
     +/'2)`Clipboard data must have no labels or missing values.'
     +/'3)`With small data sets, you can type in values, when a'
     +/'  `temporary file called curfit_k.tmp (0 =< k =< 20) will'
     +/'  `be created for you to save or discard retrospectively.'
     +/'4)`For spread sheet data use, e.g. Excel with simfit4.xls'
     +/
     +/'Maximum number of rows from file/clipboard =',1X,A
     +/'Maximum number of rows from the terminal =',1X,A
     +/
     +/'[Suppress] switches off future options to [Type-in data] from',
     + ' the terminal.') 
  600 FORMAT ('Title for these data')
  700 FORMAT ('The number of x,y pairs you want to type in now')
  800 FORMAT (
     +'Supply x,y pairs in order of increasing x: s will be set to 1')
  900 FORMAT ('curfit_',I1,'.tmp ')
 1000 FORMAT ('curfit_',I2,'.tmp')
 1100 FORMAT ('curfit_',I3,'.tmp')
 1200 FORMAT ('Read_only file encountered ... Use attrib -r',1X,A)
 1300 FORMAT ('Default line')
      END
C
C
