C
C This version calls W_DELEET
C
      SUBROUTINE DELEET (FNAME,
     +                   ASKIF, THERE)
C
C ACTION : Delete a file .. THERE = .TRUE. on failure
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 14/5/93
C          21/02/1994 DBOS version
C          18/11/1997 win32 version renamed DELEET and added ASKIF to arguments
C          04/01/2001 increased filename maximum length to 100 characters
C          05/06/2006 copied FNAME to a temporary variable, added TRIML1,
C                     and reduced maximum filename length to 80 characters
C          04/12/2006 added call to W_DELEET
C          01/01/2016 minor editing and defined YES = .FALSE. before calling YESNO2
C
C FNAME: (input/unchanged) file name
C ASKIF: (input/unchanged) if .TRUE. the ask user to confirm delete
C THERE: (output) returned .TRUE. only if delete has failed
C
      IMPLICIT   NONE
C
C Arguments
C
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,             INTENT (IN)  :: ASKIF   
      LOGICAL,             INTENT (OUT) :: THERE
C
C Locals
C
      INTEGER    IOS, N1, N2
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      CHARACTER (LEN = 1024) TEMP
      CHARACTER (LEN = 129 ) LINE
      CHARACTER (LEN = 60  ) WORD60, TRIM60
      LOGICAL    YES
      EXTERNAL   W_DELEET
      EXTERNAL   YESNO2, TRIM60, TRIML1
      INTRINSIC  LEN_TRIM
C
C First of all see if the file exists
C
      INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
      IF (.NOT.THERE) RETURN
      IF (ASKIF) THEN
C
C If ASKIF = .TRUE. ask user to confirm the delete
C                         
         TEMP = FNAME 
         CALL TRIML1(TEMP)
         WORD60 = TRIM60(FNAME)
         N1 = 1
         N2 = LEN_TRIM(WORD60)
         LINE = 'Delete '//WORD60(N1:N2)//' ?'
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YES)
      ELSE
         YES = .TRUE.
      ENDIF
      IF (YES) CALL W_DELEET (FNAME,
     +                        ASKIF, THERE) 
      END
C
C
