C
C
      SUBROUTINE DSPLAY (NCMAX, NCOL, NF, NRMAX, NROW, NTYPE,
     +                   A,
     +                   TITLE,
     +                   FILEIT)
C
C ACTION: Display a title and then a matrix using the viewer
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/08/99
C         04/01/2001 replaced REPEAT by REPEET and introduced BLANK
C         09/07/2004 minor revision and increased NLONG and NWIDE
C         27/05/2005 copied FILEIT to TOFILE internally if matrix small enough
C         30/01/2006 increased NWIDE to 90 and NSWAP to 50
C         28/02/2006 made NSWAP and NWIDE depend on NTYPE and edited FORMATS
C         23/06/2006 introduced I1FILE and I2FILE for header dimensions 
C         21/10/2006 added call to YMDHMS for date stamp
C         20/12/2007 increased NLONG to 100000
C         01/03/2010 added tabs to numerical tables with > 1 column
C         05/09/2010 removed tabs but increased no. sig. fig. and NWIDE
C         14/04/2011 decreased NWIDE
C         05/03/2012 added further argument checks
C         15/10/2012 switched off writing if NF < 1 or NF is not connected
C         07/01/2016 added the case NTYPE = 4 for directed correlation type 
C         30/01/2017 added the case NTYPE = 5 for false discovery rate
C         11/07/2021 added E_NUMBERS and E_FORMATS, etc.
C         31/12/2021 initialised COLS and ROWS to prevent printing a blank line after the title 
C
C         NCMAX: (input/unchanged) max. column dimension
C          NCOL: (input/unchanged) column dimension
C            NF: (input/unchanged) preconnected unit for results
C         NRMAX: (input/unchanged) leading dimension of matrix A
C          NROW: (input/unchanged) row dimension
C         NTYPE: (input/unchanged) data type
C             A: (input/unchanged) data matrix
C         TITLE: (input/unchanged) data title
C        FILEIT: (input/unchanged) write to file if .true.
C
C         If the matrix A is too large a starting row/column is requested
C         If FILEIT = .TRUE. then write output to preconnected UNIT = NF
C         but only if NCOL < NCTOP and NROW < NRTOP
C
C         NTYPE = 1: Integers ... I format
C         NTYPE = 2: Real of order unity  ... F format
C         NTYPE = 3: Floating point numbers ... E format
C         NTYPE = 4: Directed correlation
C         NTYPE = 5: False Discovery rate
C
C         Parameters : NLONG = max. row dimension
C                      NWIDE = max. col dimension
C                      NSWAP = swap over point for output format
C                      This must agree with the FORMAT definitions
C                      NCTOP = max. col dimension for archiving
C                      NRTOP = max. row dimension for archiving
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NCMAX, NCOL, NF, NRMAX, NROW,
     +                                    NTYPE
      DOUBLE PRECISION,    INTENT (IN) :: A(NRMAX,NCMAX)
      CHARACTER (LEN = *), INTENT (IN) :: TITLE
      LOGICAL,             INTENT (IN) :: FILEIT
C
C Locals
C
      INTEGER    NSTART, NSTOP
      INTEGER    KSTART, KSTOP
      INTEGER    I, IFAIL, IOS, J, K, NOUT
      INTEGER    ISEND, LEN200, NLONG, NWIDE
      PARAMETER (ISEND = 1, NLONG = 5000)
      INTEGER    NCTOP, NRTOP
      PARAMETER (NCTOP = 20, NRTOP = 200)
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4)
      CHARACTER (LEN = 1024) FNAME
      CHARACTER (LEN = 100 ) LINE
      CHARACTER (LEN = 32  ) WORD32
      CHARACTER (LEN = 30  ) COLS, ROWS
      CHARACTER (LEN = 13  ) D13(300), SHOWRJ
      CHARACTER (LEN = 1   ) BLANK, COMMA, PATH, PATTERN
      PARAMETER (BLANK = ' ', COMMA = ',') 
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    TOFILE, LONG, LONG1, ONECOL, REPEET, THERE, WIDE, WIDE1
      LOGICAL    ISTOP, OK, OP
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   DELEET, GETNOU, GETTMP, VIEWER, PUTFAT, GETJM1,
     +           YESNO2, LEN200, I1FILE, I2FILE, YMDHMS, M3FILE
      EXTERNAL   E_FORMATS, SHOWRJ
      INTRINSIC  NINT, TRIM
C
C Initialse COLS and ROWS o/w WRITE (NF,'(A)') TRIM(TITLE) prints a blank line when E_NUMBERS = .FALSE.
C      
      COLS = BLANK
      ROWS = BLANK       
C
C Check NTYPE 
C
      IF (NTYPE.LT.1 .OR. NTYPE.GT.5) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF
C
C See if the matrix is too small etc.
C
      IF (NCOL.LT.1 .OR. NROW.LT.1) THEN
         CALL PUTFAT ('NCOL < 1 or NROW < 1 in call to DSPLAY')
         RETURN
      ENDIF   
      IF (NCOL.GT.NCMAX .OR. NROW.GT.NRMAX) THEN
         CALL PUTFAT ('NCOL > NCMAX or NROW > NRMAX in call to DSPLAY')
         RETURN
      ENDIF 
C
C Check NF if writing to file has been requested and then see if NF is connected
C   
      IF (FILEIT) THEN
         IF (NF.LT.1) THEN
            OK = .FALSE.
         ELSE
            INQUIRE (UNIT = NF, OPENED = OP)
            IF (OP) THEN
               OK = .TRUE.
            ELSE
               OK = .FALSE.
            ENDIF      
         ENDIF
      ELSE
         OK = .FALSE.           
      ENDIF   
C
C See if the matrix is too big
C
      IF (NTYPE.EQ.1) THEN
         NWIDE = 300
      ELSEIF (NTYPE.EQ.2) THEN
         NWIDE = 300
      ELSEIF (NTYPE.EQ.3) THEN
         NWIDE = 200
      ELSEIF (NTYPE.EQ.4) THEN
         NWIDE = 4 
      ELSEIF (NTYPE.EQ.5) THEN
         NWIDE = 6     
      ENDIF
      IF (NCOL.GT.NWIDE) THEN
         WIDE = .TRUE.
      ELSE
         WIDE = .FALSE.
      ENDIF
      IF (NROW.GT.NLONG) THEN
         LONG = .TRUE.
      ELSE
         LONG = .FALSE.
      ENDIF
      IF (WIDE .OR. LONG) THEN
         ISTOP = .FALSE.
         CALL M3FILE (NCOL, NLONG, NRMAX, NROW, NTYPE, NWIDE,
     +                A,
     +                TITLE,
     +                ISTOP)
         IF (ISTOP) RETURN
      ENDIF                 
C
C Check if TOFILE must be switched off
C
      IF (OK) THEN
         IF (NCOL.LE.NCTOP .AND. NROW.LE.NRTOP) THEN
            TOFILE = .TRUE.
         ELSE
            TOFILE = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY,
     +'Write this large matrix to the results file',
     +                  TOFILE)
         ENDIF
      ELSE
         TOFILE = .FALSE.
      ENDIF
C
C Main loop to display the matrix ... only once if .NOT.WIDE and .NOT.LONG
C
      LONG1 = LONG
      WIDE1 = WIDE
      REPEET = .TRUE.
      DO WHILE (REPEET)
         IF (WIDE) THEN
C
C Decide where to start if WIDE
C
            I = 1
            J = NCOL - 1
            NSTART = I
            CALL GETJM1 (I, NSTART, J,
     +'Number of the column from which to start the display')
C
C Decide where to stop if WIDE
C
            IF (NCOL - NSTART + 1.GT.NWIDE) THEN
               I = NSTART + 1
               J = NSTART + NWIDE - 1
               NSTOP = J
               CALL GETJM1 (I, NSTOP, J,
     +'Number of the column at which to end the display')
            ELSE
               NSTOP = NCOL
            ENDIF
         ELSE
C
C Matrix is .NOT.WIDE
C
            NSTART = 1
            NSTOP = NCOL
         ENDIF
         IF (LONG) THEN
C
C Decide where to start if LONG
C
            I = 1
            J = NROW - 1
            KSTART = I
            CALL GETJM1 (I, KSTART, J,
     +'Number of the row from which to start the display')
C
C Decide where to stop if LONG
C
            IF (NROW - KSTART + 1.GT.NLONG) THEN
               I = KSTART + 1
               J = KSTART + NLONG - 1
               KSTOP = J
               CALL GETJM1 (I, KSTOP, J,
     +'Number of the row at which to end the display')
            ELSE
               KSTOP = NROW
            ENDIF
         ELSE
C
C Matrix is .NOT.LONG
C
            KSTART = 1
            KSTOP = NROW
         ENDIF
C
C Open a temporary file and write the title
C
         CALL GETNOU (NOUT)
         CALL GETTMP (IFAIL,
     +                FNAME)
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF
         
         E_NUMBERS = E_FORMATS()
         
         WRITE (NOUT,'(A)') TITLE
         I = KSTOP - KSTART + 1
         J = NSTOP - NSTART + 1
         CALL I2FILE (NOUT, I, J)
         
         IF (TOFILE) THEN
            WRITE (NF,'(A)') BLANK
            WRITE (NF,'(A)') TRIM(TITLE)
         ENDIF
     
C
C Declare NSTART, NSTOP, KSTART, KSTOP if WIDE .OR. LONG
C
         IF (NSTOP.LT.10) THEN
            WRITE (COLS,200) NSTART, NSTOP
         ELSEIF (NSTOP.LT.100) THEN
            WRITE (COLS,210) NSTART, NSTOP
         ELSEIF (NSTOP.LT.1000) THEN
            WRITE (COLS,220) NSTART, NSTOP
         ELSEIF (NSTOP.LT.10000) THEN
            WRITE (COLS,230) NSTART, NSTOP      
         ELSE
            WRITE (COLS,240) NSTART, NSTOP
         ENDIF
         
         IF (NSTART.NE.1 .OR. NSTOP.NE.NCOL) THEN
            IF (TOFILE) WRITE (NF,'(A)') COLS
         ENDIF
         
         IF (KSTOP.LT.10) THEN
            WRITE (ROWS,300) KSTART, KSTOP
         ELSEIF (KSTOP.LT.100) THEN
            WRITE (ROWS,310) KSTART, KSTOP
         ELSEIF (KSTOP.LT.1000) THEN
            WRITE (ROWS,320) KSTART, KSTOP
         ELSEIF (KSTOP.LT.10000) THEN
            WRITE (ROWS,330) KSTART, KSTOP   
         ELSE
            WRITE (ROWS,340) KSTART, KSTOP
         ENDIF
         
         IF (KSTART.NE.1 .OR. KSTOP.NE.NROW) THEN
            IF (TOFILE) WRITE (NF,'(A)') ROWS
         ENDIF
C
C Define ONECOL
C         
         IF (NSTOP.EQ.NSTART) THEN
            ONECOL = .TRUE.
         ELSE
            ONECOL = .FALSE.
         ENDIF    
         IF (NTYPE.EQ.1) THEN
C
C I format
C
            DO I = KSTART, KSTOP
               IF (ONECOL) THEN
                  WRITE (NOUT,'(I10)') NINT(A(I,NSTART))
               ELSE   
                  WRITE (NOUT,400) (NINT(A(I,J)), 
     +                              J = NSTART, NSTOP)
               ENDIF   
               IF (TOFILE) WRITE (NF,400) (NINT(A(I,J)),
     +                                     J = NSTART, NSTOP)
            ENDDO
         ELSEIF (NTYPE.EQ.2) THEN
C
C F format
C
            DO I = KSTART, KSTOP
               IF (ONECOL) THEN
                  WRITE (NOUT,'(F12.6)') A(I,NSTART)
               ELSE   
                  WRITE (NOUT,500) (A(I,J), J = NSTART, NSTOP)
               ENDIF   
               IF (TOFILE) WRITE (NF,500)
     +                          (A(I,J), J = NSTART, NSTOP)
            ENDDO
         ELSEIF (NTYPE.EQ.3) THEN
C
C E format
C
            DO I = KSTART, KSTOP
               IF (E_NUMBERS) THEN
                  IF (ONECOL) THEN
                     WRITE (NOUT,'(1P,E15.7)') A(I,NSTART)
                  ELSE   
                     WRITE (NOUT,600) (A(I,J), J = NSTART, NSTOP)
                  ENDIF
                  IF (TOFILE) WRITE (NF,600) (A(I,J), J = NSTART, NSTOP)
               ELSE
                  IF (ONECOL) THEN
                     D13(1) = SHOWRJ(A(I,NSTART))
                     WRITE (NOUT,'(A)') D13(1)
                     IF (TOFILE) WRITE (NF,'(A)') D13(1)
                  ELSE   
                     DO J = NSTART, NSTOP
                        D13(J) = SHOWRJ(A(I,J)) 
                     ENDDO   
                     WRITE (NOUT,650) (D13(J), J = NSTART, NSTOP)
                     IF (TOFILE) WRITE (NF,650)
     +                                 (D13(J), J = NSTART, NSTOP)
                  ENDIF
               ENDIF  
            ENDDO
         ELSEIF (NTYPE.EQ.4) THEN
C
C i, j, r(i,j), p(i,j) format for directed correlation
C
            DO I = KSTART, KSTOP
               WRITE (NOUT,700) NINT(A(I,1)), NINT(A(I,2)), 
     +                          A(I,3), A(I,4)
               IF (TOFILE) WRITE (NF,700) NINT(A(I,1)), NINT(A(I,2)), 
     +                                    A(I,3), A(I,4)
            ENDDO            
          ELSEIF (NTYPE.EQ.5) THEN
C
C i, j, r(i,j), p(k), ap(k_, fdr(k), l format for false discovery rate
C
            DO I = KSTART, KSTOP
               WRITE (NOUT,800) NINT(A(I,1)), NINT(A(I,2)), 
     +                          A(I,3), A(I,4), A(I,5), NINT(A(I,6))
               IF (TOFILE) WRITE (NF,800) NINT(A(I,1)), NINT(A(I,2)), 
     +                                    A(I,3), A(I,4), A(I,5),
     +                                    NINT(A(I,6))
            ENDDO               
         ENDIF
C
C Write the trailer
C
         I = 2
         CALL I1FILE (NOUT, I)
         IF (ONECOL) THEN
            J = LEN200(ROWS)
            WRITE (NOUT,'(A)') ROWS(1:J)
         ELSE       
            J = LEN200(ROWS)
            K = LEN200(COLS)
            LINE = ROWS(1:J)//COMMA//BLANK//COLS(1:K)
            WRITE (NOUT,'(A)') LINE
         ENDIF
         CALL YMDHMS (WORD32)
         WRITE (NOUT,'(A)') WORD32
C
C Close the temporary file, send to the viewer then delete
C
         CLOSE (UNIT = NOUT)
         PATH = BLANK
         PATTERN = BLANK
         CALL VIEWER (ISEND,
     +                FNAME, PATH, PATTERN)
         CALL DELEET (FNAME,
     +                ASKIF, THERE)
C
C If WIDE or LONG ask if further viewing is required
C
         IF (WIDE1)  CALL YESNO2 (ICOLOR, IX, IY,
     +'More viewing ... starting from a different column',
     +                            WIDE)
         IF (LONG1)  CALL YESNO2 (ICOLOR, IX, IY,
     +'More viewing ... starting from a different row',
     +                            LONG)
         IF (WIDE .OR. LONG) THEN
            REPEET = .TRUE.
         ELSE
            REPEET = .FALSE.
         ENDIF
      ENDDO
C
C Format statements
C      
  100 FORMAT ('NTYPE out of range in call to DSPLAY')
  200 FORMAT ('Columns',I2,' to',I2)
  210 FORMAT ('Columns',I3,' to',I3)
  220 FORMAT ('Columns',I4,' to',I4)
  230 FORMAT ('Columns',I5,' to',I5)
  240 FORMAT ('Columns',I8,' to',I8)
  300 FORMAT ('Rows',I2,' to',I2)
  310 FORMAT ('Rows',I3,' to',I3)
  320 FORMAT ('Rows',I4,' to',I4)
  330 FORMAT ('Rows',I5,' to',I5)
  340 FORMAT ('Rows',I8,' to',I8)
  400 FORMAT (300(I10))
  500 FORMAT (300(F12.6))
  600 FORMAT (200(1P,E15.7))
  650 FORMAT (200(1X,A13))
  700 FORMAT (2I7,1X,2(F10.6)) 
  800 FORMAT (2I7,1X,3(F10.6),I4) 
        END
C
C

