c
c
      subroutine editsi (isend, itype, ncol, nrmax, nrow, 
     +                   x,
     +                   title,
     +                   curve, fixcol, fixrow, label, order, weight)               
c
c action: simple numeric editor for Linux/Wine
c author: w.g.bardsley, university of manchester, u.k., 02/12/2006
c
c  isend: (input/unchanged) as follows:
c          isend = 1: view only
c          isend = 2: normal editing
c          isend = 3: initialise, i.e. fill in blank matrix
c  itype: (input/unchanged) as follows:
c          itype = 1: double precision
c          itype = 2: integers
c          itype = 3: integers 0 or 1
c          itype = 4: integers -1, 0, or 1
c          itype = 5: parameter limits x(i,1) =< x(i,2) =< x(i,3)
c      x: (input/output) data matrix
c  title: (input/unchanged) data title  
c  curve: (input/unchanged) curve fitting file
c fixcol: (input/unchanged) fix no. columns (unused)
c fixrow: (input/unchanged) fix no. rows (unused)
c  label: (input/unchanged) use title supplied (unused)
c  order: (input/unchanged) put column 1 in order
c weight: (input/unchanged) column 3 >= epsi 
c     
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: isend, itype, ncol, nrmax,
     +                                       nrow
      double precision,    intent (inout) :: x(nrmax,ncol)    
      character (len = *), intent (in)    :: title   
      logical,             intent (in)    :: curve, fixcol, fixrow,
     +                                       label, order, weight            
c
c local allocatable arrays
c     
      double precision,     allocatable :: d(:,:), y(:,:), z(:)       
      character (len = 30), allocatable :: text(:)
      character (len = 1),  allocatable :: cipher(:)
c
c locals
c                                
      integer    numopt, numtxt
      parameter (numopt = 8, numtxt = 20) 
      integer    i, ierr, itemp, j, ncol1, nrow1, ntype, numdec
      integer    numbld(numtxt)
      double precision xbot, xmid, xtop, ztemp 
      double precision dij, xij, yij
      double precision epsi, factor, one, zero 
      parameter (epsi = 1.0d-100, factor = 1.0d-04, one = 1.0d+00,
     +           zero = 0.0d+00)
      character  error(10)*80, line*100, opts(30)*100 
      character  text1*30, text2*30, text3(numtxt)*100
      parameter (text1 = 'Accept new column',
     +           text2 = 'Restore old column' )  
      character  blank*1, star*1
      parameter (blank = ' ', star = '*')
      logical    again, ok, repeet
      external   listbx, viewit, getjm1, getd01, getj01, putfat, patch2,
     +           putadv, putwar, show_file_formats   
      intrinsic  nint, dble, abs    
      data       numbld / numtxt*0 /
      data       error /
     +'Must have ncol >= 1, nrow >= 1 nrmax >= 1',  
     +'Must have 1 =< isend =< 3',
     +'Must have 1 =< itype =< 5',
     +'Parameter limit matrices must have 3 columns',
     +'Curve fitting files must have 2 or 3 columns',
     +'Column 1 must be in nondecreasing order',
     +'Must have positive weights in column 3', 
     +'Value must be 0 or 1',
     +'Value must be -1, 0, or 1',
     +'Must have x(i,1) =< x(i,2) =< x(i,3)' /
     
c
c Part 1: check for error conditions then define ntype
c =======
c    
  
      if (ncol.lt.1 .or. nrmax.lt.1 .or. nrow.lt.1) then
         call putfat (error(1))
         return  
      endif  
      if (isend.lt.1 .or. isend.gt.3) then
         call putfat (error(2))
         return               
      endif   
      if (itype.lt.1 .or. itype.gt.5) then
         call putfat (error(3))
         return               
      endif   
      if (itype.eq.5 .and. ncol.ne.3) then
         call putfat (error(4)) 
         return               
      endif   
      if (curve) then
         if (ncol.lt.2 .or. ncol.gt.3) then
            call putfat (error(5))
            return   
         endif   
      endif     
c
c define ntype
c      
      if (itype.eq.1 .or. itype.eq.5) then
         ntype = 3
      else
         ntype = 1
      endif                
      
c
c Part 2: next action depends upon isend
c =======
c
      
      if (isend.eq.1) then     
c
c isend = 1: view then return
c ----------
c      
         call viewit (ncol, nrmax, nrow, ntype,
     +                x,
     +                title)
         return                
      elseif (isend.eq.2) then
c
c isend = 2: check the input matrix
c ----------
c                       
         if (order) then 
c
c order = .true. so column 1 must be in nondecreasing order
c         
            ok = .true.
            i = 0
            do while (i.lt.nrow - 2 .and. ok )
               i = i + 1
               if (x(i,1).gt.x(i + 1,1)) ok = .false.
            enddo  
            if (.not.ok) call putwar (error(6))
         endif 
         if (weight) then
c
c weight = .true. so column 4 must be positive
c         
            ok = .true.
            i = 0
            do while (i.lt.nrow .and. ok )
               i = i + 1
               if (x(i,3).lt.epsi) ok = .false.
            enddo  
            if (.not.ok) call putwar (error(7))
         endif 
         if (itype.eq.3) then 
c
c itype = 3 so only 0 and 1 are allowed
c         
            ok = .true.
            i = 0
            do while (i.lt.nrow .and. ok )
               i = i + 1
               j = 0
               do while (j.lt.ncol .and. ok)
                  j = j + 1
                  if (x(i,j).lt.zero .or. x(i,j).gt.one) ok = .false.
               enddo
            enddo  
            if (.not.ok) call putwar (error(8))
         elseif (itype.eq.4) then     
c
c itype = 4 so only -1, 0, and 1 are allowed
c         
            ok = .true.
            i = 0
            do while (i.lt.nrow .and. ok )
               i = i + 1
               j = 0
               do while (j.lt.ncol .and. ok)
                  j = j + 1
                  if (x(i,j).lt.-one .or. x(i,j).gt.one) ok = .false.
               enddo
            enddo  
            if (.not.ok) call putwar (error(9))     
         elseif (itype.eq.5) then
            ok = .true.
            i = 0
            do while (i.lt.nrow .and. ok )
               i = i + 1                  
               xbot = x(i,1)
               xmid = x(i,2)
               xtop = x(i,3)
               if (xbot.gt.xmid .or. xmid.gt.xtop) ok = .false.
            enddo  
            if (.not.ok) call putwar (error(10))
         endif
      elseif (isend.eq.3) then 
c
c isend = 3: initialise 
c ----------
c                     
         if (itype.eq.5) then  
c
c parameter limits values initialised to -1, 0, 1
c         
            do i = 1, nrow
               x(i,1) = - one
               x(i,2) = zero
               x(i,3) = one
            enddo
         else  
c
c other files have column 1 in increasing order but have 1 everywhere else
c         
            x(1,1) = one               
            do i = 2, nrow
               x(i,1) = x(i - 1,1) + one
            enddo  
            if (ncol.gt.1) then 
               do j = 2, ncol
                  do i = 1, nrow
                     x(i,j) = one
                  enddo
               enddo    
            endif
         endif      
      endif
              
c
c Part 3: allocate workspace then copy x into y
c =======
c     
   
      ierr = 0   
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return             
      if (allocated(y)) deallocate(y, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(z)) deallocate(z, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(text)) deallocate(text, stat = ierr)
      if (ierr.ne.0) return 
      allocate(d(nrow,ncol), stat = ierr)
      if (ierr.ne.0) return  
      allocate(y(nrow,ncol), stat = ierr)
      if (ierr.ne.0) return   
      allocate(z(nrow), stat = ierr)
      if (ierr.ne.0) return  
      allocate(cipher(nrow), stat = ierr)
      if (ierr.ne.0) return            
      allocate(text(nrow + 2), stat = ierr)
      if (ierr.ne.0) return  
      if (fixcol .or. fixrow  .or. label) z(1) = one!to silence ftn95
      do j = 1, ncol
         do i = 1, nrow
            y(i,j) = x(i,j)
         enddo
      enddo  
      
c
c Part 4: main loop
c =======
c     
 
      ncol1 = 1
      repeet = .true.
      do while (repeet) 
         write (opts,100)
         numdec = numopt - 2
         call listbx (numdec, numopt,
     +                opts)         
         if (numdec.eq.1) then    
c
c numdec = 1: view original matrix
c ===========
c                                 
            call viewit (ncol, nrmax, nrow, ntype,
     +                   x,
     +                   title)
         elseif (numdec.eq.2) then 
c
c numdec = 2: view edited matrix y
c ==========
c         
            write (line,200) 'Edited'
            call viewit (ncol, nrow, nrow, ntype,
     +                   y,
     +                   line)  
         elseif (numdec.eq.3) then 
c
c numdec = 3: view difference matrix d
c ==========
c               
            do j = 1, ncol
               do i = 1, nrow       
                  xij = x(i,j)
                  yij = y(i,j)
                  dij = xij - yij 
                  if (abs(dij).lt.factor*(abs(xij)+abs(yij))) dij = zero 
                  d(i,j) = dij
               enddo
            enddo
            write (line,200) 'Difference'
            call viewit (ncol, nrow, nrow, ntype,
     +                   d,
     +                   line)                       
         elseif (numdec.eq.4) then
c
c numdec = 4: edit a column 
c ==========
c         
            if (ncol.eq.1) then
               ncol1 = 1
            else   
               write (line,300)
               i = 0
               j = ncol
               call getjm1 (i, ncol1, j,
     +                      line)  
               if (itype.eq.1) then
                  if (ncol1.eq.1 .and. order) then
                     call putadv (error(6))
                  elseif (ncol.eq.3 .and. weight) then
                     call putadv (error(7))
                  endif   
               elseif (itype.eq.3) then
                  call putadv (error(8))
               elseif (itype.eq.4) then
                  call putadv (error(9))      
               elseif (itype.eq.3) then
                  call putadv (error(10))   
               endif   
            endif
            if (ncol1.gt.0) then 
c
c read the column from y into z
c                              
               do i = 1, nrow
                  z(i) = y(i,ncol1)
               enddo 
c
c subsidiary loop for editing
c                             
               text(1) = text1
               text(2) = text2
               do i = 1, nrow
                  cipher(i) = blank
               enddo    
               again = .true.
               do while (again)   
                  nrow1 = 2 
c
c copy a column from y into z
c                  
                  do i = 1, nrow 
                     nrow1 = nrow1 + 1  
                     if (itype.eq.1 .or. itype.eq.5) then
                        write (text(nrow1),400) i, z(i), cipher(i)
                     else 
                        write (text(nrow1),500) i, nint(z(i)), cipher(i)  
                     endif   
                  enddo  
                  i = 1
                  call listbx (i, nrow1,
     +                         text)  
                  if (i.eq.1) then 
c
c i = 1: apply the editing
c ******
c                  
                     do i = 1, nrow
                        y(i,ncol1) = z(i)
                     enddo 
                     again = .false.
                  elseif (i.eq.2) then
c
c i = 2: reject the editing
c ******
c                    
                     again = .false.
                  else   
c
c i = 3: edit the column vector
c ******
c                    
                     j = i - 2
                     write (line,600) j, ncol1
                     ztemp = z(j)
                     if (itype.eq.1 .or. itype.eq.5) then 
c
c double_precision_value
c                     
                        call getd01 (ztemp,
     +                               line)   
                     else
c     
c integer_value
c                           
                        itemp = nint(z(j))         
                        call getj01 (itemp,
     +                               line)
                     endif
                     ok = .true.
                     if (order .and. ncol1.eq.1) then
c
c check for increasing order
c                     
                        xmid = ztemp
                        if (j.eq.1) then
                           xbot = ztemp - one
                           xtop = z(j + 1)
                        elseif (j.eq.nrow) then
                           xbot = z(j - 1)
                           xtop = ztemp + one
                        else
                           xbot = z(j - 1)
                           xtop = z(j + 1)
                        endif
                        if (xmid.lt.xbot .or. xmid.gt.xtop) then
                           ok = .false.
                           call putfat (error(6)) 
                        endif                                         
                     elseif (weight .and. ncol.eq.3) then
c
c check for positive weights
c                     
                        if (ztemp.lt.epsi) then
                           ok = .false. 
                           call putfat (error(7))
                        endif   
                     endif  
c
c now check depending on itype
c                      
                     if (ok) then
                        if (itype.eq.1) then
                           z(j) = ztemp
                        elseif (itype.eq.2) then
                           z(j) = dble(itemp)
                        elseif (itype.eq.3) then 
                           if (itemp.ge.0 .and. itemp.le.1) then
                              z(j) = dble(itemp)
                           else  
                              ok = .false.
                              call putfat (error(8))
                           endif      
                        elseif (itype.eq.4) then
                           if (itemp.ge.-1 .and. itemp.le.1) then
                              z(j) = dble(itemp)
                           else
                              ok = .false.  
                              call putfat (error(9))
                           endif                                
                        elseif (itype.eq.5) then  
                           xbot = y(j,1)
                           xmid = y(j,2)
                           xtop = y(j,3)
                           if (ncol1.eq.1) then
                              xbot = ztemp 
                           elseif (ncol1.eq.2) then
                              xmid = ztemp
                           else
                              xtop = ztemp
                           endif 
                           if (xbot.gt.xmid .or. xmid.gt.xtop) then 
                              ok = .false.
                              call putfat (error(10))
                           else
                              z(j) = ztemp   
                           endif   
                        endif
                     endif
                     if (ok) cipher(j) = star    
                  endif 
               enddo               
            endif  
         elseif (numdec.eq.numopt - 3) then       
c
c numdec = numopt - 3: formats
c ====================     
c
            call show_file_formats                 
         elseif (numdec.eq.numopt - 2) then       
c
c numdec = numopt - 2: help
c ====================
c                                  
            write (text3,1000)
            numbld(1) = 1
            call patch2 (numbld, numtxt,
     +                   text3)            
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: accept editing
c ====================
c         
            do j = 1, ncol
               do i = 1, nrow
                  x(i,j) = y(i,j)
               enddo
            enddo  
            repeet = .false.
         elseif (numdec.eq.numopt) then 
c
c numdec = numopt: reject the editing
c ================
c          
            repeet = .false.
         endif              
      enddo   
c
c deallocate workspace
c      
      deallocate(y, stat = ierr) 
      deallocate(z, stat = ierr)
      deallocate(cipher, stat = ierr)
      deallocate(text, stat = ierr)
c
c format statements
c      
  100 format (
     + 'View: the old data'
     +/'View: new edited data'
     +/'View: differences'
     +/'Edit a chosen column'  
     +/'Help: file formats'
     +/'Help: editor functions'
     +/'Accept new edited data'
     +/'Restore the old data') 
  200 format (a,1x,'matrix: Columns can be selected for editing')                     
  300 format ('Column number for editing (0 for no action)')
  400 format (i6,1x,1p,e13.5,1x,a)
  500 format (i6,1x,i8,1x,a)
  600 format (
     +'New value required for x(',i5,',',i5,')')
 1000 format (
     + 'Elementary numerical editing'
     +/
     +/'This editor provides a very simple interface for editing data'
     +/'matrices which is intended to be used when the operating system'
     +/'does not execute the full Simfit editor properly. For instance,'
     +/'Linux/Wine users may have to use this cut down editor.'
     +/
     +/'At each stage of editing, you can view the current data set and'
     +/'select a column for editing. When the chosen column has been'
     +/'edited you have the option to use the edited column to replace'
     +/'the current column, or you can choose to discard the editing.'   
     +/'At the end of the editing you can choose to use the current'
     +/'edited matrix to overwrite the original data set, or you can'
     +/'discard the editing and restore the original data set.'
     +/
     +/'The editor will prevent you doing some things, like having'
     +/'column 1 in decreasing order in curve-fitting files, having'
     +/'nonpositive wieghts in column 3 of a curve fitting file, or'
     +/'choosing bottom limit > starting estimate, or starting estimate'
     +/'> upper limit in a parameter limits file.')
      end
c
c      