C
C
      SUBROUTINE EDITTT (NBIG, NLINES,
     +                   PHRASE, TITLE)
C
C ACTION : Edit title and/or text before writing an output file
C AUTHOR : W. G. Bardsley, University of manchester, 29/9/94
C          08/10/1998 added w_edittx
C          28/10/1998 removed WORD from argument list
C          25/02/2007 edited and added INTENTS
C
      IMPLICIT   NONE 
C
C  Arguments
C
      INTEGER,             INTENT (IN)    :: NBIG
      INTEGER,             INTENT (INOUT) :: NLINES
      CHARACTER (LEN = *), INTENT (INOUT) :: PHRASE(NBIG), TITLE
C
C Locals
C      
      INTEGER    I, NOPT, NWIDE
      INTEGER    JCOLOR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NUMOPT = 4,
     +           NSTART = 7, NTEXT = 10)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    WHITE
      PARAMETER (WHITE = 15)
      CHARACTER (LEN = 12) I12, FORM12 
      CHARACTER  LINE*80, TEXT(NTEXT)*100 
      LOGICAL    REPEET
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   FORM12
      EXTERNAL   EDITTX, GETSTR, HBOX01, TABLE1
      INTRINSIC  LEN, TRIM
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / 1, 3, 1, 1 /
      NWIDE = LEN(PHRASE(1))
      NUMBLD(6) = 1    
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NOPT = 1
         WRITE (TEXT,100)
         CALL HBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NOPT, NUMOPT,
     +                NUMPOS, NSTART, NTEXT, 
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         IF (NOPT.EQ.1) THEN
C
C Edit the title
C         
            CALL GETSTR ('The new title', TITLE)
         ELSEIF (NOPT.EQ.2) THEN 
C
C Edit the text
C         
            CALL EDITTX (NBIG, NLINES, NWIDE, 
     +                   PHRASE)
            IF (NLINES.LE.0) THEN
               NLINES = 1
               PHRASE(1) = 'Default line'
            ELSEIF (NLINES.GT.NBIG) THEN
               NLINES = NBIG
            ENDIF
         ELSEIF (NOPT.EQ.3) THEN
C
C View title and text
C         
            CALL TABLE1 (WHITE, 'OPEN')
            JCOLOR = 4
            WRITE (LINE,200)
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            CALL TABLE1 (JCOLOR, TITLE)
            I12 = FORM12(NLINES)
            WRITE (LINE,300) TRIM(I12)
            JCOLOR = 4
            CALL TABLE1 (JCOLOR, LINE)
            JCOLOR = 0
            DO I = 1, NLINES
               CALL TABLE1 (JCOLOR, PHRASE(I))
            ENDDO
            CALL TABLE1 (WHITE, 'CLOSE')
         ELSE
            REPEET = .FALSE.      
         ENDIF  
      ENDDO   
C
C Format statements
C      
  100 FORMAT (
     + 'Always change the title after editing data, since the title is'
     +/'written to the output file to identify the data analysed (even'
     +/'with temporary files). Failure to edit the title and text now'
     +/'may lead to confusion in the future.'
     +/
     +/'You have been warned!'
     +/'Title'
     +/'Text'
     +/'View'
     +/'Save')
  200 FORMAT ('Title:')
  300 FORMAT ('Text (number of lines =',1X,A,'):')
      END
C
C
