c
c
      subroutine eofcha (nlabel,
     +                   fname, labels,
     +                   abort)
c
c action: attempt to retrieve character labels from end of the file supplied
c author: w.g.bardsley, university of manchester, u.k., 20/10/2006 
c         14/05/2007 revised to intialise wtemp and accept spaces in labels
c         29/12/2007 added no_labels to trap labels(1) = '%no_labels%'
c
c Note: this returns abort = .false. and initialises labels only if nlabel
c       non-blank string values were read off the file. Otherwise
c       it returns abort = .true. and labels is not referenced. To succeed  
c       the strings must follow the token 
c       '\begin{labels}' 
c       but the file can be any arbitrary text file, not necessarily a simfit
c       type data file. 
c
c nlabel: (input/unchanged) no. of labels required, nlabel > 0
c  fname: (input/unchanged) arbitrary file     
c labels: (input/output) character strings
c  abort: (output) error indicator
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: nlabel
      character (len = *), intent (in)    :: fname  
      character (len = *), intent (inout) :: labels(nlabel)
      logical,             intent (out)   :: abort
c
c local allocatable array
c                        
      character (len = 100), allocatable :: wtemp(:)
c
c locals
c       
      integer    i, ierr, ios, nout, ntemp   
      character  no_labels*11
      parameter (no_labels = '%no_labels%')
      logical    there 
      character  line*1024 
      character  cipher*13, ender*11       !this must not be changed
      parameter (cipher = 'begin{labels}', !this must not be changed
     +           ender = 'end{labels}')    !this must not be translated
      external   getnou  
c
c initialise abort then see if fname exists
c      
      abort = .true.     
      if (nlabel.lt.1) return
      inquire (file = fname, exist = there, iostat = ios) 
      if (.not.there .or. ios.ne.0) return 
c
c connect fname to unit = nout
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif  
c
c allocate character workspace
c        
      ierr = 0
      if (allocated(wtemp)) deallocate(wtemp, stat = ierr)
      if (ierr.ne.0) return
      allocate (wtemp(nlabel), stat = ierr)
      if (ierr.ne.0) return  
      do i = 1, nlabel
         wtemp(i) = ender
      enddo
c
c locate the labels if possible
c      
      ios = 0     
      ntemp = 0
      do while (ios.eq.0 .and. ntemp.lt.1)  
         read (nout,'(a)',iostat=ios) line 
         if (ios.eq.0 .and. index(line,cipher).gt.0) then 
            i = 0
            do while (ios.eq.0 .and. i.lt.nlabel)
               i = i + 1 
               if (ios.eq.0) read (nout,'(a)',iostat=ios) line  
c
c check if the first label is '%no_labels%
c                 
               if (ios.eq.0 .and. i.eq.1) then
                  if (line.eq.no_labels) then
                     abort = .false.
                     labels(1) = no_labels
                     deallocate(wtemp, stat = ierr)
                     close (unit = nout)
                     return
                  endif   
               endif    
               if (ios.eq.0 .and. index(line,ender).le.0) then
                  ntemp = ntemp + 1
                  wtemp(ntemp) = line(1:100) 
               else  
                  ios = -1
               endif   
            enddo   
         endif
      enddo
      close (unit = nout)
c
c initialise labels if nlabel non-blank labels have been read off the file
c      
      if (ntemp.eq.nlabel) then
         do i = 1, nlabel
            labels(i) = wtemp(i)
         enddo 
         abort = .false.  
      endif   
      deallocate (wtemp, stat = ierr)
      end
c
c      
      