c
c
      subroutine eofdbl (kcol, krmax, krow,
     +                   x, 
     +                   fname, 
     +                   abort)
c
c action: attempt to retrieve double precision values from end of the file supplied
c author: w.g.bardsley, university of manchester, u.k., 20/10/2006
c
c Note: this returns abort = .false. and initialises x only if krow > 0
c       double precision values were read off the file. Otherwise
c       it returns abort = .true. and x is not referenced.   
c       To succeed, the strings must follow the token
c       '\begin{values}'
c       but the file can be any arbitrary text file, not necessarily a simfit
c       type data file. 
c
c  kcol: (input/unchanged) actual width of array
c krmax: (input/unchanged) max. no. of rows allowed
c  krow: (output) actual number of rows returned 
c     x: (input/output) if successful then loaded across columns as read in 
c fname: (input/unchanged) arbitrary file     
c abort: (output) error indicator
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: kcol, krmax
      integer,             intent (out)   :: krow  
      double precision,    intent(inout)  :: x(krmax*kcol)
      character (len = *), intent (in)    :: fname  
      logical,             intent (out)   :: abort
c
c local allocatable array
c                        
      double precision, allocatable :: w(:)
c
c locals
c       
      integer    i, ierr, ios, j, k, nout   
      logical    there 
      character  line*1024 
      character  cipher*13                 !this must not be changed
      parameter (cipher = 'begin{values}') !this must not be changed
      logical    ok
      external   getnou  
c
c initialise abort then check if fname exists
c      
      abort = .true. 
      krow = 0    
      if (kcol.lt.1 .or. krmax.lt.1) return
      inquire (file = fname, exist = there, iostat = ios) 
      if (.not.there .or. ios.ne.0) return 
c
c connect fname to unit = nout
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif  
c
c allocate workspace
c        
      ierr = 0
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      allocate (w(kcol), stat = ierr)
      if (ierr.ne.0) return
c
c locate the values if possible
c              
      ok = .true. 
      k = 0                    
      do while (ok .and. ios.eq.0)  
         read (nout,'(a)',iostat=ios) line 
         if (ios.ne.0) ok = .false.
         if (ok .and. index(line,cipher).gt.0) then 
            i = 0
            do while (ok .and. i.lt.krmax)
               i = i + 1
               read(nout,*,iostat=ios) (w(j), j = 1, kcol)
               if (ios.eq.0) then
                  krow = krow + 1
                  do j = 1, kcol
                     k = k + 1
                     x(k) = w(j)
                  enddo
               else
                  ok = .false.
               endif      
            enddo
         endif
      enddo
      close (unit = nout)
c
c set abort = .false. if krow > 0
c      
      if (krow.gt.0) abort = .false. 
      deallocate (w, stat = ierr)
      end
c
c      
      