c
c
      subroutine eofexp (npar, nx, 
     +                   pbot, pmid, ptop, 
     +                   fname, 
     +                   abort)
c
c action: attempt to retrieve expert mode values from end of the file supplied
c author: w.g.bardsley, university of manchester, u.k., 15/11/2006
c         23/07/2007 changed ciphers to begin{limits}.. end{limits} and first line counter not required
c
c Note: this returns abort = .false. and initialises parameters only if npar > 0
c       double precision triple values were read off the file. Otherwise
c       it returns abort = .true. and parameters are not referenced.   
c       To succeed, the strings must follow the token
c       'begin{limits}'
c       but the file can be any arbitrary text file, not necessarily a simfit
c       type data file. 
c
c  npar: (output) no. of parameters assigned
c    nx: (input/unchanged) max. no. of parameters allowed
c  pbot: (input/output) lower limits
c  pmid: (input/output) starting values  
c  ptop: (input/output) upper limits 
c fname: (input/unchanged) arbitrary file     
c abort: (output) error indicator
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: nx
      integer,             intent (out)   :: npar  
      double precision,    intent (inout) :: pbot(nx), pmid(nx),
     +                                       ptop(nx)
      character (len = *), intent (in)    :: fname  
      logical,             intent (out)   :: abort
c
c local allocatable array
c                        
      double precision, allocatable :: w(:)
c
c locals
c       
      integer    i, ierr, ios, j, j1, j2, j3, k, nout   
      logical    there 
      character  line*1024 
      character  cipher*13, ender*11       !this must not be changed
      parameter (cipher = 'begin{limits}', !this must not be changed
     +           ender = 'end{limits}')    !this must not be translated
      logical    ok
      external   getnou        
c
c initialise abort then check if fname exists
c      
      abort = .true. 
      npar = 0    
      if (nx.lt.1) return
      inquire (file = fname, exist = there, iostat = ios) 
      if (.not.there .or. ios.ne.0) return 
c
c connect fname to unit = nout
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif  
c
c allocate workspace
c        
      ierr = 0
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      allocate (w(3*nx), stat = ierr)
      if (ierr.ne.0) return
c
c locate the values if possible
c        
      j = 0      
      ok = .true. 
      do while (ok .and. ios.eq.0)  
         read (nout,'(a)',iostat=ios) line 
         if (ios.eq.0) then
            k = index(line,cipher)
         else   
            ok = .false.
         endif   
         if (ok .and. k.gt.0) then 
c
c the cipher begin{limits} has been encountered so try to read successive limits 
c           
            i = 0
            j1 = -2
            j2 = -1
            j3 = 0
            do while (ok .and. i.lt.nx)
               read (nout,'(a)',iostat=ios) line
               k = index(line,ender)
               if (k.le.0) then 
c
c the ender end{limits} has not yet been encountered so try to read next set of limits
c                 
                  i = i + 1  
                  j1 = j1 + 3
                  j2 = j2 + 3
                  j3 = j3 + 3
                  read(line,*,iostat=ios) w(j1), w(j2), w(j3)
                  if (ios.eq.0) then
                     if (w(j1).le.w(j2) .and. w(j2).le.w(j3)) then
                        j = j + 1
                        ok = .true.
                     else
                        ok = .false.
                     endif       
                  else
                     ok = .false.
                  endif 
               else
c
c the ender has been encountered so stop
c                 
                  ok = .false.
               endif
            enddo   
         endif
      enddo
      close (unit = nout)
      if (j.gt.0) then
c
c limits have been read so set npar = j > 0 and abort = .false. 
c      
       
         abort = .false.
         npar = j 
         k = 0     
         do i = 1, npar 
            k = k + 1
            pbot(i) = w(k)
            k = k + 1
            pmid(i) = w(k)
            k = k + 1
            ptop(i) = w(k)
         enddo
      endif  
c
c finally deallocate the work space
c      
      deallocate (w, stat = ierr)
      end
c
c      
      