c
c
      subroutine eofint (isx, nisx,
     +                   fname,
     +                   abort, allpos)
c
c action: attempt to retrieve nisx integers from end of the file supplied
c author: w.g.bardsley, university of manchester, u.k., 20/10/2006
c         11/11/2006 added allpos to argument list to map -1 to 1
c
c Note: this returns abort = .false. and initialises isx only if nisx
c       integer values between -1 and 1 were read off the file. Otherwise
c       it returns abort = .true. and isx is not referenced.   
c       To succeed, the integers must be immediately after the token
c       'begin{indicators}'
c       but note that the file can be any arbitrary text file, and not
c       necessarily a simfit type data file. 
c
c    isx: (input/output) integers required from arbitrary text file
c         Note: returned overwritten only if nisx acceptable integers were found 
c   nisx: (input/unchanged) no. of integers required, nisx > 0
c  fname: (input/unchanged) arbitrary file
c  abort: (output) error indicator
c allpos: (input) map -1 to 1 if allpos = .true.
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: nisx  
      integer,             intent (inout) :: isx(nisx)
      character (len = *), intent (in)    :: fname  
      logical,             intent (in)    :: allpos 
      logical,             intent (out)   :: abort
c
c local allocatable array
c                        
      integer, allocatable :: itemp(:)
c
c locals
c       
      integer    i, ierr, ios, j, nout, ntemp   
      integer    jbot, jmid, jtop
      parameter (jbot = -1, jmid = 0, jtop = 1)
      logical    there          
      character  line*1024 
      character  cipher*17                    !this must not be changed
      parameter (cipher = 'begin{indicators}')!this must not be translated
      external   getnou  
c
c initialise abort then check nisx and see if fname exists
c      
      abort = .true.     
      if (nisx.lt.1) return
      inquire (file = fname, exist = there, iostat = ios) 
      if (.not.there .or. ios.ne.0) return 
c
c connect fname to unit = nout
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif  
c
c allocate integer workspace
c        
      ierr = 0
      if (allocated(itemp)) deallocate(itemp, stat = ierr)
      if (ierr.ne.0) return
      allocate (itemp(nisx), stat = ierr)
      if (ierr.ne.0) return
c
c locate the integers if possible
c                                
      ntemp = 0
      do while (ios.eq.0 .and.ntemp.lt.1)  
         read (nout,'(a)',iostat=ios) line
         if (index(line,cipher).gt.0) then
            read (nout,*,iostat=ios) (itemp(i), i = 1, nisx)
            if (ios.eq.0) then 
               do i = 1, nisx     
                  j = itemp(i)
                  if (j.ge.jbot .and. j.le.jtop) ntemp = ntemp + 1 
               enddo   
            endif
         endif
      enddo
      close (unit = nout)
c
c initialise isx if nisx values of -1, 0, or 1 have been read off the file
c      
      if (ntemp.eq.nisx) then
         do i = 1, nisx
            isx(i) = itemp(i)
         enddo  
         if (allpos) then
            do i = 1, nisx
               if (isx(i).lt.jmid) isx(i) = jtop
            enddo
         endif
         abort = .false.  
      endif   
      deallocate (itemp, stat = ierr)
      end
c
c      
      