C
C
      SUBROUTINE FNAMES (ISEND,
     +                   FNAME)
C
C ACTION : Announce the filename
C AUTHOR : W. G. Bardsley, 5/11/90, University of Manchester, U.K.
C          13/06/1993 No output if FNAMES = ' '
C          18/02/1994 DBOS version
C          10/02/1997 Win32 version
C          05/02/2001 introduced TRIM80
C          22/08/2005 added call to LENFIL 
C          25/02/2007 added INTENTS
C          12/11/2008 increased MINLIN from 10 to 12 to allow for Excel Macro reference in RESFIL
C          25/09/2015 suppressed the case with default results file f$result.txt
C
C          ISEND: (input/unchanged)
C          FNAME: (input/unchanged)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND
      CHARACTER (LEN = *), INTENT (IN) :: FNAME
C
C Locals
C
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 2)
      INTEGER    NUMBLD(NUMTXT)
      INTEGER    L, LENFIL, MINLIN
      PARAMETER (MINLIN = 12)
      CHARACTER (LEN = 100) TEXT(NUMTXT)
      CHARACTER (LEN = 80 ) TRIM80
      CHARACTER (LEN = 12 ) DEFOLT
      PARAMETER (DEFOLT = 'f$result.txt')
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    THERE, OP
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   PATCH1, TRIM80, LENFIL
      INTRINSIC  INDEX
      DATA       NUMBLD / 0, 1 /
C
C Check
C
      IF (ISEND.LT.1 .OR. ISEND.GT.2 .OR. FNAME.EQ.BLANK) RETURN
      INQUIRE (FILE = FNAME, EXIST = THERE, OPENED = OP)
      IF (THERE) THEN
         IF (ISEND.EQ.1) THEN
            TEXT(1) = 'Input data were contained in the file'
         ELSEIF (ISEND.EQ.2) THEN
            IF (OP) RETURN
            IF (INDEX(FNAME,DEFOLT).GT.0) RETURN  
            L = LENFIL (FNAME)
            IF (L.LE.MINLIN) RETURN
            TEXT(1) = 'Results have been written to the file'
         ENDIF
         TEXT(2) = TRIM80(FNAME)
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT,
     +                TEXT,
     +                BORDER)
      ENDIF
      END
C
C
