c
c
      character (len = 20) function form20 (x)
c
c action: write a double precision number to form20
c author: w.g.bardsley, university of manchester, u.k.
c         28/09/2010 developed from form15
c         08/10/2010 deleted move and replaced adjustr by adjustl
c 
c  nwide = field width (20 in form20)
c  nlast = field width - 4 
c          this allows for retaining e.g., e-12, or say -123, for the exponent
c          when checking to roll over terminal zeros in exponential notation
c  nstop = character number to stop checking from the right downwards for rolling over terminal zeros  
c          this makes sure there is at least one digit after the decimal point
c          in F notation and prevents unnecessary rolling over blanks in exponential notation
c nstart = character number that must be preserved up to from the left 
c          this also makes sure that there is at least one digit after the decimal point 
c          in exponential notation
c
      implicit none
c
c argument
c
      double precision, intent (in) :: x
c
c local
c
       
      integer    i, ios, ix, j, nstart, nstop
      integer    n0, nwide, nlast
      parameter (n0 = 0, nwide = 20, nlast = nwide - 4) 
      double precision absx, absy, y
      double precision huge, one, ten1, ten2, ten3, ten4, zero
      parameter (huge = 2147483647.0d+00,
     +           one = 1.0d+00,
     +           ten1 = 10.0d+00,
     +           ten2 = 100.0d+00,
     +           ten3 = 1000.0d+00,
     +           ten4 = 10000.0d+00,
     +           zero = 0.0d+00) 
      double precision xsmall, xvbig, xvsmall
      parameter (xsmall = 0.001d+00, xvbig = ten4, xvsmall = 1.0d-300)
      character (len = 20) dfolt, word20
      parameter (dfolt = '********************')
      character (len = 1) blank, nought
      parameter (blank = ' ', nought = '0')
      intrinsic  abs, dble, nint, adjustl
      
      form20 = dfolt
      absx = abs(x)

      if (abs(x).le.xvsmall) then
c
c Case 1: deal with zero as a special case
c =======
c        
         write (word20,'(i20)',iostat=ios) n0
         if (ios.eq.0) then
            form20 = adjustl(word20)
            return
         endif   
      endif            
      
      if (absx.le.huge .and. absx.ge.one) then
c
c Case 2: see if x is an integer ... if so use I formatting
c =======
c        
         ix = nint(x)
         y = dble(ix)
         absy = abs(y)
         if (abs(absx - absy).le.xvsmall) then
            write (word20,'(i20)',iostat=ios) ix
            if (ios.eq.0) then
               form20 = adjustl(word20)
               return
            endif   
         endif     
      endif
      
      if (absx.ge.xsmall .and. absx.le.xvbig) then
c
c Case 3: x is suitable for F formatting
c =======
c        
         ios = -1
         if (absx.lt.one) then
            write (word20,'(f20.15)',iostat=ios) x
            nstop = 6
         elseif (absx.lt.ten1) then
            write (word20,'(f20.14)',iostat=ios) x
            nstop = 7
         elseif (absx.lt.ten2) then   
            write (word20,'(f20.13)',iostat=ios) x
            nstop = 8
          elseif (absx.lt.ten3) then   
            write (word20,'(f20.12)',iostat=ios) x
            nstop = 9   
         else   
            write (word20,'(f20.11)',iostat=ios) x
            nstop = 10
         endif   
         if (ios.eq.0) then
c
c strip trailng zeros from F format then left justify
c           
            do i = nwide, nstop, -1
               if (word20(i:i).eq.nought) then
                  word20(i:i) = blank 
               else   
                  exit
               endif
            enddo
            form20 = adjustl(word20) 
            return
         endif   
      endif
c
c Case 4: use 1p,e20.14 or 1p,e20.13
c
      if (x.gt.zero) then
         write (word20,'(1p,e20.14)',iostat=ios) x
         nstart = 4
      else   
         write (word20,'(1p,e20.13)',iostat=ios) x
         nstart = 5
      endif   
      if (ios.eq.0) then
         nstop = nwide
         do i = nlast, nstart, -1
            if (word20(i:i).ne.nought) then
               exit
            else
               do j = i, nstop - 1
                  word20(j:j) = word20(j + 1:j + 1)
               enddo
               word20(nstop:nstop) = blank   
               nstop = nstop - 1
            endif     
         enddo 
         form20 = adjustl(word20)
      endif    
      end
c
c