

c Resolution of some long-standing Simfit display/input/output problems 

c bill.bardsley@manchester.ac.uk, 11/08/2011 

c 1) History of the Simfit get* routines
c    -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.

c
c
      subroutine getall (isend)
c      
c action: demonstrate the get routines            
c author: w.g.bardsley, university of manchester, u.k.
c         11/04/2009 completely new version as a subroutine
c

C Integers:
C ========
C GETI01   ...  1
C GETIGE   ...  2
C GETIGT   ...  3
C GETIL1   ...  4
C GETILE   ...  5
C GETILT   ...  6
C GETIM1   ...  7
C GETJ01   ...  8
C GETJGE   ...  9
C GETJLE   ... 10
C GETJM1   ... 11 (now the same as GETJL1)
C
C Reals:
C ======
C GETR01   ... 12
C GETR02   ... 13
C GETR03   ... 14
C GETRG2   ... 15
C GETRG3   ... 16
C GETRGE   ... 17
C GETRGT   ... 18
C GETRL1   ... 19
C GETRL2   ... 20
C GETRLE   ... 21
C GETRLT   ... 22
C GETRM1   ... 23
C GETD01   ... 24
C GETD02   ... 25
C GETD03   ... 26
C GETDGE   ... 27
C GETDLE   ... 28
C GETDG2   ... 29
C GETDG3   ... 30
C GETDL2   ... 31
C GETDM1   ... 32
C
C Text:
C =====
C GETTXT   ... 33
C GETSTR   ... 34
C
C Logicals:
C ========
C GETL01   ... 35
C

      implicit none
c
c argument
c      
      integer, intent (in) :: isend
c
c locals
c      
      integer  i, ilim, jlim
      double precision epsi, w, x, y, z
      character query*80, strng*80
      logical   yesno
      external geti01, getige, getigt, getil1, getile, getilt,
     +         getim1, getj01, getjge, getjle, getjm1,
     +         getr01, getr02, getr03, getrg2, getrg3,
     +         getrge, getrgt, getrl1, getrl2, getrle, getrlt, getrm1,
     +         getd01, getd02, getd03, getdge, getdle, getdg2, getdg3,
     +         getdl2, getdm1,
     +         gettxt, getstr,
     +         getl01
      
      if (isend.eq.1) then
         call geti01 (i, 'any integer at all with no commas etc.')
         write (*,100) i
      elseif (isend.eq.2) then
         ilim = 5
         call getige (i, ilim, 'any integer >= 5')
         write (*,100) i   
      elseif (isend.eq.3) then
         ilim = 5
         call getigt (i, ilim, 'any integer > 5')
         write (*,100) i   
      elseif (isend.eq.4) then
         ilim = -5
         jlim = 5
         call getil1 (ilim, i, jlim, 'any integer in range -5, 5')
         write (*,100) i 
      elseif (isend.eq.5) then
         ilim = 10
         call getile (i, ilim, 'any integer =< 10')
         write (*,100) i  
      elseif (isend.eq.6) then
         ilim = 10
         call getilt (i, ilim, 'any integer < 10')
         write (*,100) i  
      elseif (isend.eq.7) then
         ilim = -10
         jlim = 10
         call getim1 (ilim, i, jlim, 'any integer in range -10, 10')
         write (*,100) i
      elseif (isend.eq.8) then
         i = 1
         call getj01 (i, 'any integer')
         write (*,100) i 
      elseif (isend.eq.9) then
         i = 1
         ilim = 0
         call getjge (i, ilim, 'any integer >= 0')
         write (*,100) i 
      elseif (isend.eq.10) then
         i = 1
         ilim = 10
         call getjle (i, ilim, 'any integer =< 10')
         write (*,100) i 
      elseif (isend.eq.11) then
         i = 1
         ilim = 0
         jlim = 10
         call getjm1 (ilim, i, jlim, 'any integer in range')
         write (*,100) i  
      elseif (isend.eq.12) then
         call getr01 (x, 'any real number')
         write (*,200) x  
      elseif (isend.eq.13) then
         call getr02 (x, y, 'any real numbers')
         write (*,300) x, y  
      elseif (isend.eq.14) then
         call getr03 (x, y, z, 'any real numbers')
         write (*,400) x, y, z   
      elseif (isend.eq.15) then
         call getrg2 (x, y, 'any real numbers X =< Y')
         write (*,300) x, y 
      elseif (isend.eq.16) then
         call getrg3 (x, y, z, 'any real numbers X =< Y =< Z')
         write (*,400) x, y, z 
      elseif (isend.eq.17) then
         y = 0.0d+00 
         call getrge (x, y, 'any real number X >= 0')
         write (*,200) x 
      elseif (isend.eq.18) then
         y = 0.0d+00 
         call getrgt (x, y, 'any real number X > 0')
         write (*,200) x  
      elseif (isend.eq.19) then
         x = -10.0d+00
         z = 10.0d+00 
         call getrl1 (x, y, z, 'any real number -10 =< x =< 10')
         write (*,200) y 
      elseif (isend.eq.20) then
         epsi = 1.0d-06
         w = -10.0d+00
         z = 10.0d+00 
         call getrl2 (epsi, w, x, y, z, '2 numbers -10 =< x =< y =< 10')
         write (*,300) x, y  
      elseif (isend.eq.21) then
         y = 0.0d+00
         call getrle (x, y, 'any number x =< 0')
         write (*,200) x  
      elseif (isend.eq.22) then
         y = 0.0d+00
         call getrlt (x, y, 'any number x < 0')
         write (*,200) x
      elseif (isend.eq.23) then
         x = -10.0d+00
         z = 10.0d+00
         call getrm1 (x, y, z, 'any number -10 =< x < 10')
         write (*,200) y                                                                                                                                                    
      elseif (isend.eq.24) then
         x = 1.2345678D+20
         call getd01 (x, 'any real number X')
         write (*,200) x
      elseif (isend.eq.25) then
         x = 1.2345678d+20
         y = 17.0d+00
         call getd02 (x, y, 'any real numbers X, Y')
         write (*,300) x, y   
       elseif (isend.eq.26) then
         x = 1.2345678d+20
         y = 17.0d+00
         Z = -23.456d-20
         call getd03 (x, y, z, 'any real numbers X, Y, Z')
         write (*,400) x, y, z            
      elseif (isend.eq.27) then
         x = 25.0d+00
         y = 17.0d+00
         call getdge (x, y, 'any limited real number X')
         write (*,200) x  
      elseif (isend.eq.28) then
         x = -11.0d+00
         y = 17.0d+00
         call getdle (x, y, 'any limited real number X')
         write (*,200) x
      elseif (isend.eq.29) then
         x = -11.0d+00
         y = 17.0d+00
         call getdg2 (x, y, 'any real numbers X =< Y')
         write (*,300) x, y 
      elseif (isend.eq.30) then
         x = -11.0d+00
         y = 17.0d+00
         z = 30.0d+00
         call getdg3 (x, y, z, 'any real number X =< Y =< Z')
         write (*,400) x, y, z 
      elseif (isend.eq.31) then
         epsi = 1.0d-06
         w = -10.0d+00
         x = 1.0d+00
         y = 3.0d+00
         z = 10.0d+00 
         call getdl2 (epsi, w, x, y, z, '2 numbers -10 =< x =< y =< 10')
         write (*,300) x, y 
      elseif (isend.eq.32) then
         x = -11.0d+00
         y = 17.0d+00
         z = 30.0d+00
         call getdm1 (x, y, z, 'any real number -11 =< X =< 30')
         write (*,200) y 
      elseif (isend.eq.33) then
         query = 'any string'
         call gettxt (query, strng)
         write (*,500) strng 
      elseif (isend.eq.34) then
         query = 'any string'
         strng = 'default string'
         call getstr (query, strng)
         write (*,500) strng
      elseif (isend.eq.35) then
         query = 'answer yes or no'
         yesno = .true.
         call getl01 (query, yesno)
         if (yesno) then
            write (*,500) 'yes'                                             
         else   
            write (*,500) 'no'                                             
         endif   
      endif   
  100 format (i12)      
  200 format (1p,e12.4)
  300 format (1p,e12.4,',',2x,e12.4)
  400 format (1p,e12.4,',',2x,e12.4,',',2x,e12.4)
  500 format (a)
      end