

c Resolution of some long-standing Simfit display/input/output problems 

c bill.bardsley@manchester.ac.uk, 11/08/2011 

c 1) History of the Simfit get* routines
c    -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.

C ... Get doubles with no display
C W95_GETRGE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETRLE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETRLT (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETRGE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETRGE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETRL1 (ICOLOR, IY, XBOT, XMID, XTOP, STRNG)
C W95_GETRL2 (ICOLOR, IY, EPSI, XBOT, XSTART, XSTOP, XTOP, STRNG)
C W95_GETRM1 (ICOLOR, IY, XBOT, XMID, XTOP, STRNG) ... also prints limits
C W95_GETRG2 (ICOLOR, IY, X, Y, STRNG)
C W95_GETRG3 (ICOLOR, IY, X, Y, Z, STRNG)
C W95_GETR01 (ICOLOR, IY, X, STRNG)
C W95_GETR02 (ICOLOR, IY, X, Y, STRNG)
C W95_GETR03 (ICOLOR, IY, X, Y, Z, STRNG)
C
C ... Get doubles with display
C W95_GETD01 (ICOLOR, IY, X, STRNG)
C W95_GETD02 (ICOLOR, IY, X, Y, STRNG)
C W95_GETD03 (ICOLOR, IY, X, Y, Z, STRNG)
C W95_GETDGT (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETDGE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETDLT (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETDLE (ICOLOR, IY, X, XLIM, STRNG)
C W95_GETDG2 (ICOLOR, IY, X, Y, STRNG)
C W95_GETDL1 (ICOLOR, IY, XBOT, XMID, XTOP, STRNG)
C W95_GETDM1 (ICOLOR, IY, XBOT, XMID, XTOP, STRNG) ... also prints limits
C
C ================= DOUBLES WITH NO DISPLAY ====================
C
      SUBROUTINE W95_GETRGE (ICOLOR, IY, 
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XLIM_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      LINE = FORM25(XLIM)
      CALL TRIML1 (LINE)
      WRITE (TEXT(3),100) LINE
      LINE = BLANK
      X = XLIM
      XLIM_1 = XLIM
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XLIM_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.LT.XLIM_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRGT (ICOLOR, IY, 
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XLIM_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1
      SAVE       ICOUNT, XLIM_1
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE = BLANK
      XLIM_1 = XLIM
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XLIM + 1.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X, 
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.LE.XLIM_1) GOTO 20
      END
C
C----------------------------------------------------------------------
C      
      SUBROUTINE W95_GETRLE (ICOLOR, IY, 
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XLIM_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      LINE = FORM25(XLIM)
      CALL TRIML1 (LINE)
      WRITE (TEXT(3),100) LINE
      LINE = BLANK
      X = XLIM
      XLIM_1 = XLIM
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XLIM_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GT.XLIM_1) GOTO 20
  100 FORMAT ('Maximum =',1X,A)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRLT (ICOLOR, IY, 
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XLIM_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1
      SAVE       ICOUNT, XLIM_1
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE = BLANK
      XLIM_1 = XLIM
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XLIM - 1.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X, 
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GE.XLIM_1) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRL1 (ICOLOR, IY,
     +                       XBOT, XMID, XTOP, 
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited real number
C 14/04/2009 added INTENTS and now calls GETRM1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (OUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      EXTERNAL W95_GETRM1
      CALL W95_GETRM1 (ICOLOR, IY,
     +                 XBOT, XMID, XTOP,
     +                 STRNG)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRM1 (ICOLOR, IY,
     +                       XBOT, XMID, XTOP,
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited real, but declare the limits
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (OUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      INTEGER    K, X_LEN200
      DOUBLE PRECISION XBOT_1, XTOP_1
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      CHARACTER  LINE(2)*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, X_LEN200, FORM25,
     +           TRIML1
      EXTERNAL   X_PUTFAT
      SAVE       ICOUNT, XBOT_1, XTOP_1
C
C First check the limits
C
      IF (XBOT.GE.XTOP) THEN
         CALL X_PUTFAT (
     +'Serious Programming Error ... XBOT.GE.XTOP in call to GETRM1')
         XMID = (XBOT + XTOP)/TWO
         RETURN
      ENDIF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      LINE(1) = FORM25(XBOT)
      LINE(2) = FORM25(XTOP)
      CALL TRIML1 (LINE(1))
      CALL TRIML1 (LINE(2))
      K = X_LEN200(LINE(1))
      WRITE (TEXT(3),100) LINE(1)(1:K), LINE(2)
      ICOUNT = 0
      LINE(1) = BLANK
      LINE(2) = BLANK
      XBOT_1 = XBOT
      XTOP_1 = XTOP
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         XMID = XBOT_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE(1), TEXT)
      CALL W95_TXT2R1 (XMID,
     +                 LINE(1),
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (XMID.LT.XBOT_1 .OR. XMID.GT.XTOP_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRG2 (ICOLOR, IY,
     +                       X, Y,
     +                       STRNG)
C
C Use W95_GETTXT to read two reals X =< Y
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 2)
      INTEGER    ICOUNT
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, DETAIL*40, STUB*7
      PARAMETER (BLANK = ' ', 
     +           DETAIL = 'Must have value 1 =< value 2',
     +           STUB = 'INPUT: ') 
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      TEXT(3) = DETAIL
      ICOUNT = 0
      LINE1 = BLANK
      LINE2 = BLANK
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = 1.0D+00
         Y = 2.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT, 
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y, 
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20  
      IF (X.GT.Y) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRL2 (ICOLOR, IY, 
     +                       EPSI, XBOT, XSTART, XSTOP, XTOP,
     +                       STRNG)
C
C Use W95_GETTX2 to read two reals
C XBOT =< XSTART + EPSI =< XSTOP =< XTOP
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    ICOLOR, IY
      DOUBLE PRECISION EPSI, XBOT, XSTART, XSTOP, XTOP
      CHARACTER  STRNG*(*)
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 2)
      INTEGER    ICOUNT
      DOUBLE PRECISION EPSI_1, XBOT_1, XTOP_1
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', 
     +           STUB = 'INPUT: ') 
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1, X_PUTFAT
      IF (EPSI.LT.ZERO) THEN
         CALL X_PUTFAT (
     +'Serious programming error: EPSI < 0 in call to GETRL2')
         RETURN
      ENDIF
      IF (XBOT.GT.XTOP) THEN
         CALL X_PUTFAT (
     +'Serious programming error: XBOT > XTOP in call to GETRL2')  
         RETURN
      ENDIF            
      IF (XBOT + EPSI.GT.XTOP) THEN
         CALL X_PUTFAT (
     +'Serious programming error: XBOT + EPSI > XTOP in call to GETRL2')    
         RETURN
      ENDIF   
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE1 = BLANK
      LINE2 = BLANK
      XSTART = XBOT
      XSTOP = XTOP
      XBOT_1 = XBOT
      XTOP_1 = XTOP
      EPSI_1 = EPSI
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         XSTART = XBOT_1
         XSTOP = XTOP_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (XSTART,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (XSTOP,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20  
      IF (XBOT_1.GT.XSTART .OR. (XSTART + EPSI_1).GT.XSTOP .OR.
     +    XSTOP.GT.XTOP_1) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETRG3 (ICOLOR, IY,
     +                       X, Y, Z,
     +                       STRNG)
C
C Use W95_GETTXT to read three reals X =< Y =< Z
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 3)
      INTEGER    ICOUNT
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), LINE3*(NLINE), 
     +           TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, DETAIL*40, STUB*7
      PARAMETER (BLANK = ' ', 
     +           DETAIL = 'Must have value 1 =< value 2 =< value 3',
     +           STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX3, W95_TXT2R1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      TEXT(3) = DETAIL
      ICOUNT = 0
      LINE1 = BLANK
      LINE2 = BLANK
      LINE3 = BLANK
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = 1.0D+00
         Y = 2.0D+00
         Z = 3.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX3 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, LINE3, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Z,
     +                 LINE3,
     +                 ABORT)
      IF (ABORT) GOTO 20   
      IF (X.GT.Y .OR. Y.GT.Z) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETR01 (ICOLOR, IY,
     +                       X,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read an unlimited real number
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE = BLANK
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = 1.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETR02 (ICOLOR, IY, X, Y, STRNG)
C
C Use W95_GETTX2 to read two unlimited reals
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    ICOLOR, IY
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 2)
      INTEGER    ICOUNT
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE1 = BLANK
      LINE2 = BLANK
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = 1.0D+00
         Y = 2.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20  
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETR03 (ICOLOR, IY,
     +                       X, Y, Z,
     +                       STRNG)
C
C Use W95_GETTX3 to read three unlimited reals
C 14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 3)
      INTEGER    ICOUNT
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), LINE3*(NLINE), 
     +           TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX3, W95_TXT2R1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      LINE1 = BLANK
      LINE2 = BLANK
      LINE3 = BLANK
   20 CONTINUE
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = 1.0D+00
         Y = 2.0D+00
         Z = 3.0D+00
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX3 (ICOLOR, IY, NUMTXT, 
     +                 LINE1, LINE2, LINE3,
     +                 TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Z,
     +                 LINE3,
     +                 ABORT)
      IF (ABORT) GOTO 20        
      END
C
C ================= DOUBLES WITH DISPLAY ==================================
C
      SUBROUTINE W95_GETD01 (ICOLOR, IY,
     +                       X,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read an unlimited real number
C Show X as the default
C 14/04/2009 added INTENTS
C 30/07/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      XDEF = X
      LINE_SAV = FORM25(XDEF)
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETD02 (ICOLOR, IY,
     +                       X, Y,
     +                       STRNG)
C
C Use W95_GETTX2 to read two reals X, Y
C 14/04/2009 added INTENTS 
C 30/07/2010 re-initilised using WORDX or WORDY on failure
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 2)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, YDEF
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORDX*25, WORDY*25
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, YDEF
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      XDEF = X
      YDEF = Y
      WORDX = FORM25(XDEF)
      WORDY = FORM25(YDEF)
      CALL TRIML1 (WORDX)
      CALL TRIML1 (WORDY)
   20 CONTINUE
      LINE1 = WORDX
      LINE2 = WORDY 
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         Y = YDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT, 
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1, ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2, ABORT)
      IF (ABORT) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETD03 (ICOLOR, IY,
     +                       X, Y, Z,
     +                       STRNG)
C
C Use W95_GETTX3 to read three reals X, Y, Z
C 14/04/2009 added INTENTS
C 30/07/2010 re-initilised using WORDX, WORDY, or WORDZ on failure
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 3)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, YDEF, ZDEF
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), LINE3*(NLINE),
     +           TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORDX*25, WORDY*25, WORDZ*25
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX3, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, YDEF
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      XDEF = X
      YDEF = Y
      ZDEF = Z
      WORDX = FORM25(XDEF)  
      WORDY = FORM25(YDEF)  
      WORDZ = FORM25(ZDEF)
      CALL TRIML1 (WORDX)
      CALL TRIML1 (WORDY)
      CALL TRIML1 (WORDZ)
   20 CONTINUE
      LINE1 = WORDX  
      LINE2 = WORDY  
      LINE3 = WORDZ  
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         Y = YDEF
         Z = ZDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX3 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, LINE3, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Z,
     +                 LINE3,
     +                 ABORT)
      IF (ABORT) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDGT (ICOLOR, IY,
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C Show X as the default
C 18/01/2010 developed from W95_GETDGE
C 30/07/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION, INTENT (IN)    :: XLIM
      DOUBLE PRECISION, INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN) :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, XLIM_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORD25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      IF (X.LT.XLIM) X = XLIM
      WORD25 = FORM25(XLIM)
      CALL TRIML1 (WORD25)
      WRITE (TEXT(3),100) WORD25
      ICOUNT = 0
      XDEF = X
      XLIM_1 = XLIM
      LINE_SAV = FORM25(XDEF)
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT, 
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.LE.XLIM_1) GOTO 20
  100 FORMAT ('Minimum >',1X,A)        
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDGE (ICOLOR, IY,
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C Show X as the default
C 14/04/2009 added INTENTS
C 30/07/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION, INTENT (IN)    :: XLIM
      DOUBLE PRECISION, INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN) :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, XLIM_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORD25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      IF (X.LT.XLIM) X = XLIM
      WORD25 = FORM25(XLIM)
      CALL TRIML1 (WORD25)
      WRITE (TEXT(3),100) WORD25
      ICOUNT = 0
      XDEF = X
      XLIM_1 = XLIM
      LINE_SAV = FORM25(XDEF)
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT, 
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.LT.XLIM_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDLT (ICOLOR, IY,
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C Show X as the default
C 18/01/2010 developed from W95_GETDLE
C 30/07/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, XLIM_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORD25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      IF (X.GT.XLIM) X = XLIM
      WORD25 = FORM25(XLIM)
      CALL TRIML1 (WORD25)
      WRITE (TEXT(3),100) WORD25  
      XDEF = X
      XLIM_1 = XLIM
      LINE_SAV = FORM25(XDEF)
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GE.XLIM_1) GOTO 20
  100 FORMAT ('Maximum <',1X,A)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDLE (ICOLOR, IY,
     +                       X, XLIM,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2R1 to read a limited real number
C Show X as the default
C 14/04/2009 added INTENTS
C 30/07/2010 added LINE_SAV 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, XLIM_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORD25*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, XLIM_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      IF (X.GT.XLIM) X = XLIM
      WORD25 = FORM25(XLIM)
      CALL TRIML1 (WORD25)
      WRITE (TEXT(3),100) WORD25  
      XDEF = X
      XLIM_1 = XLIM
      LINE_SAV = FORM25(XDEF)
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GT.XLIM_1) GOTO 20
  100 FORMAT ('Maximum =',1X,A)        
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDG2 (ICOLOR, IY,
     +                       X, Y,
     +                       STRNG)
C
C Use W95_GETTX2 to read two reals X =< Y
C 14/04/2009 added INTENTS
C 30/07/2010 used WORDX and WORDY to restore defaults
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 2)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, YDEF
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORDX*25, WORDY*25
      CHARACTER  BLANK*1, DETAIL*40, STUB*7
      PARAMETER (BLANK = ' ', 
     +           DETAIL = 'Must have value 1 =< value 2',
     +           STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, YDEF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      TEXT(3) = DETAIL
      ICOUNT = 0
      IF (X.GT.Y) X = Y
      XDEF = X
      YDEF = Y
      WORDX = FORM25(XDEF)  
      WORDY = FORM25(YDEF)
      CALL TRIML1 (WORDX)
      CALL TRIML1 (WORDY)
   20 CONTINUE
      LINE1 = WORDX
      LINE2 = WORDY
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         Y = YDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GT.Y) GOTO 20  
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDG3 (ICOLOR, IY,
     +                       X, Y, Z,
     +                       STRNG)
C
C Use W95_GETTX3 to read THREE reals X =< Y =< Z
C 14/04/2009 added INTENTS
C 30/07/2010 use WORDX, WORDY, and WORDZ to store defaults
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 3)
      INTEGER    ICOUNT
      DOUBLE PRECISION XDEF, YDEF, ZDEF
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), LINE3*(NLINE), 
     +           TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORDX*25, WORDY*25, WORDZ*25
      CHARACTER  BLANK*1, DETAIL*40, STUB*7
      PARAMETER (BLANK = ' ', 
     +           DETAIL = 'Must have value 1 =< value 2 =< value 3',
     +           STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX3, W95_TXT2R1, FORM25, TRIML1
      SAVE       ICOUNT, XDEF, YDEF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      TEXT(3) = DETAIL
      ICOUNT = 0
      IF (X.GT.Y) X = Y
      IF (Y.GT.Z) Z = Y  
      XDEF = X
      YDEF = Y
      ZDEF = Z
      WORDX = FORM25(XDEF)  
      WORDY = FORM25(YDEF)
      WORDZ = FORM25(ZDEF)
      CALL TRIML1 (WORDX)
      CALL TRIML1 (WORDY)
      CALL TRIML1 (WORDZ)
   20 CONTINUE
      LINE1 = WORDX
      LINE2 = WORDY
      LINE3 = WORDZ
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         X = XDEF
         Y = YDEF
         Z = ZDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX3 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, LINE3, TEXT)
      CALL W95_TXT2R1 (X,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (Y,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (X.GT.Y) GOTO 20  
      CALL W95_TXT2R1 (Z,
     +                 LINE3,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (Y.GT.Z) GOTO 20  
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDL1 (ICOLOR, IY,
     +                       XBOT, XMID, XTOP,
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited real number
C 14/04/2009 added INTENTS and transferred to GETDM1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C     
      EXTERNAL W95_GETDM1 
      CALL W95_GETDM1 (ICOLOR, IY,
     +                 XBOT, XMID, XTOP,
     +                 STRNG)     
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDL2 (ICOLOR, IY,
     +                       EPSI, XBOT, XSTART, XSTOP, XTOP,
     +                       STRNG)
C
C Use W95_GETTX2 to read two reals
C XBOT =< XSTART + EPSI =< XSTOP =< XTOP
C 14/04/2009 added INTENTS
C 30/07/2010 use WORDX and WORDY to store defaults
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)    :: EPSI, XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XSTART, XSTOP
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 1, NUMBER = 2)
      INTEGER    ICOUNT
      DOUBLE PRECISION EPSI_1, XBOT_1, XTOP_1
      DOUBLE PRECISION XSTART_1, XSTOP_1
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINE1*(NLINE), LINE2*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WORDX*25, WORDY*25
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX2, W95_TXT2R1, FORM25, TRIML1
      EXTERNAL   X_PUTFAT
      IF (EPSI.LT.ZERO) THEN
         CALL X_PUTFAT (
     +'Serious programming error: EPSI < 0 in call to W95_GETDL2')
         RETURN
      ENDIF
      IF (XBOT.GT.XTOP) THEN
         CALL X_PUTFAT (
     +'Serious programming error: XBOT > XTOP in call to W95_GETDL2')  
         RETURN
      ENDIF            
      IF (XBOT + EPSI.GT.XTOP) THEN
         CALL X_PUTFAT (
     +'Serious programming error: XBOT+EPSI>XTOP in call to W95_GETDL2')    
         RETURN
      ENDIF   
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      IF (XSTART.LT.XBOT) XSTART = XBOT
      IF (XSTOP.GT.XTOP) XSTOP = XTOP 
      XBOT_1 = XBOT
      XTOP_1 = XTOP
      EPSI_1 = EPSI
      XSTART_1 = XSTART
      XSTOP_1 = XSTOP
      WORDX = FORM25(XSTART_1)
      WORDY = FORM25(XSTOP_1)
      CALL TRIML1 (WORDX)  
      CALL TRIML1 (WORDY)
   20 CONTINUE
      LINE1 = WORDX  
      LINE2 = WORDY  
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         XSTART = XBOT_1
         XSTOP = XTOP_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX2 (ICOLOR, IY, NUMTXT,
     +                 LINE1, LINE2, TEXT)
      CALL W95_TXT2R1 (XSTART,
     +                 LINE1,
     +                 ABORT)
      IF (ABORT) GOTO 20
      CALL W95_TXT2R1 (XSTOP,
     +                 LINE2,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (XBOT_1.GT.XSTART .OR. (XSTART + EPSI_1).GT.XSTOP .OR.
     +    XSTOP.GT.XTOP_1) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETDM1 (ICOLOR, IY,
     +                       XBOT, XMID, XTOP, 
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited real, but declare the limits
C Show XMID as the default
C 14/04/2009 added INTENTS
C 30/07/2010 used LINE_SAV to store default
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 25, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, K, X_LEN200
      DOUBLE PRECISION XBOT_1, XMID_1, XTOP_1
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  FORM25*25, WBOT*25, WTOP*25
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2R1, FORM25,
     +           TRIML1, X_LEN200
      EXTERNAL   X_PUTFAT
      SAVE       ICOUNT, XBOT_1, XMID_1, XTOP_1
C
C First check the limits
C
      IF (XBOT.GE.XTOP) THEN
         CALL X_PUTFAT (
     +  'Serious Programming Error: XBOT.GE.XTOP in call to W95_GETDM1')
         RETURN
      ENDIF
C
C Now check XMID supplied and adjust if required
C      
      IF (XMID.LT.XBOT .OR. XMID.GT.XTOP) XMID = (XBOT + XTOP)/TWO
C
C Build up the control
C        
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WBOT = FORM25(XBOT)
      WTOP = FORM25(XTOP)
      CALL TRIML1(WBOT)
      CALL TRIML1(WTOP)
      K = X_LEN200(WBOT)
      WRITE (TEXT(3),100) WBOT(1:K), WTOP
      ICOUNT = 0
      XBOT_1 = XBOT
      XMID_1 = XMID
      XTOP_1 = XTOP
      LINE_SAV = FORM25(XMID_1) 
      CALL TRIML1 (LINE_SAV) 
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         XMID = XMID_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2R1 (XMID,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (XMID.LT.XBOT_1 .OR. XMID.GT.XTOP_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)
      END
C
C
