C
C

c Resolution of some long-standing Simfit display/input/output problems 

c bill.bardsley@manchester.ac.uk, 11/08/2011 

c 1) History of the Simfit get* routines
c    -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.


C
C ... Get integers with no display
C W95_GETIGE (ICOLOR, IY, J, LIMIT, STRNG)
C W95_GETIGT (ICOLOR, IY, J, LIMIT, STRNG)
C W95_GETILE (ICOLOR, IY, J, LIMIT, STRNG)
C W95_GETILT (ICOLOR, IY, J, LIMIT, STRNG)
C W95_GETIL1 (ICOLOR, IY, JBOT, JMID, JTOP, STRNG)
C W95_GETIM1 (ICOLOR, IY, JBOT, JMID, JTOP, STRNG) ... also prints limits
C W95_GETI01 (ICOLOR, IY, J, STRNG)
C
C ... Get integers with display
C W95_GETJGE (ICOLOR, IY, J, LIMIT, STRNG)
C W95_GETJ01 (ICOLOR, IY, J, STRNG)
C W95_GETJL1 (ICOLOR, IY, JBOT, JMID, JTOP, STRNG)
C W95_GETJM1 (ICOLOR, IY, JBOT, JMID, JTOP, STRNG) ... also prints limits
C
C ================= INTEGERS WITH NO DISPLAY ===================
C
      SUBROUTINE W95_GETIGE (ICOLOR, IY, J, LIMIT, 
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (OUT) :: J
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, LIMIT_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128, WORD12*12
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (WORD12,'(I12)') LIMIT
      CALL TRIML1 (WORD12)
      WRITE (TEXT(3),100) WORD12
      ICOUNT = 0
      J = LIMIT
      LIMIT_1 = LIMIT
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = LIMIT_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.LT.LIMIT_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETIGT (ICOLOR, IY, J, LIMIT,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (OUT) :: J
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, LIMIT_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128, WORD12*12
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (WORD12,'(I12)') LIMIT + 1
      CALL TRIML1 (WORD12)
      WRITE (TEXT(3),100) WORD12
      ICOUNT = 0
      J = LIMIT + 1
      LIMIT_1 = LIMIT
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = LIMIT_1 + 1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.LE.LIMIT_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETILE (ICOLOR, IY, J, LIMIT,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (OUT) :: J
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, LIMIT_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128, WORD12*12
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (WORD12,'(I12)') LIMIT
      CALL TRIML1 (WORD12)
      WRITE (TEXT(3),100) WORD12
      ICOUNT = 0
      J = LIMIT
      LIMIT_1 = LIMIT
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = LIMIT_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.GT.LIMIT_1) GOTO 20
  100 FORMAT ('Maximum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETILT (ICOLOR, IY, J, LIMIT,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (OUT) :: J
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, LIMIT_1
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128, WORD12*12
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (WORD12,'(I12)') LIMIT - 1
      CALL TRIML1 (WORD12)
      WRITE (TEXT(3),100) WORD12
      ICOUNT = 0
      J = LIMIT - 1
      LIMIT_1 = LIMIT
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = LIMIT - 1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT, 
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.GE.LIMIT_1) GOTO 20
  100 FORMAT ('Maximum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETIL1 (ICOLOR, IY, JBOT, JMID, JTOP,
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited integer.
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, JBOT, JTOP
      INTEGER,             INTENT (OUT) :: JMID
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JBOT_1, JTOP_1
      INTEGER    K, X_LEN200
      CHARACTER  LINE*(NLINE), LINE1*(NLINE), LINE2*(NLINE),
     +           TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      EXTERNAL   X_PUTFAT, X_LEN200
      SAVE       ICOUNT, JBOT_1, JTOP_1
C
C First check that limits make sense
C
      IF (JBOT.GE.JTOP) THEN
         CALL X_PUTFAT (
     +  'Serious Programming Error ... JBOT.GE.JTOP in call to GETIL1')
         JMID = (JBOT + JTOP)/2
         RETURN
      ENDIF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (LINE1,100) JBOT
      WRITE (LINE2,100) JTOP
      CALL TRIML1 (LINE1)
      CALL TRIML1 (LINE2)
      K = X_LEN200(LINE1)
      WRITE (TEXT(3),200) LINE1(1:K), LINE2 
      ICOUNT = 0
      JMID = JBOT
      JBOT_1 = JBOT
      JTOP_1 = JTOP
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         JMID = JBOT_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (JMID,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (JMID.LT.JBOT_1 .OR. JMID.GT.JTOP_1) GOTO 20
  100 FORMAT (I11)      
  200 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETIM1 (ICOLOR, IY, JBOT, JMID, JTOP,
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited integer, but declare the limits
C 10/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY, JBOT, JTOP
      INTEGER,             INTENT (OUT) :: JMID
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JBOT_1, JTOP_1
      INTEGER    K, X_LEN200
      CHARACTER  LINE*(NLINE), LINE1*(NLINE), LINE2*(NLINE),
     +           TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1
      EXTERNAL   X_PUTFAT, X_LEN200
      EXTERNAL   TRIML1
      SAVE       ICOUNT, JBOT_1, JTOP_1
C
C First check that limits make sense
C
      IF (JBOT.GE.JTOP) THEN
         CALL X_PUTFAT (
     +  'Serious Programming Error ... JBOT.GE.JTOP in call to GETIM1')
         JMID = (JBOT + JTOP)/2
         RETURN
      ENDIF
C
C Carry on with preliminary definitions
C
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (LINE1,100) JBOT
      WRITE (LINE2,100) JTOP
      CALL TRIML1 (LINE1)
      CALL TRIML1 (LINE2)
      K = X_LEN200(LINE1)
      WRITE (TEXT(3),200) LINE1(1:K), LINE2
      ICOUNT = 0
      JMID = JBOT
      JBOT_1 = JBOT
      JTOP_1 = JTOP
C
C Attempt to read JMID
C
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         JMID = (JBOT_1 + JTOP_1)/2
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (JMID,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (JMID.LT.JBOT_1 .OR. JMID.GT.JTOP_1) GOTO 20
  100 FORMAT (I11)
  200 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETI01 (ICOLOR, IY, J,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read an unlimited integer
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: ICOLOR, IY
      INTEGER,             INTENT (OUT) :: J
      CHARACTER (LEN = *), INTENT (IN)  :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT
      CHARACTER  LINE*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1
      SAVE       ICOUNT
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
   20 CONTINUE
      LINE = BLANK
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = 1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      END
C
C ================= INTEGERS WITH DISPLAY ======================
C
      SUBROUTINE W95_GETJGE (ICOLOR, IY, J, LIMIT,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C 10/08/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (INOUT) :: J
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JDEF, LIMIT_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1, JDEF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      IF (J.LT.LIMIT) J = LIMIT
      WRITE (LINE,'(I11)') LIMIT
      CALL TRIML1 (LINE)  
      WRITE (TEXT(3),100) LINE
      JDEF = J
      LIMIT_1 = LIMIT
      WRITE (LINE_SAV,'(I11)') JDEF
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = JDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.LT.LIMIT_1) GOTO 20
  100 FORMAT ('Minimum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      
      SUBROUTINE W95_GETJLE (ICOLOR, IY, J, LIMIT,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read a limited integer
C 10/04/2009 added INTENTS
C 10/08/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY, LIMIT
      INTEGER,             INTENT (INOUT) :: J
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JDEF, LIMIT_1
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, LIMIT_1, JDEF
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      ICOUNT = 0
      IF (J.GT.LIMIT) J = LIMIT
      WRITE (LINE,'(I11)') LIMIT
      CALL TRIML1 (LINE)  
      WRITE (TEXT(3),100) LINE
      JDEF = J
      LIMIT_1 = LIMIT
      WRITE (LINE_SAV,'(I11)') JDEF
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = JDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE, 
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (J.GT.LIMIT_1) GOTO 20
  100 FORMAT ('Maximum =',1X,A)       
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETJ01 (ICOLOR, IY, J,
     +                       STRNG)
C
C Use W95_GETTX1 and W95_TXT2I1 to read an unlimited integer
C Display J as the default
C 10/08/2010 added LINE_SAV
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, IY, J
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 1, NUMBER = 1)
      INTEGER    ICOUNT, JDEF
      CHARACTER  STRNG*(*)
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      CHARACTER  LINE*(NLINE), LINE_SAV*(NLINE), TEXT(NUMTXT)*128
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      SAVE       ICOUNT, JDEF
      TEXT(1) = STUB//STRNG
      ICOUNT = 0
      JDEF = J
      WRITE (LINE_SAV,'(I11)') JDEF
      CALL TRIML1 (LINE_SAV)
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         J = JDEF
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT,
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (J,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETJL1 (ICOLOR, IY, JBOT, JMID, JTOP,
     +                       STRNG)
C
C Use W95_GETTX1 to read a limited integer.
C 10/04/2009 added INTENTS 
C 10/08/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY, JBOT, JTOP
      INTEGER,             INTENT (INOUT) :: JMID
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JBOT_1, JMID_1, JTOP_1
      INTEGER    K, X_LEN200
      CHARACTER  LINE*(NLINE), LINE1*(NLINE), LINE2*(NLINE),
     +           TEXT(NUMTXT)*128
      CHARACTER  LINE_SAV*(NLINE)
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1, TRIML1
      EXTERNAL   X_PUTFAT, X_LEN200
      SAVE       ICOUNT, JBOT_1, JMID_1, JTOP_1
C
C First check that limits make sense
C
      IF (JBOT.GE.JTOP) THEN
         CALL X_PUTFAT (
     +  'Serious Programming Error ... JBOT.GE.JTOP in call to GETJL1')
         JMID = (JBOT + JTOP)/2
         RETURN
      ENDIF
      IF (JMID.LT.JBOT .OR. JMID.GT.JTOP) JMID = JBOT
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (LINE1,100) JBOT
      WRITE (LINE2,100) JTOP
      CALL TRIML1 (LINE1)
      CALL TRIML1 (LINE2)
      K = X_LEN200(LINE1)
      WRITE (TEXT(3),200) LINE1(1:K), LINE2
      ICOUNT = 0
      JBOT_1 = JBOT
      JMID_1 = JMID
      JTOP_1 = JTOP
      WRITE (LINE_SAV,100) JMID_1
      CALL TRIML1 (LINE_SAV)
      ICOUNT = 0
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         JMID = JMID_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT, 
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (JMID,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (JMID.LT.JBOT_1 .OR. JMID.GT.JTOP_1) GOTO 20
  100 FORMAT (I11)
  200 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)        
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE W95_GETJM1 (ICOLOR, IY, JBOT, JMID, JTOP,
     +                       STRNG)
C
C Use W95_GETTXT to read a limited integer, but declare the limits
C Display JMID as the default
C 12/04/2009 added INTENTS
C 10/08/2010 added LINE_SAV
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IY, JBOT, JTOP
      INTEGER,             INTENT (INOUT) :: JMID
      CHARACTER (LEN = *), INTENT (IN)    :: STRNG
C
C Locals
C      
      INTEGER    MAXTRY, NLINE, NUMTXT, NUMBER
      PARAMETER (MAXTRY = 5, NLINE = 12, NUMTXT = 3, NUMBER = 1)
      INTEGER    ICOUNT, JBOT_1, JMID_1, JTOP_1, K, X_LEN200
      CHARACTER  LINE*(NLINE), LINE1*(NLINE), LINE2*(NLINE),
     +           TEXT(NUMTXT)*128
      CHARACTER  LINE_SAV*(NLINE)
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      LOGICAL    ABORT
      EXTERNAL   W95_REJECT, W95_GETTX1, W95_TXT2I1
      EXTERNAL   X_PUTFAT
      EXTERNAL   TRIML1, X_LEN200
      SAVE       ICOUNT, JBOT_1, JMID_1, JTOP_1
C
C First check that limits make sense
C
      IF (JBOT.GE.JTOP) THEN
         CALL X_PUTFAT (
     +  'Serious Programming Error ... JBOT.GE.JTOP in call to GETJM1')
         JMID = (JBOT + JTOP)/2
         RETURN
      ENDIF
      IF (JMID.LT.JBOT .OR. JMID.GT.JTOP) JMID = JBOT
C
C Carry on with preliminary definitions
C
      TEXT(1) = STUB//STRNG
      TEXT(2) = BLANK
      WRITE (LINE1,100) JBOT
      WRITE (LINE2,100) JTOP
      CALL TRIML1 (LINE1)
      CALL TRIML1 (LINE2)
      K = X_LEN200(LINE1)
      WRITE (TEXT(3),200) LINE1(1:K), LINE2
      ICOUNT = 0
      JBOT_1 = JBOT
      JMID_1 = JMID
      JTOP_1 = JTOP
      WRITE (LINE_SAV,100) JMID_1
      CALL TRIML1 (LINE_SAV)
C
C Attempt to read JMID
C
   20 CONTINUE
      LINE = LINE_SAV
      ICOUNT = ICOUNT + 1
      IF (ICOUNT.GT.MAXTRY) THEN
         CALL W95_REJECT (ICOLOR, MAXTRY, IY)
         JMID = JMID_1
         RETURN
      ENDIF
      IF (ICOUNT.GT.1) CALL W95_REJECT (ICOLOR, NUMBER, IY)
      CALL W95_GETTX1 (ICOLOR, IY, NUMTXT, 
     +                 LINE, TEXT)
      CALL W95_TXT2I1 (JMID,
     +                 LINE,
     +                 ABORT)
      IF (ABORT) GOTO 20
      IF (JMID.LT.JBOT_1 .OR. JMID.GT.JTOP_1) GOTO 20
  100 FORMAT (I11)
  200 FORMAT ('Minimum =',1X,A,',   Maximum =',1X,A)
      END
C
C
