c
c
      subroutine getmat (ncol, nrmax, nrow,
     +                   x,
     +                   text)
c
c action : Call w_datmat to get a matrix
c author : W. G. Bardsley, University of Manchester, U.K., 03/04/97
c          28/01/2002 edited to handle wide matrices differently
c          06/07/2004 set nwide = 17 and changed getrow to getvec
c          07/07/2004 set nwide = nchar/n14 - n3 to agree with w_editor
c          03/12/2006 derived from w_getmat
c
c          ncol: (input/unchanged) no. columns in matrix
c         nrmax: (input/unchanged) leading dimension of matrix
c          nrow: (input/unchanged) no. rows of matrix
c             x: (output) matrix of initialised values
c          text: (input/unchanged) label for editor to identify matrix
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: ncol, nrmax, nrow
      double precision,    intent (out) :: x(nrmax,ncol)
      character (len = *), intent (in)  :: text
c
c locals
c
      integer    i, icount, j
      integer    nchar, n3, n14, nwide
      parameter (nchar = 1024, n3 = 3, n14 = 14, nwide = nchar/n14 - n3)
      integer    icolor, ix, iy, lshade, numtxt, nmax
      parameter (ix = 4, iy = 4, lshade = 1, numtxt = 20, nmax = 200)
      integer    ntemp, numdec, numopt
      integer    numbld(30), numpos(10)
      integer    nf, ntype
      parameter (nf = 4, ntype = 3)
      integer    isend, itype
      parameter (isend = 2, itype = 1)
      double precision b(nmax)
      double precision one
      parameter (one = 1.0d+00)
      character  line*100, menus(30)*100, title*100
      logical    first, repeet, yesno
      logical    curve, order, vector, weight
      parameter (curve = .false., order = .false., vector = .false.,
     +           weight = .false.)
      logical    fixcol, fixrow, label
      parameter (fixcol = .true., fixrow = .true., label = .true.)
      logical    fileit, fixed
      parameter (fileit = .false., fixed = .false.)
      external   datmat, lbox02, dsplay, editor, patch1,
     +           yesno2, getvec
      save       first
      data       first / .true. /
      data       numbld / 30*0 /
      data       numpos / 10*1 /
      if (ncol.le.nwide) then
c
c Part 1: narrow matrix so call datmat directly then exit
c =======
c
         call datmat (ncol, nrmax, nrow,
     +                x,
     +                text,
     +                curve, order, vector, weight)
      else
c
c Part 2: wide matrix so initialise then enter row-wise with checking
c =======
c
         if (first) then
            first = .false.
            write (menus,100) nwide
            icolor = 9
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   menus,
     +                   fixed)
         endif
         do j = 1, ncol
            do i = 1, nrow
               x(i,j) = one
            enddo
         enddo
c
c Main loop to fill in the matrix
c
         icount = 0
         do while (icount.le.nrow)
            if (icount.eq.0) then
c
c input the first row
c
               icount = 1
               write (line,200) icount, icount, ncol, icount
               call getvec (ncol,
     +                      b,
     +                      line)
               do j = 1, ncol
                  x(icount,j) = b(j)
               enddo
            elseif (icount.lt.nrow) then
               icount = icount + 1
c
c input row icount where 2 =< icount =< nrow
c
               repeet = .true.
               do while (repeet)
                  ntemp = icount - 1
                  write (menus,300) icount
                  numdec = 1
                  numopt = 5
                  icolor = 7
                  call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                          menus)
                  if (numdec.eq.1) then
                     write (line,200) icount, icount, ncol, icount
                     call getvec (ncol, 
     +                            b,
     +                            line)
                     do j = 1, ncol
                        x(icount,j) = b(j)
                      enddo
                      repeet = .false.
                  elseif (numdec.eq.2) then
                     write (title,400) ncol, nrow
                     call dsplay (ncol, ncol, nf, nrmax, nrow, ntype,
     +                            x,
     +                            title,
     +                            fileit)
                  elseif (numdec.eq.3) then
                     write (title,400) ncol, ntemp
                     call editor (isend, itype, ncol, nrmax, ntemp,
     +                              x,
     +                              title,
     +                              curve, fixcol, fixrow, label, order,
     +                              weight)
                  elseif (numdec.eq.4) then
                     write (menus,100) nwide
                     icolor = 9
                     numbld(1) = 1
                     call patch1 (icolor, ix, iy, lshade, numbld,
     +                            numtxt,
     +                            menus,
     +                            fixed)
                  else
                     write (line,500)
                     yesno = .false.
                     icolor = 4
                     call yesno2 (icolor, ix, iy, 
     +                            line,
     +                            yesno)
                     if (yesno) then
                        repeet = .false.
                        icount = nrow + 1
                     endif
                  endif
               enddo
            else
c
c final options after matrix is full
c
               repeet = .true.
               do while (repeet)
                  write (title,400) ncol, nrow
                  write (menus,600)
                  numdec = 1
                  numopt = 3
                  icolor = 7
                  call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                          menus)
                  if (numdec.eq.1) then
                     call dsplay (ncol, ncol, nf, nrmax, nrow, ntype,
     +                            x,
     +                            title,
     +                            fileit)
                  elseif (numdec.eq.2) then
                     call editor (isend, itype, ncol, nrmax, nrow,
     +                            x,
     +                            title,
     +                            curve, fixcol, fixrow, label, order,
     +                            weight)
                  else
                     repeet = .false.
                     icount = nrow + 1
                  endif
               enddo
            endif
         enddo
      endif     
c
c format statements
c      
  100 format (
     + 'Typing in data sets with more than',I4,' columns'
     +/
     +/'With large data sets having many columns, you may prefer to'
     +/'input data row-wise. This is much faster and safer, since it'
     +/'makes it easier to check and edit the data values as they are'
     +/'being typed in, and it avoids exessive up/down scrolling.'
     +/
     +/'You can now enter the data values sequentially as row vectors,'
     +/'but after each row you can view the data or edit the current'
     +/'values. The data matrix has been initialised to contain the'
     +/'value A(i,j) = 1 for all i,j so, if you want to abandon the'
     +/'input phase at any stage, you will be warned and given the'
     +/'opportunity to exit with an unfinished data set. Note that,'
     +/'if you create a data file from this unfinished data set, you'
     +/'can always read it into program Editmt at a later date, then'
     +/'continue editing the unfinished items.'
     +/
     +/'With very large data sets it is best to use a spreadsheet and'
     +/'transfer data sets to Simfit using the clipboard or, e.g. with'
     +/'Excel, use one of the Simfit Excel macros such as simfit4.xls.')
  200 format (
     +'Input A(',i5,',1) to A(',i5,',',I4,') i.e. ROW NUMBER',I5)
  300 format (
     + 'Input row number',I4
     +/'View current matrix'
     +/'Edit current data'
     +/'Help'
     +/'Cancel')
  400 format ('Data for columns 1 to',I4,' and rows 1 to',I5)
  500 format ('Quit current matrix with all unfinished values = 1')
  600 format (
     + 'View'
     +/'Edit'
     +/'Accept')
      end
c
c
