C
C
      SUBROUTINE GETNOU (NOUT)
C
C ACTION: Find an unopened unit in range 12 to 100 or set NOUT = 0
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 1/7/97
C         05/10/1998 Modified to issue error on failure 
C         28/01/2007 Added INTENT 
C
      IMPLICIT   NONE 
C
C Argument
C      
      INTEGER, INTENT (OUT) :: NOUT
C
C Locals
C      
      INTEGER    N0, N12, N100
      PARAMETER (N0 = 0, N12 = 12, N100 = 100)
      INTEGER    I, IOS
      LOGICAL    OP
      EXTERNAL   PUTFAT
      DO I = N12, N100
         NOUT = I
         OP = .TRUE.
         INQUIRE (UNIT = NOUT, OPENED = OP, IOSTAT = IOS)
         IF (IOS.EQ.N0 .AND. .NOT.OP) RETURN
      ENDDO
      NOUT = N0
      CALL PUTFAT ('GETNOU cannot find an unconnected unit: NOUT = 0')
      END
C
C
