C
C Subroutines
C GETR0N
C GETDMN
C

c Resolution of some long-standing Simfit display/input/output problems 

c bill.bardsley@simfit.org.uk, 20/12/2017 

c 1) History of the Simfit get* routines
c    -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.

C
C
      SUBROUTINE GETR0N (N, 
     +                   XVALUE, 
     +                   TEXT)
C
C ACTION: return N unrestricted double precision values
C AUTHOR: W.G.Bardsley, University of Manchester, u.k., 29/02/2000
C         20/12/2017 developed from GETI0N/GET00N
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: N
      DOUBLE PRECISION,    INTENT (INOUT) :: XVALUE(N) 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(N)
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 0, NSTART = 1)
      INTEGER    N0, N1, N2, NMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, NMAX = 100)
      INTEGER    NUMBLD(NMAX), NUMPOS(NMAX)
      INTEGER    I, NTEMP, NVALUE(NMAX)
      CHARACTER  STRNG(NMAX)*1
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .FALSE.,
     +           TAB_TOP = .FALSE.)
      EXTERNAL   GET00N
      INTRINSIC  MIN
      NTEMP = MIN(N, NMAX)
      DO I = N1, NTEMP
          NUMBLD(I) = N0
          NUMPOS(I) = N2
      ENDDO
      CALL GET00N (ICOLOR, IX, IY, NVALUE, LSHADE, NUMBLD, NTEMP,
     +             NUMPOS, NSTART, NTEMP,
     +             XVALUE,
     +             STRNG, TEXT,
     +             TAB_BOT, TAB_MID, TAB_TOP)
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE GETDMN (N,
     +                   XBOT, XMID, XTOP, 
     +                   TEXT)
C
C ACTION: return N limited double precision values with defaults supplied
C AUTHOR: w.g.bardsley, university of manchester, u.k., 20/03/2019
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: N
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT(N), XTOP(N)
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID(N) 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(N)     
C
C Locals
C      
      INTEGER    I 
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      CHARACTER (LEN = 100) LINE
      LOGICAL    ABORT, SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   PUTFAT, W_RFVALS
      IF (N.LT.1) THEN
         WRITE (LINE,100)
         CALL PUTFAT (LINE)
         RETURN
      ENDIF   
      DO I = 1, N
         IF (XBOT(I).GT.XTOP(I)) THEN
            WRITE (LINE,200) I
            CALL PUTFAT (LINE)
            RETURN
         ENDIF
         IF (XMID(I).LT.XBOT(I) .OR. XMID(I).GT.XTOP(I)) THEN
            XMID(I) = (XBOT(I) + XTOP(I))/TWO
         ENDIF   
      ENDDO 
      CALL W_RFVALS (N,
     +               XBOT, XMID, XTOP,
     +               TEXT,
     +               ABORT, SUPPLY) 
      IF (ABORT) THEN
         WRITE (LINE,300)
         CALL PUTFAT (LINE)
      ENDIF 
C
C Format statements
C      
  100 FORMAT ('N < 1 in call to GETDMN')      
  200 FORMAT ('XBOT(I) > XTOP(I) in call to GETDMN at I =',I3) 
  300 FORMAT ('FAILURE in call to W_RFVALS from GETDMN')
      END
C
C
      