C
C
      SUBROUTINE GETSXY (N,
     +                   S, X, Y,
     +                   TEXT,
     +                   ORDER, WEIGHT)
C
C ACTION : Get s, x, y
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/01/97 
C          03/12/2006 extensive editing
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: N 
      DOUBLE PRECISION,    INTENT (OUT) :: S(N), X(N), Y(N)
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT 
      LOGICAL,             INTENT (IN)  :: ORDER, WEIGHT
C
C Locals
C      
      INTEGER    NCMAX, NRMAX, NRMIN
      PARAMETER (NCMAX = 3, NRMAX = 250, NRMIN = 1)
      INTEGER    NCOL, NROW
      INTEGER    I, J
      DOUBLE PRECISION XX(NRMAX,NCMAX)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00) 
      LOGICAL    CURVE, VECTOR
      PARAMETER (CURVE = .TRUE., VECTOR = .FALSE.)
      EXTERNAL   PUTFAT
      EXTERNAL   DATMAT
C
C Check N
C
      IF (N.GT.NRMAX .OR. N.LT.NRMIN) THEN
         CALL PUTFAT ('N out of range in call to GETSXY')
         RETURN
      ENDIF
C
C Initialise XX
C
      DO I = 1, NCMAX
         DO J = 1, N
            XX(J,I) = ONE
         ENDDO
      ENDDO
      IF (WEIGHT) THEN
         NCOL = 3
      ELSE
         NCOL = 2
      ENDIF
      NROW = N
      CALL DATMAT (NCOL, NRMAX, NROW,
     +             XX,
     +             TEXT,
     +             CURVE, ORDER, VECTOR, WEIGHT)
C
C Assign S, X, Y
C
      DO I = 1, N
         X(I) = XX(I,1)
         Y(I) = XX(I,2)
         S(I) = XX(I,3)
      ENDDO
      END
C
C
