c
c Resolution of some long-standing Simfit display/input/output problems 
c
c bill.bardsley@simfit.org.uk, 11/08/2011 
c 18/12/2017 introduced call to w_rdvals
c 22/12/2017 introduced call to w_rfvals
c 04/05/2022 decreased epsi everywhere from 1.0d-07 to 1.0d-20 after problems with getdgt
c
c 1) History of the Simfit get* routines
c    -----------------------------------

c When the Windows95 version of simfit was created, all the DBOS
c routines were replaced by routines with prefix w95_. Over many
c years these gave all sorts of problems and were steadily evolved
c to get round them.

c In particular, Malcolm Cohen recently pointed out that double 
c precision variables could be truncated, so that values input as
c defaults for editing could be returned with errors in trailing
c significant figures, despite no editing action being taken by users.

c Also, Francisco Burguillo observed that double precision variables
c input to the subroutine getr00n could, in some circumstances, have
c internal representation errors leading to misleading displays.

c At the present time these problems, and several others, have finally
c been resolved by using new and improved routines in w_clearwin.dll
c for the user interface controls.

c 2) Subroutines in w_clearwin.dll
c    ----------------------------- 

c These are the routines now used for the user interface controls that 
c seem to have finally solved all the input/output/display problems.

c   w_get00n ... Get any number of integer, double precision, character,
c                or logical variables up to 20 in total. These must all be
c                initialised before calling w_get00n. 

c   w_xlines ... This accepts up to 25 character variables of length 12 
c                for integers and 25 for double precision variables.
c                Blank or initialised character strings can be input
c                then edited values are returned.

c   w_ylines ... Exactly as w_xlines except that extra character strings
c                can be supplied to display to the right of the edit boxes.

c   x_form12 ... Write integer variables in left justified format to 
c                (len = 12) character strings.
               
c   x_form25 ... Write double precision variables to left justified 
c                (len = 25) character strings so that at least 15 
c                significant figures are preserved, but using i format 
c                if appropriate, or else f or e format with trailng 
c                zeros removed.

c   x_txt2i1 ... Read an integer value using enhanced formatting and
c                error checking. Used by w_xlines and w_ylines. Allows
c                spaces in input fields so that, for instance
c                1 2 3 4 5 = 12345 

c   x_txt2r1 ... Read a double precision value using enhanced formatting 
c                and error checking. Used by w_get00n, w_xlines and
c                w_ylines. Allows commas and spaces in input fields so
c                that, for instance
c                1 2 3 , 4 5 6 = 123.456
c                Does not allow some otherwise legal inputs like just
c                a D, or just an E. 
 
c 3) Subroutines in w_menus.dll
c    --------------------------

c These are the front end subroutines that call the w_clearwin.dll codes.
c Most of the code required for argument checking is in the composite
c file called getw95.for described below.

c getall.for  Driver program to illustrate how to call the simple get
c             routines with 6-character stubs in getw95.for.

c getdbl.for  Intermediate w95_* subroutines called by the standard 
c             6-character stubs in getw95.for, calling routines
c             like w95_gettx1 then w95_txt2r1 to return double
c            precision values
 
c geti0n.for  Get up to 20 integers using w_get00n

c getint.for  Intermediate w95_* subroutines called by the standard 
c             6-character standard stubs in getw95.for, calling routines 
c             like w95_getx1 then w95_txt2i1 to return integer values.

c getr0n.for  Get up to 25 double precision values using w_ylines.

c getw95.for  The standard 6-character stubs used to call the w95_* routines
c             in getdbl and getint. The calling trees can be deduced from
c             these stubs. Almost all the calls from Simfit and Simdem are 
c             actually calls to these simple 6-character stubs.

c txtw95.for  Calls routines like w95_txt2i1 and w95_txt2r1.
c             Values are retrieved using w_xlines.

C
C The basic input routines to get integers, reals and character strings
C =====================================================================
C

C Integers:
C ========
C GETI01
C GETIGE
C GETIGT
C GETIL1
C GETILE
C GETILT
C GETIM1
C GETJ01
C GETJGE
C GETJL1
C GETJM1
C
C Doubles:
C =======
C GETR01
C GETR02
C GETR03
C GETRG2
C GETRG3
C GETRGE
C GETRGT
C GETRL1
C GETRL2
C GETRLE
C GETRLT
C GETRM1
C GETD01
C GETD02
C GETD03
C GETDGE
C GETDGT
C GETDLE
C GETDLT
C GETDG2
c GETDG3
C GETDL1
C GETDL2
C GETDM1
C
C Text:
C =====
C GETTXT
C GETSTR
C
C Logicals:
C ========
C GETL01
C
C-----------------------------------------------------
C
      SUBROUTINE RDVAL1 (NBOT_IN, NMID_IN, NTOP_IN,
     +                   TEXT_IN,
     +                   SUPPLY_IN)
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NBOT_IN, NTOP_IN
      INTEGER,             INTENT (INOUT) :: NMID_IN
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT_IN
      LOGICAL,             INTENT (IN)    :: SUPPLY_IN
C
C Locals
C      
      INTEGER    N
      PARAMETER (N = 1)
      INTEGER    L, NBOT(N), NMID(N), NTOP(N)
      CHARACTER (LEN = 80) TEXT(N)
      CHARACTER (LEN = 1 ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, SUPPLY
      EXTERNAL   W_RDVALS
      INTRINSIC  LEN_TRIM, MIN
      SUPPLY = SUPPLY_IN
      NBOT(N) = NBOT_IN
      IF (SUPPLY) NMID(N) = NMID_IN
      NTOP(N) = NTOP_IN
      L = MIN(LEN_TRIM(TEXT_IN),80)
      TEXT(N) = BLANK
      IF (L.GE.N) TEXT(N)(1:L) = TEXT_IN(1:L)
      CALL W_RDVALS (N, NBOT, NMID, NTOP,
     +               TEXT,
     +               ABORT, SUPPLY)  
      NMID_IN = NMID(N)
      END
C
C-----------------------------------------------------
C
      SUBROUTINE RFVAL1 (XBOT_IN, XMID_IN, XTOP_IN,
     +                   TEXT_IN,
     +                   SUPPLY_IN)
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT_IN, XTOP_IN
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID_IN
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT_IN
      LOGICAL,             INTENT (IN)    :: SUPPLY_IN
C
C Locals
C      
      INTEGER    N
      PARAMETER (N = 1)
      INTEGER    L
      DOUBLE PRECISION XBOT(N), XMID(N), XTOP(N) 
      CHARACTER (LEN = 80) TEXT(N)
      CHARACTER (LEN = 1 ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, SUPPLY
      EXTERNAL   W_RFVALS
      INTRINSIC  LEN_TRIM, MIN
      SUPPLY = SUPPLY_IN
      XBOT(N) = XBOT_IN
      IF (SUPPLY) XMID(N) = XMID_IN
      XTOP(N) = XTOP_IN
      L = MIN(LEN_TRIM(TEXT_IN),80)
      TEXT(N) = BLANK
      IF (L.GE.N) TEXT(N)(1:L) = TEXT_IN(1:L)
      CALL W_RFVALS (N, 
     +               XBOT, XMID, XTOP,
     +               TEXT,
     +               ABORT, SUPPLY)  
      XMID_IN = XMID(N)
      END
C
C-----------------------------------------------------
C
      SUBROUTINE RFVAL2 (XBOT_IN, XMID_IN, XTOP_IN,
     +                   TEXT_IN,
     +                   SUPPLY_IN)
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT_IN(2), XTOP_IN(2)
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID_IN(2)
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT_IN(2)
      LOGICAL,             INTENT (IN)    :: SUPPLY_IN
C
C Locals
C      
      INTEGER    N
      PARAMETER (N = 2)
      DOUBLE PRECISION XBOT(N), XMID(N), XTOP(N) 
      LOGICAL    ABORT, SUPPLY
      EXTERNAL   W_RFVALS
      SUPPLY = SUPPLY_IN
      XBOT(1) = XBOT_IN(1)
      XBOT(2) = XBOT_IN(2)
      IF (SUPPLY) THEN
         XMID(1) = XMID_IN(1)
         XMID(2) = XMID_IN(2)
      ENDIF   
      XTOP(1) = XTOP_IN(1)
      XTOP(2) = XTOP_IN(2)
      CALL W_RFVALS (N, 
     +               XBOT, XMID, XTOP,
     +               TEXT_IN,
     +               ABORT, SUPPLY)  
      XMID_IN(1) = XMID(1)
      XMID_IN(2) = XMID(2)
      END
C
C-----------------------------------------------------
C
      SUBROUTINE RFVAL3 (XBOT_IN, XMID_IN, XTOP_IN,
     +                   TEXT_IN,
     +                   SUPPLY_IN)
      IMPLICIT NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT_IN(3), XTOP_IN(3)
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID_IN(3)
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT_IN(3)
      LOGICAL,             INTENT (IN)    :: SUPPLY_IN
C
C Locals
C      
      INTEGER    N
      PARAMETER (N = 3)
      DOUBLE PRECISION XBOT(N), XMID(N), XTOP(N) 
      LOGICAL    ABORT, SUPPLY
      EXTERNAL   W_RFVALS
      SUPPLY = SUPPLY_IN
      XBOT(1) = XBOT_IN(1)
      XBOT(2) = XBOT_IN(2)
      XBOT(3) = XBOT_IN(3)
      IF (SUPPLY) THEN
         XMID(1) = XMID_IN(1)
         XMID(2) = XMID_IN(2)
         XMID(3) = XMID_IN(3)
      ENDIF   
      XTOP(1) = XTOP_IN(1)
      XTOP(2) = XTOP_IN(2)
      XTOP(3) = XTOP_IN(3)
      CALL W_RFVALS (N, 
     +               XBOT, XMID, XTOP,
     +               TEXT_IN,
     +               ABORT, SUPPLY)  
      XMID_IN(1) = XMID(1)
      XMID_IN(2) = XMID(2)
      XMID_IN(3) = XMID(3)
      END      
C      
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETI01 (I, 
     +                   TEXT)
C
C ACTION : Ask for input then get an unlimited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 28/12/96
C          12/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: I
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NTOP = 2**30 - 1, NBOT = - NTOP)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETIGE (I, LIMIT,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I >= LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          10/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: I
      INTEGER,             INTENT (IN)  :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NTOP = 2**30 - 1)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      NBOT = LIMIT
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETIGT (I, LIMIT, 
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I > LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          10/04/2009 added INTENTS 
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: I
      INTEGER,             INTENT (IN)  :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP, N1
      PARAMETER (NTOP = 2**30 - 1, N1 = 1)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      NBOT = LIMIT + N1
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETIL1 (NBOT, NMID, NTOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96 returns NBOT =< NMID =< NTOP
C          10/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: NMID
      INTEGER,             INTENT (IN)  :: NBOT, NTOP 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      IF (NBOT.EQ.NTOP) THEN
         NMID = NBOT
      ELSE   
         CALL RDVAL1 (NBOT, NMID, NTOP, 
     +                TEXT,  
     +                SUPPLY)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETILE (I, LIMIT, TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I <= LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: I
      INTEGER,             INTENT (IN)  :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NBOT = -(2**30 - 1))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      NTOP = LIMIT
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETILT (I, LIMIT,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I < LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 18/2/94
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: I
      INTEGER,             INTENT (IN)  :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP, N1
      PARAMETER (NBOT = -(2**30 - 1), N1 = 1)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      NTOP = LIMIT - N1
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETIM1 (NBOT, NMID, NTOP,
     +                   TEXT)
C
C ACTION : Get  NBOT =< NMID =< NTOP
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 18/4/93
C          W95 version ... 22/1/97
C          10/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: NMID
      INTEGER,             INTENT (IN)  :: NBOT, NTOP 
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RDVAL1
      IF (NBOT.EQ.NTOP) THEN
         NMID = NBOT
      ELSE   
         CALL RDVAL1 (NBOT, NMID, NTOP, 
     +                TEXT,  
     +                SUPPLY)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETJ01 (I, 
     +                   TEXT)
C
C ACTION : Ask for input then get an unlimited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 28/12/96
C          24/01/2001 displays I supplied as the default
C          12/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: I
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NTOP = 2**30 - 1, NBOT = - NTOP)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RDVAL1
      NMID = I
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE GETJGE (I, LIMIT,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I >= LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          10/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: I
      INTEGER,             INTENT (IN)    :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NTOP = 2**30 - 1)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RDVAL1
      NBOT = LIMIT
      NMID = I
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END
C
C--------------------------------------------------------------------
C
      SUBROUTINE GETJLE (I, LIMIT,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C          Returns I =< LIMIT
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          10/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: I
      INTEGER,             INTENT (IN)    :: LIMIT 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      INTEGER    NBOT, NMID, NTOP
      PARAMETER (NBOT = -(2**30 - 1))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RDVAL1
      NTOP = LIMIT
      NMID = I
      CALL RDVAL1 (NBOT, NMID, NTOP, 
     +             TEXT,  
     +             SUPPLY)
      I = NMID
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETJL1 (NBOT, NMID, NTOP, 
     +                   TEXT)
C
C ACTION : Ask for input then get a limited integer from the keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          10/04/2009 added INTENTS (Now identical with GETJM1)
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: NMID
      INTEGER,             INTENT (IN)    :: NBOT, NTOP 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RDVAL1
      IF (NBOT.EQ.NTOP) THEN
         NMID = NBOT
      ELSE   
         CALL RDVAL1 (NBOT, NMID, NTOP, 
     +                TEXT,  
     +                SUPPLY)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETJM1 (NBOT, NMID, NTOP,
     +                   TEXT)
C
C ACTION : Get  NBOT =< NMID =< NTOP
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 18/4/93
C          W95 version ... 22/1/97
C          24/01/2001 displays NMID supplied as the default
C          12/04/2009 added INTENTS
C          18/12/2017 now calls RDVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (INOUT) :: NMID
      INTEGER,             INTENT (IN)    :: NBOT, NTOP 
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RDVAL1
      IF (NBOT.EQ.NTOP) THEN
         NMID = NBOT
      ELSE   
         CALL RDVAL1 (NBOT, NMID, NTOP, 
     +                TEXT,  
     +                SUPPLY)
      ENDIF
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETR01 (X,
     +                   TEXT)
C
C ACTION : Ask for input then get one real unlimited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT, XTOP
      PARAMETER (XTOP = 1.0D+300 + 1.0D+00, XBOT = -XTOP)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, X, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETR02 (X, Y,
     +                   TEXT)
C
C ACTION : Ask for input then get two real unlimited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL2 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT(2), XMID(2), XTOP(2)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      CHARACTER (LEN = 80) TEXT_IN(2)
      CHARACTER (LEN = 6 ) SRNAME
      PARAMETER (SRNAME = 'getr02')
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL2
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME 
      CALL RFVAL2 (XBOT, XMID, XTOP,
     +             TEXT_IN,
     +             SUPPLY)
      X = XMID(1)
      Y = XMID(2)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETR03 (X, Y, Z,
     +                   TEXT)
C
C ACTION : Ask for input then get three real unlimited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL3 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT(3), XMID(3), XTOP(3)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      CHARACTER (LEN = 80) TEXT_IN(3)
      CHARACTER (LEN = 6 ) SRNAME
      CHARACTER (LEN = 1 ) DOT
      PARAMETER (DOT = ' ')
      PARAMETER (SRNAME = 'getr03')
      EXTERNAL   RFVAL3
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XBOT(3) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP
      XTOP(3) = YTOP
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME
      TEXT_IN(3) = DOT 
      CALL RFVAL3 (XBOT, XMID, XTOP,
     +             TEXT_IN,
     +             SUPPLY)
      X = XMID(1)
      Y = XMID(2)
      Z = XMID(3)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRG2 (X, Y, 
     +                   TEXT)
C
C ACTION : Ask for input then get two real numbers from keyboard
C          Reject unless Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 calls GETR02
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      EXTERNAL GETR02, X_PUTFAT 
   20 CONTINUE   
      CALL GETR02 (X, Y,
     +             TEXT)
      IF (X.GT.Y) THEN
         CALL X_PUTFAT (
     +'Must have Second number >= First number')
         GOTO 20 
      ENDIF   
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRG3 (X, Y, Z, 
     +                   TEXT)
C
C ACTION : Ask for input then get three real numbers from keyboard
C          Reject unless Z >= Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 calls GETR03
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      EXTERNAL GETR03, X_PUTFAT 
   20 CONTINUE   
      CALL GETR03 (X, Y, Z,
     +             TEXT)
      IF (X.GT.Y .OR. Y.GT.Z) THEN
         CALL X_PUTFAT (
     +'Must have Third number >= Second number >= First number')
         GOTO 20 
      ENDIF   
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRGE (X, XLIM, 
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X >= XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          DBOS version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 calls RFVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT, XMID, XTOP
      PARAMETER (XTOP = 1.0D+300 + 1.0D+00)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1, X_PUTFAT 
   20 CONTINUE   
      XBOT = XLIM
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      IF (XMID.LT.XLIM) THEN
         CALL X_PUTFAT ('Number is out of range')
         GOTO 20 
      ENDIF 
      X = XMID
      END  
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRGT (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X > XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 calls RFVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION EPSI, XBOT, XMID, XTOP
      PARAMETER (EPSI = 1.0D-20, XTOP = 1.0D+300 + 1.0D+00)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1, X_PUTFAT 
   20 CONTINUE   
      XBOT = XLIM + EPSI
      IF (X.LT.XBOT) X = XBOT
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      IF (XMID.LE.XLIM + EPSI) THEN
         CALL X_PUTFAT ('Number is out of range')
         GOTO 20 
      ENDIF 
      X = XMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRL1 (XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a real limited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP  
      DOUBLE PRECISION,    INTENT (OUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRL2 (EPSI, XBOT, XSTART, XSTOP, XTOP, 
     +                   TEXT)
C
C ACTION : Ask for input then get two real limited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)  :: EPSI, XBOT, XTOP
      DOUBLE PRECISION,    INTENT (OUT) :: XSTART, XSTOP
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      INTEGER    ICOLOR, IY
      PARAMETER (ICOLOR = 4, IY = 4)
      EXTERNAL   W95_GETRL2
      CALL W95_GETRL2 (ICOLOR, IY,
     +                 EPSI, XBOT, XSTART, XSTOP, XTOP,
     +                 TEXT)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRLE (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X =< XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT, XMID, XTOP
      PARAMETER (XBOT = -(1.0D+300 + 1.0D+00))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1
      XTOP = XLIM
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      X = XMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRLT (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X < XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (OUT) :: X
      DOUBLE PRECISION,    INTENT (IN)  :: XLIM
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      DOUBLE PRECISION EPSI, XBOT, XMID, XTOP
      PARAMETER (EPSI = 1.0D-20, XBOT = -(1.0D+300 + 1.0D+00))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1
      XTOP = XLIM - EPSI
      IF (X.GT.XTOP) X = XTOP
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      X = XMID
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETRM1 (XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : GET XBOT =< XMID =< XTOP
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)  :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (OUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)  :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .FALSE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETD01 (X,
     +                   TEXT)
C
C ACTION : Ask for input then get one real unlimited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          24/01/2001 displays X supplied as the default
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT, XTOP
      PARAMETER (XTOP = 1.0D+300 + 1.0D+00, XBOT = -XTOP)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, X, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETD02 (X, Y, 
     +                   TEXT)
C
C ACTION : Ask for input then get two real unlimited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL2 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT(2), XMID(2), XTOP(2)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      CHARACTER (LEN = 80) TEXT_IN(2)
      CHARACTER (LEN = 6 ) SRNAME
      PARAMETER (SRNAME = 'getd02')
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL2
      XMID(1) = X
      XMID(2) = Y
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME
      CALL RFVAL2 (XBOT, XMID, XTOP,
     +             TEXT_IN,
     +             SUPPLY)
      X = XMID(1)
      Y = XMID(2)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETD03 (X, Y, Z, 
     +                   TEXT)
C
C ACTION : Ask for input then get three real unlimited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL3 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT(3), XMID(3), XTOP(3)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      CHARACTER (LEN = 80) TEXT_IN(3)
      CHARACTER (LEN = 6 ) SRNAME
      PARAMETER (SRNAME = 'getd03')
      CHARACTER (LEN = 1 ) DOT
      PARAMETER (DOT = '.')
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL3
      XMID(1) = X
      XMID(2) = Y
      XMID(3) = Z
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XBOT(3) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP
      XTOP(3) = YTOP
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME
      TEXT_IN(3) = DOT
      CALL RFVAL3 (XBOT, XMID, XTOP,
     +             TEXT_IN,
     +             SUPPLY)
      X = XMID(1)
      Y = XMID(2)
      Z = XMID(3)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GETDGT (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X > XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          18/01/2010 developed from GETDGE
C          22/12/2017 calls RFVAL1
C          04/05/2022 decreased EPSI from 1.0d-07 to 1.0d-20 
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION EPSI, XBOT, XTOP
      PARAMETER (EPSI = 1.0D-20, XTOP = 1.0D+300 + 1.0D+00)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1 
      XBOT = XLIM + EPSI      ! to make sure X > XLIM
      IF (X.LT.XBOT) X = XBOT ! and not X >= XLIM 
      CALL RFVAL1 (XBOT, X, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C-----------------------------------------------------------------------
C
      SUBROUTINE GETDGE (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X >= XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          24/01/2001 displays X supplied as the default
C          14/04/2009 added INTENTS
C          22/12/2017 calls RFVAL1
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XTOP
      PARAMETER (XTOP = 1.0D+300 + 1.0D+00)
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1 
      CALL RFVAL1 (XLIM, X, XTOP,
     +             TEXT,
     +             SUPPLY)
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETDLT (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X < XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          18/01/2010 developed from GETDLE
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION EPSI, XBOT, XTOP
      PARAMETER (EPSI = 1.0D-20, XBOT = -(1.0D+300 + 1.0D+00))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1
      XTOP = XLIM - EPSI
      IF (X.GT.XTOP) X = XTOP
      CALL RFVAL1 (XBOT, X, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETDLE (X, XLIM,
     +                   TEXT)
C
C ACTION : Ask for input then get a limited real from the keyboard
C          Returns X =< XLIM
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 29/12/96
C          24/01/2001 displays X supplied as the default
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X
      DOUBLE PRECISION,    INTENT (IN)    :: XLIM
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT
      PARAMETER (XBOT = -(1.0D+300 + 1.0D+00))
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, X, XLIM,
     +             TEXT,
     +             SUPPLY)
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETDG2 (X, Y,
     +                   TEXT)
C
C ACTION : Ask for input then get two real numbers from keyboard
C          Reject unless Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          24/01/2001 displays X, Y supplied as the default
C          14/04/2009 aded INTENTS
C          22/12/2017 calls GETD02
C          26/12/2017 now calls RFVAL2 
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      DOUBLE PRECISION XBOT(2), XMID(2), XTOP(2)
      CHARACTER (LEN = 80) TEXT_IN(2)
      CHARACTER (LEN = 6 ) SRNAME
      PARAMETER (SRNAME = 'getdg2')
      LOGICAL REPEET
      LOGICAL SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL RFVAL2, X_PUTFAT 
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP 
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME
      REPEET = .TRUE.
      DO WHILE (REPEET)   
         XMID(1) = X
         XMID(2) = Y
         CALL RFVAL2 (XBOT, XMID, XTOP,
     +                TEXT_IN,
     +                SUPPLY)
         IF (XMID(1).GT.XMID(2)) THEN
            CALL X_PUTFAT (
     +'Must have Second number >= First number')
         ELSE
            REPEET =.FALSE. 
         ENDIF   
      ENDDO
      X = XMID(1)
      Y = XMID(2)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETDG3 (X, Y, Z,
     +                   TEXT)
C
C ACTION : Ask for input then get two real numbers from keyboard
C          Reject unless Z >= Y >= X
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 26/11/92
C          W95 version ... 29/12/96
C          24/01/2001 displays X, Y, Z supplied as the default
C          14/04/2009 aded INTENTS
C          22/12/2017 calls GETD03
C          26/12/2017 now call RFVAL3
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (INOUT) :: X, Y, Z
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      DOUBLE PRECISION XBOT(3), XMID(3), XTOP(3)
      DOUBLE PRECISION YBOT, YTOP
      PARAMETER (YTOP = 1.0D+300 + 1.0D+00, YBOT = -YTOP)
      CHARACTER (LEN = 80) TEXT_IN(3)
      CHARACTER (LEN = 6 ) SRNAME
      PARAMETER (SRNAME = 'getdg3')
      CHARACTER (LEN = 1 ) DOT
      PARAMETER (DOT = '.')
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      LOGICAL    REPEET
      EXTERNAL RFVAL3, X_PUTFAT 
      XBOT(1) = YBOT
      XBOT(2) = YBOT
      XBOT(3) = YBOT
      XTOP(1) = YTOP
      XTOP(2) = YTOP
      XTOP(3) = YTOP
      TEXT_IN(1) = TEXT
      TEXT_IN(2) = SRNAME
      TEXT_IN(3) = DOT
      REPEET = .TRUE.
      DO WHILE (REPEET)   
         XMID(1) = X
         XMID(2) = Y
         XMID(3) = Z
         CALL RFVAL3 (XBOT, XMID, XTOP,
     +                TEXT_IN,
     +                SUPPLY)
         IF (XMID(1).GT.XMID(2) .OR. XMID(2).GT.XMID(3)) THEN
            CALL X_PUTFAT (
     +'Must have Third number >= Second number >= First number')
         ELSE 
            REPEET = .FALSE.
         ENDIF   
      ENDDO
      X = XMID(1)
      Y = XMID(2)
      z = XMID(3)
      END      
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETDL1 (XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : Ask for input then get a real limited number from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 28/11/92
C          W95 version ... 30/12/96
C          14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      INTEGER    ICOLOR, IY
      PARAMETER (ICOLOR = 1, IY = 4)
      EXTERNAL   W95_GETDL1
      CALL W95_GETDL1 (ICOLOR, IY,
     +                 XBOT, XMID, XTOP,
     +                 TEXT)
      END
C
C
      SUBROUTINE GETDL2 (EPSI, XBOT, XSTART, XSTOP, XTOP, TEXT)
C
C ACTION : Ask for input then get two real limited numbers from keyboard
C AUTHOR : W. G. Bardsley, University of Manchester, U. K., 10/08/2007
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, IY
      PARAMETER (ICOLOR = 4, IY = 4)
      DOUBLE PRECISION EPSI, XBOT, XSTART, XSTOP, XTOP
      CHARACTER  TEXT*(*)
      EXTERNAL   W95_GETDL2
      CALL W95_GETDL2 (ICOLOR, IY, EPSI, XBOT, XSTART, XSTOP, XTOP,
     +                 TEXT)
      END
C
C----------------------------------------------------------------------      
C
      SUBROUTINE GETDM1 (XBOT, XMID, XTOP,
     +                   TEXT)
C
C ACTION : GET XBOT =< XMID =< XTOP
C AUTHOR : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K., 18/4/93
C          W95 version ... 30/12/96
C          24/01/2001 displays XMID supplied as the default
C          14/04/2009 added INTENTS
C          22/12/2017 used RFVAL1 
C               
      IMPLICIT   NONE
C
C Arguments
C      
      DOUBLE PRECISION,    INTENT (IN)    :: XBOT, XTOP
      DOUBLE PRECISION,    INTENT (INOUT) :: XMID
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT
C
C Locals
C      
      LOGICAL    SUPPLY
      PARAMETER (SUPPLY = .TRUE.)
      EXTERNAL   RFVAL1
      CALL RFVAL1 (XBOT, XMID, XTOP,
     +             TEXT,
     +             SUPPLY)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETTXT (QUERY, TEXT)
C
C ACTION : Return TEXT in response to QUERY
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 25/12/92
C          W95 version ... 30/12/96
C          14/09/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C  
      CHARACTER (LEN = *), INTENT (IN)  :: QUERY
      CHARACTER (LEN = *), INTENT (OUT) :: TEXT    
C
C Locals
C      
      INTEGER    ICOLOR, IY, NUMTXT
      PARAMETER (ICOLOR = 7, IY = 4, NUMTXT = 1)
      CHARACTER  QUESTN(NUMTXT)*128
      CHARACTER  BLANK*1, STUB*7
      PARAMETER (BLANK = ' ', STUB = 'INPUT: ')
      EXTERNAL   W95_GETTXT
      QUESTN(1) = STUB//QUERY
      TEXT = BLANK
      CALL W95_GETTXT (ICOLOR, IY, NUMTXT,
     +                 TEXT, QUESTN)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETSTR (QUERY, TEXT)
C
C ACTION : Return TEXT in response to QUERY
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 25/12/92
C          W95 version ... 30/12/96
C          23/10/95 differs from GETTXT in that it displays TEXT not ?
C                   so TEXT must be initialised before this can be used
C          Date of this version 30/12/96
C          14/04/2009 added INTENTS
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (IN)    :: QUERY
      CHARACTER (LEN = *), INTENT (INOUT) :: TEXT
C
C Locals
C      
      INTEGER    ICOLOR, IY, NUMTXT
      PARAMETER (ICOLOR = 7, IY = 4, NUMTXT = 1)
      CHARACTER  STUB*7
      PARAMETER (STUB = 'INPUT: ')
      CHARACTER  QUESTN(NUMTXT)*128
      EXTERNAL   W95_GETTXT
      QUESTN(1) = STUB//QUERY
      CALL W95_GETTXT (ICOLOR, IY, NUMTXT,
     +                 TEXT, QUESTN)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE GETL01 (LINE,
     +                   YESNO)
C
C ACTION: Call YESNO2 to return a logical Yes/No
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 03/01/2000
C         14/04/2009 added INTENTS 
C
      IMPLICIT   NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (IN)    :: LINE
      LOGICAL,             INTENT (INOUT) :: YESNO
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4)
      EXTERNAL   YESNO2
      CALL YESNO2 (ICOLOR, IX, IY,
     +             LINE,
     +             YESNO)
      END
C
C
      





