c
c
      subroutine getwrd (isend, ncol, nin, nrow, nword,
     +                   fname, word)
c
c action: extract words from a file assuming dimension word(nword)*40
c author: w.g.bardsley, university of manchester, u.k., 30/01/2002
c         08/07/2006 improved initialisation component
c         18/07/2006 improved error messages
c         14/09/2006 added R and C to default row and column labels if isend = 3
c         23/10/2006 improved program flow and added call to eofcha
c         05/11/2006 further checks to avoid including false lines 
c         15/05/2007 improved code in Method 2 and added call to labels
c         29/12/2007 added no_labels, nwmax, nsav_c, and nsav_r
c         08/01/2008 now reports errors only if begin{labels}...end{labels} fails 
c         25/04/2011 increased dimension to 20 in call to labels
c
c isend: (input/unchanged) as follows:
c         isend = 1: just extract row labels in word(1) to word(nrow)
c         isend = 2: just extract column labels in word(1) to word(ncol)
c         isend = 3: extract row and column labels packed contiguously
c                    in word(1) to word(nrow + ncol)
c  ncol: (input/unchanged) column dimension > 0
c  nrow: (input/unchanged) row dimension > 0
c   nin: (input/unchanged) unconnected unit for file opening
c nword: (input/unchanged) dimension of word
c fname: (input/unchanged) simfit data file
c  word: (input/output) labels read off end of data file if present
c
c Note: this routine always tries to initialise WORD sensibly then goes on
c       to first of all try using eofcha to locate the cipher '\begin{labels}'.
c       If this succeeds then word has been overwritten. If this fails then
c       the routine attempts to read the labels beginning at the start of the
c       trailer. This will only succeed if the trailer header is at least as
c       large as the number of labels required and this is followed directly
c       by the correct number of labels. The routine will fail and return
c       the defaults if the supposed labels contain any "begin{}...end{}"
c       type constructs.  
c
c Advice: this subroutine should only be called when extracting labels from a
c         data file makes sense, i.e. when either no. of rows, or no. of columns
c         is less or equal nwmax, the maxmimum no. of labels that can be plotted.
c         The calling program should have a trap to prevent trying to extract
c         labels when there are too many to plot. The value of nwmax is set
c         in w_graphics.dll and is currently nwmax = 2000  
c             
c
      implicit   none  
c
c arguments
c
      integer,             intent (in)    :: isend, ncol, nin, nrow,
     +                                       nword
      character (len = *), intent (in)    :: fname
      character (len = *), intent (inout) :: word(nword)
c
c local allocatable array
c                     
      double precision,     allocatable :: x(:)  
      character (len = 40), allocatable :: wtemp(:)
c
c locals
c
      integer    i, ierr, ios, isav, j, jsav, k, nsav
      integer    nsav_c, nsav_r   
      integer    nwmax, n1, n20, n60
      parameter (nwmax = 2000, n1 = 1, n20 = 20, n60 = 60)
      integer    jcolor(n20), kfill(n20)
      character  line*100, temp*80, word6*6
      character  check1*13, check2*11, check3*13, check4*11,
     +           check5*17, check6*15 
      character  dfolts(n20)*40, pline(n20)*40, wordx(n20)*40,
     +           vectors(n60)*40   
c ***************************************************
c NOTE: CHECK1 to CHECK6 MUST NOT (yet) BE TRANSLATED
c ***************************************************     
      parameter (check1 = 'begin{labels}',
     +           check2 = 'end{labels}',
     +           check3 = 'begin{values}',
     +           check4 = 'end{values}',
     +           check5 = 'begin{indicators}',
     +           check6 = 'end{indicators}' )  
      character  no_labels*11
      parameter (no_labels = '%no_labels%')
      logical    abort, ok, there
      logical    check1_there, check2_there
      external   putfat, triml1, eofcha, labels
      external   putadv
      intrinsic  min                         

c
c check and initialise
c
      if (ncol.lt.1 .or. nrow.lt.1 .or. nword.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif
      check1_there = .false.
      check2_there = .false.
c
c define nsav depending on isend...nsav must not be changed again
c      
      k = 0
      if (isend.eq.1) then
c
c isend = 1: rows only
c
         nsav = nrow
         nsav_r = nrow
         nsav_c = 0
         do i = 1, min(nrow, nword)
            k = k + 1
            write (word6,'(i6)') i
            call triml1 (word6)
            word(i) = word6
         enddo
         if (nrow.gt.nword) then
            write (line,200) 'NROW > NWORD'
            call putfat (line)
            return
         endif
      elseif (isend.eq.2) then
c
c isend = 2: columns only
c
         nsav = ncol
         nsav_c = ncol
         nsav_r = 0
         do i = 1, min(ncol, nword)
            k = k + 1
            write (word6,'(i6)') i
            call triml1 (word6)
            word(i) = word6
         enddo
         if (ncol.gt.nword) then
            write (line,200) 'NCOL > NWORD'
            call putfat (line)
            return
         endif
      elseif (isend.eq.3) then
c
c isend = 3: rows then columns
c
         nsav = nrow + ncol
         nsav_c = ncol
         nsav_r = nrow
         do i = 1, nrow
            if (i.le.nword) then
               k = k + 1
               write (word6,'(i6)') i
               call triml1 (word6)
               word(i) = 'R'//word6
            endif
         enddo       
         j = nrow
         do i = 1, ncol 
            j = j + 1
            if (j.le.nword) then
               k = k + 1
               write (word6,'(i6)') i
               call triml1 (word6)
               word(j) = 'C'//word6
            endif
         enddo
         if (ncol + nrow.gt.nword) then
            write (line,200) 'NCOL + NROW > NWORD'
            call putfat (line)
            return
         endif
      else   
c
c isend < 1 or isend > 3: error exit
c      
         write (line,300)
         call putfat (line)
         return
      endif
c
c return if k > nwmax or filename is blank or does not exist
c
      if (k.gt.nwmax) return
      inquire (file = fname, exist = there)
      if (.not.there) then
         write (line,400)
         call putfat (line)
         return
      endif
c                   
c Method 1:
c =========
c attempt to extract nsav labels using eofcha 
c
      ierr = 0
      if (allocated(wtemp)) deallocate(wtemp, stat = ierr)
      if (ierr.ne.0) return
      allocate(wtemp(nsav), stat = ierr)
      if (ierr.ne.0) return  
      call eofcha (nsav,
     +             fname, wtemp,
     +             abort)
c
c check if eofcha has located label(1) = '%no_labels%'
c     
      if (.not.abort) then
         if (wtemp(1).eq.no_labels) then  
            word(1) = no_labels
            deallocate(wtemp, stat = ierr)
            return
         endif   
      endif      
      if (.not.abort) then  
c
c eofcha has read nsav putative labels so check if they are all allowed
c      
         ok = .true.
         i = 0   
         k = 0
         do while (ok .and. i.lt.nsav)
            i = i + 1
            temp = wtemp(i)
            j = 0
            do while (ok .and. j.lt.6)
               j = j + 1 
               if (j.eq.1) then
                  if (index(temp,check1).ne.0) then
                     ok = .false.
                     check1_there = .true.
                  endif   
               elseif (j.eq.2) then
                  if (index(temp,check2).ne.0) then
                     ok = .false.
                     check2_there = .true.
                  endif   
               elseif (j.eq.3) then      
                  if (index(temp,check3).ne.0) ok = .false.
               elseif (j.eq.4) then   
                  if (index(temp,check4).ne.0) ok = .false.
               elseif (j.eq.5) then   
                  if (index(temp,check5).ne.0) ok = .false.
               elseif (j.eq.6) then   
                  if (index(temp,check6).ne.0) ok = .false.
               endif 
            enddo
            if (ok) k = k + 1  
         enddo 
         if (k.eq.nsav) then 
c
c all nsav labels are allowed so accept them
c         
            do i = 1, nsav 
               word(i) = wtemp(i)
            enddo
         endif  
         deallocate(wtemp, stat = ierr)
         return
      endif
c          
c Method 2:
c =========
c eofcha has failed so try to read the title, header and data then nsav labels
c                         
      ierr = 0
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return  
      allocate(x(ncol), stat = ierr)
      if (ierr.ne.0) return 
      close (unit = nin)
      open (unit = nin, file =  fname, iostat = ios)
      if (ios.eq.0) read (nin,'(a)',iostat=ios) temp
      if (ios.eq.0) read (nin,*,iostat=ios) isav, jsav
      if (ios.eq.0) then
         if (isav.ne.nrow) ios = 1
         if (jsav.ne.ncol) ios = 1
         if (ios.eq.0) then  
            i = 0
            do while (ios.eq.0 .and. i.lt.nrow)
               i = i + 1
               read (nin,*,iostat=ios) (x(j), j = 1, ncol)
            enddo
         endif   
      endif
      if (ios.ne.0) then   
c
c return as data could not be read from the file
c      
         close (unit = nin)
         write (line,500)
         call putfat (line)  
         deallocate(x, stat = ierr)
         deallocate(wtemp, stat = ierr)
         return
      endif
c
c Initialise k then try to read labels from the top of the trailer
c    
      k = 0
      read (nin,*,iostat=ios) isav
      if (ios.eq.0 .and. isav.ge.1) then
c
c always read the first label in case it is '%no_labels%'
c        
         i = 0
         do while (ios.eq.0 .and. i.lt.nsav)
            i = i + 1
            read (nin,'(a)',iostat=ios) temp
            if (ios.eq.0) then 
               if (i.eq.1 .and. temp.eq.no_labels) then
                  close (unit = nin)
                  word(1) = temp
                  deallocate(x, stat = ierr)
                  deallocate(wtemp, stat = ierr)
                  return
               endif   
               ok = .true.
               j = 0
               do while (ok .and. j.lt.6)
                  j = j + 1 
                  if (j.eq.1) then
                     if (index(temp,check1).ne.0) then
                        ok = .false.
                        check1_there = .true.
                     endif   
                  elseif (j.eq.2) then
                     if (index(temp,check2).ne.0) then
                        ok = .false.
                        check2_there  = .true.
                     endif    
                  elseif (j.eq.3) then      
                     if (index(temp,check3).ne.0) ok = .false.
                  elseif (j.eq.4) then   
                     if (index(temp,check4).ne.0) ok = .false.
                  elseif (j.eq.5) then   
                     if (index(temp,check5).ne.0) ok = .false.
                  elseif (j.eq.6) then   
                     if (index(temp,check6).ne.0) ok = .false.
                  endif   
               enddo 
               if (ok) then
                  k = k + 1
                  wtemp(k) = temp(1:40)
               else 
                  close (unit = nin)
                  if (check1_there .or. check2_there) then
                     write (line,600) nsav
                     call putadv (line)
                  endif   
                  deallocate(x, stat = ierr)
                  deallocate(wtemp, stat = ierr) 
                  return    
               endif   
            endif
c
c cancel the loop if isav < nsav
c            
            if (isav.lt.nsav) ios = -1
         enddo
      endif
      close (unit = nin)
      if (k.lt.nsav) then
c
c could not read all nsav labels
c
         if (nsav_c + nsav_r.le.nwmax) then
            if (check1_there .or. check2_there) then
               write (line,600) nsav
               call putadv (line)
            endif   
         endif   
         if (nsav.le.n20) then
            call labels (n1, jcolor, kfill,
     +                   dfolts, pline, wordx, vectors)
            do i = 1, nsav
               word(i) = dfolts(i)
            enddo
         endif                  
      else   
c
c otherwise copy wtemp into word
c      
         do i = 1, nsav
            word(i) = wtemp(i)
         enddo   
      endif                     
      deallocate(x, stat = ierr)
      deallocate(wtemp, stat = ierr)
c
c format statements
c
  100 format (
     +'NCOL < 1, NROW < 1, or NWORD < 1 in call to GETWRD')
  200 format (
     +'Too many labels requested ...',1x,a,1x,'in call to GETWRD')
  300 format (
     +'ISEND out of range in call to GETWRD')
  400 format (
     +'File supplied to GETWRD was not not found')
  500 format (
     +'Plot labels could not be initialised from the data file')
  600 format (
     +'begin{labels} ...end{labels} did not initialise all',i5,1x,
     +'labels from the data file')
      end
c
c
