C
C
      SUBROUTINE GOSTOP (NOUT,
     +                   FNAME1, FNAME2, PNAME,
     +                   ABORT)
C
C ACTION : Declare end and files used then ask if a repeat run is required
C          Derived from STOPGO by adding facility to review progress
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 5/3/94
C          04/02/1998 Added call to view data file
C          26/02/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT 
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME1, FNAME2, PNAME 
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, N1,
     +           N2, N3, N4, N20
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1,
     +           N1 = 1, N2 = 2, N3 = 3, N4 = 4, N20 = 20)
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      INTEGER    NUMBLD(N20), NUMPOS(N4)
      INTEGER    NTEXT
      CHARACTER  LINE*100, TEXT(30)*100, TRIM80*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    REPEET
      LOGICAL    BORDER, FLASH, HIGH, SUPPLY
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, REVPRO, VIEWER, TRIM80
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / N4*1 /
C
C Initialise
C
      NUMBLD(N1) = N4
      NTEXT = N1
      WRITE (TEXT(NTEXT),100) PNAME
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = BLANK
      IF (FNAME1.EQ.BLANK) THEN
         SUPPLY = .FALSE.
         NUMOPT = N3
      ELSE
         SUPPLY = .TRUE.
         NUMOPT = 4
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Input data were contained in the file'
         NTEXT = NTEXT + N1
         LINE = TRIM80(FNAME1)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK
      ENDIF
      IF (FNAME2.NE.BLANK) THEN
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = 'Results have been written to the file'
         NTEXT = NTEXT + N1
         LINE = TRIM80(FNAME2)
         TEXT(NTEXT) = LINE
         NUMBLD(NTEXT) = N1
         NTEXT = NTEXT + N1
         TEXT(NTEXT) = BLANK
      ENDIF
      NTEXT = NTEXT + N1
      NSTART = NTEXT
      TEXT(NTEXT) = 'Review analysis so far'
      IF (SUPPLY) THEN
         NTEXT = NTEXT + 1
         TEXT(NTEXT) = 'View the current data'
      ENDIF
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Run the program again'
      NTEXT = NTEXT + N1
      TEXT(NTEXT) = 'Quit ... Exit program'//BLANK//PNAME
C
C Main loop
C
      REPEET = .TRUE.
      DO WHILE (REPEET)
         NUMDEC = N1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT, 
     +                BORDER, FLASH, HIGH)
         REPEET = .FALSE.
         IF (NUMDEC.EQ.N1) THEN
            CALL REVPRO (NOUT)
            REPEET = .TRUE.
         ENDIF
         IF (SUPPLY) THEN
            IF (NUMDEC.EQ.N2) THEN
               CALL VIEWER (ISEND, 
     +                      FNAME1, BLANK, BLANK)
               REPEET = .TRUE.
            ELSEIF (NUMDEC.EQ.N3) THEN
               ABORT = .FALSE.
            ELSE
               ABORT = .TRUE.
            ENDIF
         ELSE
            IF (NUMDEC.EQ.N2) THEN
               ABORT = .FALSE.
            ELSE
               ABORT = .TRUE.
            ENDIF
         ENDIF
      ENDDO
C
C Format statement
C      
  100 FORMAT ('Program',1X,A,1X,'has completed the analysis')
      END
C
C
