C
C
      SUBROUTINE HBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
C
C ACTION : Get a decision from a h-type button box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/2/97
C          01/06/2007 now just calls W_HBOX01
C          06/03/2012 added error messages 
C
      IMPLICIT  NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IXL, IYL, LSHADE,
     +                                       NUMOPT, NSTART, NTEXT
      INTEGER,             INTENT (IN)    :: NUMBLD(NTEXT),
     +                                       NUMPOS(NUMOPT)
      INTEGER,             INTENT (INOUT) :: NUMDEC
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NTEXT)
      LOGICAL,             INTENT (IN)    :: BORDER, FLASH, HIGH 
C
C Locals
C      
      EXTERNAL  W_HBOX01, PUTFAT
      IF (NSTART.LT.1) THEN
         CALL PUTFAT ('NSTART < 1 in call to HBOX01')
         RETURN
      ENDIF
      IF (NTEXT.LT.1) THEN
         CALL PUTFAT ('NTEXT < 1 in call to HBOX01')
         RETURN
      ENDIF
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to HBOX01')
         RETURN   
      ENDIF   
      IF (NSTART + NUMOPT - 1.GT.NTEXT) THEN
         CALL PUTFAT ('NSTART + NUMOPT - 1 > NTEXT in call to HBOX01')
         RETURN
      ENDIF
      IF (NUMDEC.LT.1 .OR. NUMDEC.GT.NUMOPT) THEN
         CALL PUTFAT ('NUMDEC out of range in call to HBOX01')
         NUMDEC = NUMOPT
         RETURN
      ENDIF        
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF 
      CALL W_HBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +               NUMOPT, NUMPOS, NSTART, NTEXT,
     +               TEXT,
     +               BORDER, FLASH, HIGH)
      END
C
C
