c
c
       subroutine html00 (nin, nlines, nrmax, 
     +                    fname, matrix, strng)           
c
c action: parse a putative html file from Excel, etc.
c author: w.g.bardsley, university of manchester, u.k., 21/04/2008
c         21/07/2008 also accepts .htm, .mht and .mhtml files
c         31/08/2008 corrected error thinking <> were included in string
c         20/04/2009 now also checks for upper case and replaces commas by full stops inside > <
c         27/11/2014 decreased nmax from 10^7 to 10^5
c         09/08/2022 added two blanks when a cell is closed by "<"   
c         14/08/2022 completely new simplified version calling a completely new version of html01               
c
c    nin: (input/unchanged) unconnected unit for file opening
c nlines: (output) number of lines read from new_file
c  nrmax: (input/unchanged) dimension of matrix
c  fname: (input/unchanged) supposed html, etc. file
c matrix: (output) table read from the file
c  strng: (output) workspace  
c
      implicit none
c
c arguments
c          
      integer,             intent (in)  :: nin, nrmax
      integer,             intent (out) :: nlines 
      character (len = *), intent (in)  :: fname
      character (len = *), intent (out) :: matrix(nrmax), strng
c
c locals
c      
      integer    icount, l, ios
      integer    len200
      character  new_file*1024 
      character  ext3*3, ext4*4, ext5*5
      logical    abort, there
      external   len200, lcase1, html01
      intrinsic  len, index, char
c
c initialise then open the file
c      
      nlines = 0
      if (nin.lt.1 .or. nrmax.lt.1) return
      l = len(strng)
      if (l.lt.1) return  
      inquire (file = fname, exist = there)
      if (.not.there) return
      l = len200(fname)
      if (l.lt.5) return
      icount = index(fname, '.', back = .true.)
      if (l - icount.eq.3) then
         ext3 = fname(icount + 1:l)
         call lcase1 (ext3)
         if (ext3.ne.'htm' .and. ext3.ne.'mht') return
      elseif (l - icount.eq.4) then     
         ext4 = fname(icount + 1:l)
         call lcase1 (ext4)
         if (ext4.ne.'html') return
      elseif (l - icount.eq.5) then     
         ext5 = fname(icount + 1:l)
         call lcase1 (ext5)
         if (ext5.ne.'mhtml') return           
      else
         return
      endif      
c
c copy the file into buffer then parse and write out to a new_file
c

        
      close (unit = nin) 
      call html01 (nin, nrmax,
     +             fname, matrix, new_file,
     +             abort)
      close (unit = nin)
      if (abort) then
        return 
      else
         close (unit = nin)
         open (unit = nin, file = new_file, iostat = ios)
         do while (ios.eq.0) 
            read (nin,'(a)',iostat=ios) strng
            if (ios.eq.0) then
               nlines = nlines + 1
               matrix(nlines) = strng
            endif    
         enddo  
         close (unit = nin)
         return
      endif
      end   
c
c  
