c
c
      subroutine html01 (nin, nrmax,
     +                   fname, matrix, new_file, 
     +                   abort)
c
c action: completetly new version: preliminary editing of html files for analysis by subroutine html00
c author: w.g.bardsley, university of manchester, u.k., 14/8/2022 
c
c Makes sure blanks are removed and all cells/lines have got closure tags,i.e., </td> and/or </tr>
c Result is in lower case with no blanks and is written to the output file called new_file        
c 
c aruments
c    
      integer,             intent (in)  :: nin, nrmax
      character (len = *), intent (in)  :: fname
      character (len = *), intent (out) :: matrix(nrmax)
      character (len = *), intent (out) :: new_file 
      logical,             intent (out) :: abort  
c
c locals
c       
      integer    i, ios, j, k, l, ncomma, ncomma1, nlines, nrow
      character (len = 1024) line
      character (len = 250 ) strng 
      character (len = 12  ) form12, word12
      character (len = 10  ) word10
      character (len = 5   ) word5
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    istart, istop
      external   lcase1, form12, triml2
      external   putadv, v7path
      intrinsic  index
c
c initialise abort
c     
      abort = .true. 
c
c open the input file and initialise
c      
      open (unit = nin, file = fname, iostat = ios)
      istart = .false.
      istop = .false.
      nlines = 0
      line = blank
c
c read lines for a matrix then close the file
c     
      ios = 0 
      do while (ios.eq.0)
         read (nin,'(a)',iostat=ios) line
         call triml2 (line)
         call lcase1 (line)
         if (line(1:7).eq.'<table>') then! start filling matrix
             istart = .true.
             nlines = nlines + 1 
             matrix(nlines) = line
         elseif (line(1:8).eq.'</table>') then! end filling the matrix
             istop = .true.
             nlines = nlines + 1
             matrix(nlines) = line
             exit
         elseif (istart .and. .not.istop) then! proceed with filling the matrix
            nlines = nlines + 1
            matrix(nlines) = line
         endif    
      enddo
      close (unit = nin)
c
c error if no <table>...</table>
c
      if (ios.ne.0 .or. nlines.lt.3) then
         write (strng,100)
         call putadv (strng) 
         close (unit = nin)
         return
      endif   
      nrow = nlines - 2
      do i = 1, nrow
         matrix (i) = matrix(i + 1)
      enddo   
c   
c repair bad line endings
c  
      do i = 1, nrow
         line = blank
         line = matrix(i)
         k = len_trim(line)
         word10 = line(k - 9:k)
         word5 = line(k - 4:k)
         if (word10.ne.'</td></tr>') then
            if (word5.eq.'</td>' .or. word5.eq.'</tr>') then
               line(k:k + 9) = '</td></tr>'
            else
               line(k + 1:k + 10) = '</td></tr>'
            endif   
         endif  
         matrix(i) = line 
      enddo
c
c replace tokens by commas/blanks
c
      do i = 1, nrow
         line = matrix(i)
         k = len_trim(line)
         do j = 1, k
            if (line(j:j + 7).eq.'<tr><td>') then
               do l = j, j + 7   
                  line(l:l) = blank
               enddo 
            elseif (line(j:j + 9).eq.'</td></tr>') then
               do l = j, j + 9
                  line(l:l) = blank
               enddo    
               exit
            elseif (line(j:j + 3).eq.'<td>') then 
               line(j:j) = ','
               do l = j + 1, j + 3
                  line(l:l) = blank
               enddo
            elseif (line(j:j + 4).eq.'</td>') then
               do l = j , j + 4
                  line(l:l) = blank
               enddo 
            endif      
         enddo
         matrix(i) = line
      enddo  
c
c check for empty cells
c      
      do i = 1, nrow                         
         line = matrix(i) 
         k = len_trim(line)
         do j = 1, k - 1
            if (line(j:j + 1).eq.',,') then
                close (unit = nin)
                word12 = form12(i - 1)
                write (strng,200) word12
                call putadv (strng)  
                return
            endif
         enddo  
      enddo    
c
c check or all rows having the same number of cells 
c
       do i = 1, nrow 
          line = matrix(i)
          k = len_trim(line)
          ncomma = 0
          do j = 1, k
             if (line(j:j).eq.',') ncomma = ncomma + 1
          enddo
          if (i.eq.1) then
             ncomma1 = ncomma 
          elseif (ncomma.ne.ncomma1) then
             word12 = form12(i - 1)
             write (strng,300) word12
             call putadv (line)
             return
         endif 
      enddo 
c
c remove commas
c                      
      do i = 1, nrow
         line = matrix(i)
         k = len_trim(line)
         do j = 1, k
            if (line(j:j).eq.',') line(j:j) = blank 
         enddo
         matrix(i) = line     
      enddo        
c               
c open new_file and write out the valid part of the html file
c      
      call v7path (k,
     +             'tmp', strng)      
      if (strng(k:k).ne.'\') then
         k = k + 1
         strng(k:k) = '\'
      endif   
      new_file = strng(1:k)//'maksim_html.html'
      open (unit = nin, file = new_file, iostat = ios)
      do i = 1, nrow
         write (nin,'(a)',iostat=ios) trim(matrix(i))
      enddo
      close (unit = nin)
c
c success so set abort = .false.
c      
      abort = .false.
c
c format statements
c      
  100 format ('This is not a valid html matrix file')  
  200 format ('Empty cell encountered at table row ', A)
  300 format ('Number of cells differs from previous row at row ',A) 
      end
c
c
