c
c
      subroutine i2file (nout, n_1, n_2)
c
c action: write n_1 and n_2 to file connected to unit = nout
c author: w.g.bardsley, university of manchester, u.k., 23/06/2006
c                          
c nout: (input/unchanged) unit connected for output of results
c  n_1: (input/unchanged) arbitrary integer
c  n_2: (input/unchanged) arbitrary integer
c
      implicit none
c
c arguments
c
      integer, intent (in) :: nout, n_1, n_2 
c
c locals
c
      integer    ios, l_1, l_2
      integer    len200
      character  header*28, word12_1*12, word12_2*12
      character  blank*1
      parameter (blank = ' ')
      external   triml1, putios, len200
c
c write n1 and n2 to internal records using format i12
c
      write (word12_1,'(i12)',iostat=ios) n_1
      if (ios.ne.0) then
         call putios (ios, 'I2FILE')
         return
      endif
      write (word12_2,'(i12)',iostat=ios) n_2
      if (ios.ne.0) then
         call putios (ios, 'I2FILE')
         return
      endif
c
c trim the records
c
      call triml1 (word12_1)
      call triml1 (word12_2)
      l_1 = len200 (word12_1)
      l_2 = len200 (word12_2)
c
c write significant digits with two blanks for separators
c      
      header = blank
      header(3:l_1 + 2) = word12_1(1:l_1)
      header(l_1 + 5: l_1 + l_2 + 6) = word12_2(1:l_2)
      write (nout,'(a)',iostat=ios) header
      if (ios.ne.0) call putios (ios, 'I2FILE')
      end
c
c

