c
c
      subroutine isitcv (isend, ncol, nrmax, nrow,
     +                   a,
     +                   abort)
c
c action: check if matrix a is a covariance/correlation matrix
c author: w.g.bardsley, university of manchester, u.k., 25/06/2005 
c         26/02/2007 added intents 
c         13/12/2016 introduced epsi and rtol as previous tests proved unsatisfactory with 64-bit version
c
c         isend: (input/unchanged) as follows:
c                isend = 1, just check if square
c                isend = 2, also check if symmetrical
c                isend = 3, also check for positive diagonals
c                isend = 4, also check diagonals = 1, -1 =< a(i,j) =< 1
c                           i.e. stricter check for correlation matrix
c          ncol: (input/unchanged) dimension
c         nrmax: (input/unchanged) dimension
c          nrow: (input/unchanged) dimension
c             a: (input/unchanged) data matrix
c         abort: (output) error indicator
c
      implicit   none
c
c arguments
c
      integer,          intent (in)  :: isend, ncol, nrmax, nrow
      double precision, intent (in)  :: a(nrmax,ncol)
      logical,          intent (out) :: abort
c
c locals
c
      integer    i, j
      double precision bot, top
      double precision epsi, rtol, zero, one, two
      parameter (epsi = 1.0d-07, rtol = 1.0d-300, zero = 0.0d+00,
     +           one = 1.0d+00, two = 2.0d+00)
      character (len = 100) line
      external   putfat
      intrinsic  abs
c
c initialise abort then check isend
c
      abort = .true.
      if (isend.lt.1 .or. isend.gt.4) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c is it square
c
      if (ncol.lt.1 .or. nrow.lt.1 .or. ncol.ne.nrow) then
         write (line,200)
         call putfat (line)
         return
      endif
c
c is it symmetrical
c
      if (isend.gt.1) then
         do i = 2, nrow
            do j = 1, i - 1
               top = abs(a(i,j) - a(j,i))
               bot = rtol + (abs(a(i,j)) + abs(a(j,i)))/two
               if (top/bot.gt.epsi) then
                  write (line,300) i, j, j, i
                  call putfat (line)
                  return
               endif
            enddo
         enddo
      endif
c
c is the diagonal positive
c
      if (isend.gt.2) then
         do i = 1, nrow
            if (a(i,i).lt.zero) then
               write (line,400) i, i
               call putfat (line)
               return
            endif
         enddo
      endif
c
c are diagonals all 1 and also -1 =< a(i,j) =< 1 otherwise
c
      if (isend.eq.4) then
         do i = 1, nrow
            if (abs(a(i,i) - one).gt.epsi) then
               write (line,500) i, i
               call putfat (line)
               return
            endif
         enddo
         top = one + epsi
         bot = - top
         do i = 2, nrow
            do j = 1, i - 1
               if (a(i,j).lt.bot) then
                  write (line,600) i, j
                  call putfat (line)
                  return
               elseif (a(i,j).gt.top) then
                  write (line,700) i, j
                  call putfat (line)
                  return
               endif
            enddo
         enddo
      endif       
c
c all is well so set abort = .false.
c      
      abort = .false.               
c
c format statements
c      
  100 format ('ISEND out of range in call to ISITCV')
  200 format ('NCOL < 1, NROW < 1, or Matrix not square')
  300 format ('A(',i6,',',i6,') not equal to A(',i5,',',i5,')')
  400 format ('A(',i6,',',i6,') < 0')
  500 format ('A(',i6,',',i6,') not equal to 1')
  600 format ('A(',i6,',',i6,') < -1 ?')
  700 format ('A(',i6,',',i6,') > 1 ?')
      end
c
c
