C
C
      SUBROUTINE ISITLF (FNAME,
     +                   YESNO)
C
C ACTION : Is it a library file ?
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/2/98
C          07/01/2007 added call to SIMDIR 
C          19/01/2007 made sure Simfit folder exists before using as a prefix 
C          19/07/2007 changed SIMDIR to DEMDIR and treat blank line as EOF
C          24/08/2018 added call to ISITMF 
C
C          This routine reads until EOF or blank line and checks for files
C          If a simple file is not found the Simfit folder will also be searched 
C
C FNAME: (input/unchanged) library file 
C YESNO: (OUTPUT) as follows
C         YESNO = TRUE: at least one file specified and all exist
C         YESNO = FALSE: Only a title or missing file/bad filename
C
      IMPLICIT   NONE
C
C Arguments
C          
      CHARACTER  (LEN = *), INTENT (IN)  :: FNAME
      LOGICAL,              INTENT (OUT) :: YESNO
C
C Locals
C      
      INTEGER    IOS, L, L1, L2, LEN200, NIN, NLINES
      INTEGER    NCOL, NROW
      CHARACTER  LINE*1024, SIMFIT*1024, TEMP*1024
      CHARACTER (LEN = 100) INFO 
      CHARACTER  BLANK*1, BSLASH*1
      PARAMETER (BLANK = ' ', BSLASH = '\') 
      LOGICAL    THERE
      EXTERNAL   GETNOU, LEN200, DEMDIR, TRIML1, PUTADV, ISITMF 
      INTRINSIC  INDEX
C
C Initialise YESNO
C
      YESNO = .FALSE. 
C
C Check that FNAME exists
C     
      IF (FNAME.EQ.BLANK) RETURN                   
      INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
      IF (.NOT.THERE .OR. IOS.NE.0) THEN
         CALL PUTADV ('Supposed library/data file cannot be located') 
         RETURN
      ENDIF  
      CALL ISITMF (NCOL, NROW,
     +             FNAME)
      IF (NCOL.GT.0 .AND. NROW.GT.0) RETURN
      CALL GETNOU (NIN)
      IF (NIN.LT.1) RETURN
C
C Check for > 1 lines
C
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) THEN  
C
C Cannot open file
C      
         CLOSE (UNIT = NIN)
         CALL PUTADV ('Cannot open supposed library file')
         RETURN
      ENDIF   
      READ (NIN,'(A)',IOSTAT=IOS) LINE
      IF (IOS.NE.0) THEN  
C
C Cannot read the title 
C      
         CLOSE (UNIT = NIN)
         CALL PUTADV ('Cannot read first line of supposed library file')
         RETURN
      ENDIF   
      IOS = 0
      NLINES = 0
      DO WHILE (IOS.EQ.0)
         READ (NIN,'(A)',IOSTAT=IOS) LINE
         IF (IOS.EQ.0) THEN
            IF (LINE.EQ.BLANK) THEN
               IOS = - 1
            ELSE
               NLINES = NLINES + 1
            ENDIF   
         ENDIF   
      ENDDO
      IF (NLINES.LT.1) THEN
C
C No files specified
C      
         CLOSE (UNIT = NIN)
         CALL PUTADV ('No files specified in supposed library file')
         RETURN  
      ENDIF      
C
C Check the successive lines
C
      CALL DEMDIR (L,
     +             SIMFIT)         
      REWIND (UNIT = NIN)
      READ (NIN,'(A)',IOSTAT=IOS) LINE
      IF (IOS.NE.0) THEN
         CLOSE (UNIT = NIN)
         CALL PUTADV ('Canot read first line of supposed library file')
         RETURN
      ENDIF 
      THERE = .FALSE.
      NLINES = 0
      DO WHILE (IOS.EQ.0)
         READ (NIN,'(A)',IOSTAT=IOS) LINE 
         IF (IOS.EQ.0 .AND. LINE.EQ.BLANK) IOS = -1
         IF (IOS.EQ.0) THEN
            NLINES = NLINES + 1 
            INQUIRE (FILE = LINE, EXIST = THERE, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. .NOT.THERE) THEN 
C
C Also look in the Simfit folder if it exists
C            
               IF (L.GT.0 .AND. INDEX(LINE,BSLASH).LE.0) THEN  
                  TEMP = LINE
                  CALL TRIML1 (TEMP)
                  L1 = 1
                  L2 = LEN200(TEMP)
                  LINE = SIMFIT(L1:L)//TEMP(L1:L2) 
                  INQUIRE (FILE = LINE, EXIST = THERE, IOSTAT = IOS)
               ENDIF
            ENDIF   
            IF (.NOT.THERE .OR. IOS.NE.0) THEN
               CLOSE (UNIT = NIN)
               WRITE (INFO,100) NLINES
               CALL PUTADV (INFO)  
               RETURN
            ENDIF   
         ENDIF   
      ENDDO
C
C All files referenced have been located
C      
      IF (NLINES.GT.0) YESNO = .TRUE.
      CLOSE (UNIT = NIN)
  100 FORMAT ('Missing file specified at supposed library file line',i4)      
      END
C
C
