c
c isitmf
c check_dimensions
c
      subroutine isitmf (ncol, nrow,
     +                   fname)
c
c action: test if fname is a Simfit matrix file
c author: w.g.bardsley, university of manchester, u.k., 19/01/2006 
c         26/02/2006 added intents
c         22/08/2008 now ncol and nrow are diagnostic
c         07/08/2022 added call to subroutine check_dimensions 
c
c          ncol: (output) =< 0 for error, or else number of columns > 0 if OK
c          nrow: (output) =< 0 for error, or else number of rows > 0 if OK
c         fname: (input/unchanged) file to be analysed
c
c  error values: ncol nrow 
c                  -1   -1 ... file does not exist
c                  -2   -2 ... file cannot be opened
c                  -3   -3 ... title cannot be read
c                  -4   -4 ... header dimensions cannot be read
c                  -5   -5 ... cannot read nrow*ncol values   
c
      implicit  none
c
c arguments
c
      integer,             intent (out) :: ncol, nrow
      character (len = *), intent (in)  :: fname
c
c locals
c
      integer    i, ios, j, m, n, nin
      double precision x
      character (len = 100) title
      logical    there
      external   check_dimensions, getnou
c
c initialise ncol = -1, nrow = -1 and check if the file exists
c
      title = 'OK'                                          !to silence NAGfor
      x = 1.0d+00                                           !to silence NAGfor
      if (title.eq.'OK' .and. x.gt.0.0d+00) there = .true.  !to silence NAGfor
      ncol = -1
      nrow = -1
      inquire (file = fname, exist = there, iostat = ios)
      if (there .and. ios.eq.0) then
c
c connect unit = nin to the file
c        
         ncol = -2
         nrow = -2  
         call getnou (nin)
         open (unit = nin, file = fname, iostat = ios)
         read (nin,'(a)',iostat=ios) title
         if (ios.eq.0) then
            ncol = -3
            nrow = -3
            read (nin,'(a)',iostat=ios) title
            if (ios.eq.0) then
               ncol = -4
               nrow = -4
               call check_dimensions (n, m,
     +                                title)  
               if (n.gt.0 .and. m.gt.0) then  
                  i = 0
                  do while (ios.eq.0 .and. i.lt.m)
                     i = i + 1
                     read (nin,*,iostat=ios) (x, j = 1, n)
                  enddo
c
c if m rows and n columns have been read then assign ncol and nrow
c
                  if (ios.eq.0 .and. i.eq.m) then
                     nrow = m
                     ncol = n
                  else
                     ncol = -5
                     nrow = -5   
                  endif
               endif           
            endif
         endif
         close (unit = nin)
      endif
      end
c
c
      subroutine check_dimensions (ncol, nrow,
     +                             line)
c     
c action: check that the second line of a file defines dimensions for a simfit data file
c author: w.g.bardsley, university = of manchester, u.k., 07/08/2022
c
c The code is very much over-the-top and over-complicated but it allows for several future
c possible developments. It now accepts character strings after the integers for instance:
c "24,3  row then column dimensions"  with extra text and commas instead of space separators are acceptable.
c

c
c arguments
c
      integer,                intent (out) :: ncol, nrow
      character (len = *   ), intent (in)  :: line
c
c locals
c      
      integer i, iadd1, ios, j, k, ival(100)
      double precision delta, epsi, xval(100) 
      parameter (epsi = 1.0d-10) 
      character (len = 250) line_copy
      character (len = 1  ) blank
      parameter (blank = ' ')
      intrinsic abs, adjustl, dble, len_trim, min
c
c iinitialise ncol and nrow to correspond to failure at line 2 in subroutine isitmf
c      
      ncol = -4
      nrow = -4
c
c copy line into line_copy and continue analysis
c      
      i = len_trim(line)
      j = min(i,250)
      line_copy = blank
      line_copy(1:j) = line(1:j)
      line_copy = adjustl(line_copy)
      k = len_trim(line_copy)
c      
c find the number of consecutive floating point values
c 
      iadd1 = 0
      ios = 0     
      do j = 1, 100
         read (line_copy(1:k),*,iostat=ios) (xval(i), i = 1, iadd1 + 1)
         if (ios.eq.0) then
            iadd1 = iadd1 + 1
         else
           exit
         endif     
      enddo  
      if (iadd1.ne.2) return
c
c find the number of consecutive integers
c        
      iadd1 = 0
      ios = 0
      do j = 1, 100
         read (line_copy(1:k),*,iostat=ios) (ival(i), i = 1, iadd1 + 1)
         if (ios.eq.0) then
            iadd1 = iadd1 + 1
         else
           exit
         endif     
      enddo  
      if (iadd1.ne.2) return  
c
c make absolutely sure
c      
      j = nint(xval(1))
      delta = dble(j) - xval(1)
      if (abs(delta).gt.epsi) return
      k = nint(xval(2))
      delta = dble(k) - xval(2)
      if (abs(delta).gt.epsi) return
      if (j.gt.0 .and. k.gt.0) then
         nrow = j
         ncol = k
      endif   
      end
c
c      