C
C
      SUBROUTINE ISITPS (NIN,
     +                   X1, X2, Y1, Y2,
     +                   ABORT, IWARNU)
C
C ACTION : Is it a ps file ?
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/12/95
C          24/02/2001 revised 
C          26/02/2007 added INTENTS
C
      IMPLICIT  NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NIN 
      DOUBLE PRECISION, INTENT (OUT) :: X1, X2, Y1, Y2 
      LOGICAL,          INTENT (IN)  :: IWARNU 
      LOGICAL,          INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER   IADD1, IOS
      CHARACTER LINE*1024
      CHARACTER WORD2*2, WORD14*14
      EXTERNAL  PUTFAT, TRIML1
C
C Check for %! on first line
C
      ABORT = .TRUE.
      IADD1 = 1
      READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) LINE
      IF (IOS.NE.0) GOTO 20
      CALL TRIML1 (LINE)
      WORD2 = LINE(1:2)
      IF (WORD2.NE.'%!') THEN
         IF (IWARNU) CALL PUTFAT (
     +      'EPSF files must begin with %! ... File rejected')
         RETURN
      ENDIF
C
C Check for BoundingBox
C
      WORD2 = '%%'
      DO WHILE (WORD2.EQ.'%%')
         IADD1 = IADD1 + 1
         READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) LINE
         IF (IOS.NE.0) GOTO 20
         CALL TRIML1 (LINE)
         WORD2 = LINE(1:2)
         IF (WORD2.NE.'%%') GOTO 20
         WORD14 = LINE(1:14)
         IF (WORD14.EQ.'%%BoundingBox:') THEN
            READ (LINE(15:120),*,END=20,ERR=20,IOSTAT=IOS) X1,Y1,X2,Y2
            IF (IOS.NE.0) GOTO 20
            ABORT = .FALSE.
            RETURN
         ELSEIF (WORD14.EQ.'%%EndComments ') THEN
            GOTO 20
         ENDIF
      ENDDO
C
C Crash: Only get to here if failure to identify .eps characteristics
C ======
C
   20 CONTINUE
      ABORT = .TRUE.
      IF (IWARNU) THEN
         IF (IADD1.EQ.1) THEN
            CALL PUTFAT ('Failure to read %! at line 1')
         ELSE
            WRITE (LINE,200) IADD1
            CALL PUTFAT (LINE)
         ENDIF
      ENDIF
  100 FORMAT (A)
  200 FORMAT (
     +'No EPS %%BoundingBox:x1,y1,x2,y2 in DSC comments 2 to',I3)
      END
C
C
