
c
c
      subroutine isitsf (ncols, nrows,
     +                   fname)
c
c action: see if fname is a simfit data file or can be made into one
c author: w.g.bardsley, university of manchester, u.k., 30/07/2008
c
c on entry: fname must exist
c on exit : If ncols > 0 and nrows > 0 then fname is either the original file or
c           one transformed from it and it is a bona fide simfit data file.
c           If ncols < 1 or nrows < 1 then fname is unchanged and it is not a
c           simfit data file 
c
     
      implicit   none
c
c arguments
c      
      integer,             intent (out)   :: ncols, nrows
      character (len = *), intent (inout) :: fname
c
c allocatable
c    
      integer, allocatable                :: nfield(:)
      character (len = 2048), allocatable :: matrix(:)
      logical,                allocatable :: clash(:), colin(:),
     +                                       rowin(:)               
c      
c locals
c       
      integer    ncmax, nin, nout, nrmax, nwide
      parameter (ncmax = 200, nout = 11, nrmax = 10000,
     +           nwide = 2048)
      integer    ierr          
      character  fname1*1024, fname2*1024, strng*(nwide)
      logical    abort, ready, there
      logical    query, supply
      parameter (query = .false., supply = .true.)
      external   isitmf, maksim_datain, getnou
c
c initialise
c      
      ncols = 0
      nrows = 0
c
c check that the file exists
c      
      inquire (file = fname, exist = there)
      if (.not.there) return
c
c call isitmf
c       
      call isitmf (ncols, nrows,
     +             fname)     
      if (ncols.gt.0 .and. nrows.gt.0) return
c
c call maksim_datain
c         
      ierr = 0
      if (allocated(nfield)) deallocate(nfield, stat = ierr)
      if (ierr.ne.0) return  
      if (allocated(matrix)) deallocate(matrix, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(clash)) deallocate(clash, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(colin)) deallocate(colin, stat = ierr)
      if (ierr.ne.0) return    
      if (allocated(rowin)) deallocate(rowin, stat = ierr)
      if (ierr.ne.0) return    
      allocate(nfield(nrmax), stat = ierr)  
      if (ierr.ne.0) return 
      allocate(matrix(nrmax), stat = ierr)  
      if (ierr.ne.0) return
      allocate(clash(nrmax), stat = ierr)  
      if (ierr.ne.0) return  
      allocate(colin(ncmax), stat = ierr)  
      if (ierr.ne.0) return
      allocate(rowin(nrmax), stat = ierr)  
      if (ierr.ne.0) return 
                 
      fname1 = fname
      call getnou (nin)
      call maksim_datain (ncmax, ncols, nfield, nin, nout, nrmax,
     +                    nrows,
     +                    fname1, fname2, matrix, strng,
     +                    abort, clash, colin, query, ready, rowin,
     +                    supply)
      close (unit = nin)
      if (ncols.gt.0 .and. nrows.gt.0) fname = fname2
        
      deallocate(nfield, stat = ierr)   
      deallocate(matrix, stat = ierr)   
      deallocate(clash, stat = ierr)   
      deallocate(colin, stat = ierr)   
      deallocate(rowin, stat = ierr)   
      end
c
c      