c
c
      subroutine labcfg (isend, jcolor, jfill, n,
     +                   label, panel)
c
c action: user friendly interface to configure labels using w_labels
c author: w.g.bardsley, university of manchester, u.k., 14/02/2011
c
c  isend: isend = 1 ... retrieve current defaults   ... return new values
c         isend = 2 ... edit defaults interactively ... return new values
c         isend = 3 ... restore built-in defaults   ... return new values
c         isend = 4 ... over-write current defaults ... use values supplied
c jcolor: colours
c  jfill: fill styles
c      n: dimension 
c  label: piechart segment or barchart labels
c  panel: information panel labels           
c 
c
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, n
      integer,             intent (inout) :: jcolor(n), jfill(n)
      character (len = *), intent (inout) :: label(n), panel(n)
c
c locals
c      
      integer    i
      integer    jsend, nmax
      parameter (jsend = 1, nmax = 20)
      integer    jcolor_1(nmax), jfill_1(nmax)
      character (len = 40) label_1(nmax), panel_1(nmax),
     +                     wordx_1(nmax), vectors_1(3*nmax)  
      character  line*100
      external   x_putfat, w_labels 
c
c check isend
c      
      if (isend.lt.1 .or. isend.gt.4) then
         write (line,100)
         call x_putfat (line)
         return
      endif         
c
c check n
c      
      if (n.lt.1 .or. n.gt.nmax) then
         write (line,200) nmax
         call x_putfat (line)
         return
      endif

c
c retrieve current defaults using jsend = 1
c         
      call w_labels (jsend, jcolor_1, jfill_1,
     +               label_1, panel_1, wordx_1, vectors_1)
      if (isend.eq.1) then 
c
c isend = 1: return current defaults
c        
         do i = 1, n
            jcolor(i) = jcolor_1(i)
            jfill(i) = jfill_1(i)
            label(i) = label_1(i)
            panel(i) = panel_1(i)
         enddo 
      elseif (isend.eq.2 .or. isend.eq.3) then
c
c isend = 2: interactive editing
c isend = 3: install built-in defaults
c      
         call w_labels (isend, jcolor_1, jfill_1,
     +                  label_1, panel_1, wordx_1, vectors_1) 
         do i = 1, n
            jcolor(i) = jcolor_1(i)
            jfill(i) = jfill_1(i)
            label(i) = label_1(i)
            panel(i) = panel_1(i)
         enddo  
      elseif (isend.eq.4) then
c
c isend = 4: install new defaults
c      
         do i = 1, n
            jcolor_1(i) = jcolor(i)
            jfill_1(i) = jfill(i)
            label_1(i) = label(i)
            panel_1(i) = panel(i)
         enddo 
         call w_labels (isend, jcolor_1, jfill_1,
     +                  label_1, panel_1, wordx_1, vectors_1)  
      endif 
c
c format statement
c          
  100 format ('ISEND out of range (1,4) in call to LABCFG')
  200 format ('N out of range (1,',i2,') in call to LABCFG')        
      end
c
c 