C
C
      SUBROUTINE LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NUMSTA, NUMTXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
C
C ACTION : Get a decision from a list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 05/02/1997
C          29/05/2007 now just calls W_LBOX01
C          05/03/2012 added argument checks 
C          01/05/2012 added call to NUMCHK 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: ICOLOR, IXL, IYL, LSHADE,
     +                                       NUMOPT, NUMSTA, NUMTXT
      INTEGER,             INTENT (IN)    :: NUMBLD(NUMTXT), 
     +                                       NUMPOS(NUMOPT)
      INTEGER,             INTENT (INOUT) :: NUMDEC
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
      LOGICAL,             INTENT (IN)    :: BORDER, FLASH, HIGH  
C
C Locals
C
      INTEGER    NSTART, NTEXT 
      EXTERNAL   W_LBOX01, PUTFAT, NUMCHK
C
C Check arguments supplied
C

      NSTART = NUMSTA
      NTEXT = NUMTXT
      IF (NSTART.LT.1) THEN
         CALL PUTFAT ('NUMSTA < 1 in call to LBOX01')
         RETURN
      ENDIF
      IF (NTEXT.LT.1) THEN
         CALL PUTFAT ('NUMTXT < 1 in call to LBOX01')
         RETURN
      ENDIF
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to LBOX01')
         RETURN   
      ENDIF   
      IF (NSTART + NUMOPT - 1.GT.NTEXT) THEN
         CALL PUTFAT ('NUMSTA + NUMOPT - 1 > NUMTXT in call to LBOX01')
         RETURN
      ENDIF
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF 
      CALL NUMCHK (NUMDEC, NUMOPT,
     +            'LBOX01')   
      CALL W_LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +               NUMOPT, NUMPOS, NUMSTA, NUMTXT,
     +               TEXT,
     +               BORDER, FLASH, HIGH)
      END
C
C
