C
C
      SUBROUTINE LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   OPTS)
C
C ACTION : Get a decision from a list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 5/2/97
C          11/09/1998 dimension increased to 101
C          07/01/2001 dimension increased to 500
C          11/07/2005 dimension increased to 2000
C          16/02/2007 added INTENTS and ALLOCATABLES
C
      IMPLICIT   NONE
C
C Arguments
C              
      INTEGER,             INTENT (IN)    :: ICOLOR, IX, IY, NUMOPT,
     +                                       NUMPOS(NUMOPT)
      INTEGER,             INTENT (INOUT) :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: OPTS(NUMOPT)
C
C Local allocatable array
C                         
      INTEGER, ALLOCATABLE :: NUMBLD(:)
C
C Locals
C
      INTEGER    LSHADE, NSTART
      PARAMETER (LSHADE = 0, NSTART = 1)
      INTEGER    I, IERR, JCOLOR, NMAX, NTEXT
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   W_LBOX01
      EXTERNAL   PUTFAT, NUMCHK
C
C Check
C      
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to LBOX02')
         NUMDEC = 1
         RETURN
      ELSEIF (NUMOPT.EQ.1) THEN
         NUMDEC = NUMOPT
         RETURN   
      ENDIF  
      CALL NUMCHK (NUMDEC, NUMOPT,
     +            'LBOX02')
C
C Allocate
C            
      NMAX = NUMOPT  
      IERR = 0
      IF (ALLOCATED(NUMBLD)) DEALLOCATE(NUMBLD, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(NUMBLD(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Proceed
C
      DO I = 1, NUMOPT
         NUMBLD(I) = 0
      ENDDO
      NTEXT = NUMOPT
      IF (ICOLOR.EQ.0 .OR. ICOLOR.EQ.1 .OR. ICOLOR.EQ.4) THEN
         JCOLOR = ICOLOR
      ELSE
         JCOLOR = 7
      ENDIF
      CALL W_LBOX01 (JCOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +               NUMPOS, NSTART, NTEXT,
     +               OPTS,
     +               BORDER, FLASH, HIGH)
      DEALLOCATE(NUMBLD, STAT = IERR)
      END
C
C
