C
C
      SUBROUTINE LBOXM2 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   OPTS)
C
C ACTION : Get decisions from a multi-selection list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          19/02/2001 Developed from lbox02 
C          26/02/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, IX, IY, NUMOPT
      INTEGER,             INTENT (INOUT) :: NUMPOS(NUMOPT)
      INTEGER,             INTENT (IN)    :: NUMDEC 
      CHARACTER (LEN = *), INTENT (IN)    :: OPTS(NUMOPT)
C
C Locals
C      
      INTEGER    LSHADE, NMAX, NSTART
      PARAMETER (LSHADE = 1, NMAX = 500, NSTART = 1)
      INTEGER    I, NUMBLD(NMAX), NTEXT
      INTEGER    JCOLOR
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   W_LBOXM1
C
C Include this code if a dimension check is required
C
      EXTERNAL   PUTFAT
      IF (NUMOPT.GT.NMAX) THEN
         CALL PUTFAT ('Dimension NMAX exceeded in call to LBOXM2')
         RETURN
      ENDIF
C
C Proceed
C
      DO I = 1, NUMOPT
         NUMBLD(I) = 0
      ENDDO
      NTEXT = NUMOPT
      IF (ICOLOR.EQ.0 .OR. ICOLOR.EQ.1 .OR. ICOLOR.EQ.4) THEN
         JCOLOR = ICOLOR
      ELSE
         JCOLOR = 7
      ENDIF
      CALL W_LBOXM1 (JCOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +               NUMPOS, NSTART, NTEXT,
     +               OPTS,
     +               BORDER, FLASH, HIGH)
      END
C
C
