c
c
      subroutine lmhedi (n,
     +                   xl, xm, xh)
c
c action: edit x-low, x-middle, x-high values, e.g. parameters
c author: w.g.bardsley, university of manchester, u.k., 16/04/2004
c         26/02/2007 aded intents 
c
c         n: (input/unchanged) should be > 0
c         xl, xm, xh: returned after editing such that xl =< xm =< xh
c
      implicit none
c
c arguments
c
      integer,          intent (in)    :: n
      double precision, intent (inout) :: xl(n), xm(n), xh(n)
c
c locals
c
      integer    i, nrow
      integer    isend, itype, nrmax, ncol
      parameter (isend = 2, itype = 5, nrmax = 1000, ncol = 3)
      double precision x(nrmax,ncol)
      character  title*80
      parameter (title =
     +'Make sure lower-limit =< start-value =< upper-limit')
      logical    curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .false., weight = .false.)
      external   editor
c
c check n
c
      if (n.le.0) return
c
c set nrow = n then check and copy xl, xm, xh into x
c
      nrow = n
      do i = 1, nrow
         if (xl(i).gt.xm(i)) xl(i) = xm(i)
         if (xm(i).gt.xh(i)) xh(i) = xm(i)
         x(i,1) = xl(i)
         x(i,2) = xm(i)
         x(i,3) = xh(i)
      enddo
c
c edit x
c
      call editor (isend, itype, ncol, nrmax, nrow,
     +             x,
     +             title,
     +             curve, fixcol, fixrow, label, order, weight)
c
c copy x into xl, xm, xh
c
      do i = 1, nrow
         xl(i) = x(i,1)
         xm(i) = x(i,2)
         xh(i) = x(i,3)
         if (xl(i).gt.xm(i)) xl(i) = xm(i)
         if (xm(i).gt.xh(i)) xh(i) = xm(i)
      enddo
      end
c
c
