C
C
      SUBROUTINE LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                   TEXT)
C
C ACTION : Get a decision from a tabbing list box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          26/10/2005 derived from listbx  
C          26/02/2007 added INTENTS and ALLOCATABLE
C          07/04/2016 added call to LVIEW1_EXTRA
C
C NUMBLD: (input/unchanged) 0 = black, 1 = red, etc.
C NUMDEC: (input/output) input as starting item, output as item chosen
C NUMOPT: (input/unchanged) number of options
C NUMSTA: (input/unchanged) number of starting line for menu items
C NUMTXT: (input/unchanged) number of lines in array TEXT
C   TEXT: (input/unchanged) options with extra text if required
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NUMTXT, NUMOPT, NUMSTA
      INTEGER,             INTENT (IN)    :: NUMBLD(NUMTXT)
      INTEGER,             INTENT (INOUT) :: NUMDEC
      CHARACTER (LEN = *), INTENT (IN)    :: TEXT(NUMTXT)
C
C Local allocatable array
C      
      INTEGER, ALLOCATABLE :: NUMPOS(:) 
C
C Locals
C
      INTEGER    IERR, NMAX
      INTEGER    ICOLOR, IX, IY, LSHADE
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    I, J, NGRAVE, NSTART, NTEXT
      CHARACTER  GRAVE*1
      PARAMETER (GRAVE = '`')
      LOGICAL    TITLES
      PARAMETER (TITLES = .FALSE.)
      LOGICAL    BORDER, FLASH, HIGH, STORE
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.,
     +           STORE = .TRUE.)
      EXTERNAL   LVIEW2, PUTFAT, LBOX02, LVIEW1, LBOX01, NUMCHK
      EXTERNAL   LVIEW1_EXTRA
      INTRINSIC  INDEX
C
C Check arguments supplied
C
      NSTART = NUMSTA
      NTEXT = NUMTXT
      IF (NSTART.LT.1) THEN
         CALL PUTFAT ('NUMSTA < 1 in call to LSTBOX')
         RETURN
      ENDIF
      IF (NTEXT.LT.1) THEN
         CALL PUTFAT ('NUMTXT < 1 in call to LSTBOX')
         RETURN
      ENDIF
      IF (NUMOPT.LT.1) THEN
         CALL PUTFAT ('NUMOPT < 1 in call to LSTBOX')
         RETURN   
      ENDIF   
      IF (NSTART + NUMOPT - 1.GT.NTEXT) THEN
         CALL PUTFAT ('NUMSTA + NUMOPT - 1 > NUMTXT in call to LSTBOX')
         RETURN
      ENDIF
      IF (NUMOPT.EQ.1) THEN
         NUMDEC = 1
         RETURN
      ENDIF
      CALL NUMCHK (NUMDEC, NUMOPT,
     +            'LSTBOX')     
C
C Allocate
C         
      IERR = 0
      IF (ALLOCATED(NUMPOS)) DEALLOCATE(NUMPOS, STAT = IERR)
      IF (IERR.NE.0) RETURN
      NMAX = NUMOPT
      ALLOCATE(NUMPOS(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Deal with four possible cases
C
      IF (NSTART.EQ.1 .AND. NUMOPT.EQ.NTEXT) THEN
C
C Type 1: the case where nstart = 1 and numopt = ntext
C =======
C

C
C Check for tabbing
C
         NGRAVE = 0
         DO I = 1, NUMOPT
            NUMPOS(I) = 1 
            IF (NGRAVE.EQ.0) THEN
               IF (INDEX(TEXT(I),GRAVE).GT.0) NGRAVE = NGRAVE + 1
            ENDIF   
         ENDDO
         IF (NGRAVE.GT.0) THEN
C
C Tabbing so call LVIEW2
C
            CALL LVIEW1_EXTRA (NUMTXT, NUMBLD,
     +                         STORE)            
            CALL LVIEW2 (IX, IY, NUMDEC, NUMOPT,
     +                   TEXT,
     +                   TITLES)
         ELSE
C
C No tabbing so call LBOX02
C
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
         ENDIF
      ELSE
C
C Type 2: the case where nstart > 1 or ntext > numopt
C =======
C

C
C Check for tabbing
C
         NGRAVE = 0
         J = NSTART - 1
         DO I = 1, NUMOPT
            J = J + 1
            NUMPOS(I) = 1  
            IF (NGRAVE.EQ.0) THEN
               IF (INDEX(TEXT(J),GRAVE).GT.0) NGRAVE = NGRAVE + 1
            ENDIF   
         ENDDO
         IF (NGRAVE.GT.0) THEN
C
C Tabbing so call LVIEW1
C
            CALL LVIEW1_EXTRA (NUMTXT, NUMBLD,
     +                         STORE)   
            CALL LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT,
     +                   TEXT,
     +                   TITLES)
         ELSE
C
C No tabbing so call LBOX01
C
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
         ENDIF
      ENDIF
      END
C
C
